/*****************************************************************************
 *
 * File: Tabl20_4.ddl
 * Version: 20.4.0
 *
 *****************************************************************************
 * Copyright (c) 2009, HART Communication Foundation, All Rights Reserved
 *****************************************************************************
 *
 * Description:  Specification DD that models the Common Tables Specification
 *
 * Source Specifications
 *      Common Tables Specification         Rev.20.0
 *
 *****************************************************************************
 */

/*****************************************************************************
 * The manufacturer line
 *****************************************************************************
 */
MANUFACTURER STANDARD, DEVICE_TYPE _TABLES, DEVICE_REVISION 20, DD_REVISION 4

/*****************************************************************************
 * Include Files
 *****************************************************************************
 */
#include "macros.h"

/*********************************************************************************
 * Standard Device Type Codes
 */
VARIABLE Standard_model_code    /* 0x0000 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, "Common Tables"      ,   "Interoperable *" },
        { 0x0002, "Universal"          ,   "Interoperable *" },
        { 0x0003, "Common Practice"    ,   "Interoperable *" },
        { 0x0007, "Pressure Universal" ,   "Interoperable *" },
        { 0x0008, "Pressure Common"    ,   "Interoperable *" },
        { 0x0010, "Menu"               ,   "Interoperable *" },
        { 0x0011, "Rosemount Magflow"  ,   "Interoperable *" },
        { 0x0012, "Rosemount Pressure" ,   "Interoperable *" },
        { 0x0013, "Moore Products"     ,   "Interoperable *" },
        { 0x0014, "Siemens Pressure"   ,   "Interoperable *" },
        { 0x0015, "P2 Common"          ,   "Interoperable *" },
        { 0x0016, "PV"                 ,   "Interoperable *" },
        { 0x0018, "Wireless"           ,   "Interoperable *" },
        { 0x0063, "Munge"              ,   "Interoperable *" }
    }
}

/*********************************************************************************
 * Ametek Device Type Codes
 */
VARIABLE Ametek_model_code    /* 0x0003 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0004, [newthermox] ,   "Analytical    Oxygen/Combustion/Methane/CO" },
        { 0x0304, [newthermox] ,   "Analytical    Oxygen/Combustion/Methane/CO" }
    }
}

/*********************************************************************************
 * Instrument Device Type Codes
 */
VARIABLE Brooks_Instrument_model_code    /* 0x000A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [tri20]          ,   "Flow          Totalizer - Rate Indicator" },
        { 0x0002, [brooks38xxva]   ,   "Flow          Variable Area" },
        { 0x0003, [brooks99xxoval] },
        { 0x0004, [quantim]        ,   "Flow          Coriolis Mass" },
        { 0x0A01, [tri20]          ,   "Flow          Totalizer - Rate Indicator" },
        { 0x0A02, [brooks38xxva]   ,   "Flow          Variable Area" },
        { 0x0A03, [brooks99xxoval] },
        { 0x0A04, [quantim]        ,   "Flow          Coriolis Mass" }
    }
}

/*********************************************************************************
 * Daniel Industries Device Type Codes
 */
VARIABLE Daniel_Industries_model_code    /* 0x000D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0014, [gas_usm]    ,   "Flow          Ultrasonic - Gas" },
        { 0x0028, [liquid_usm] ,   "Flow          Ultrasonic - Liquid" },
        { 0x0D14, [gas_usm]    ,   "Flow          Ultrasonic - Gas" },
        { 0x0D28, [liquid_usm] ,   "Flow          Ultrasonic - Liquid" }
    }
}

/*********************************************************************************
 * Delta Device Type Codes
 */
VARIABLE Delta_model_code    /* 0x000E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [ht] },
        { 0x0E01, [ht] }
    }
}

/*********************************************************************************
 * Endress & Hauser Device Type Codes
 */
VARIABLE Endress_Hauser_model_code    /* 0x0011 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0003, [fmu860]          ,   "Level         Ultrasonic" },
        { 0x0004, [fmu861]          ,   "Level         Ultrasonic" },
        { 0x0005, [fmu862]          ,   "Level         Ultrasonic" },
        { 0x0006, [fmr130]          ,   "Level         Radar - Microwave" },
        { 0x0007, [cerabar_s]       ,   "Pressure      Absolute" },
        { 0x0008, [fec12]           ,   "Level         Capacitance" },
        { 0x0009, [deltabar_s]      ,   "Pressure      Differential" },
        { 0x000A, [fmu231]          ,   "Level         Ultrasonic" },
        { 0x000B, [deltapilot]      ,   "Level         Hydrostatic" },
        { 0x000C, [fmr23x]          ,   "Level         Ultrasonic" },
        { 0x000D, [fmp200]          ,   "Level" },
        { 0x000E, [cerabar_m]       ,   "Pressure      Absolute/Relative" },
        { 0x000F, [fmr2xx]          ,   "Level         Microwave" },
        { 0x0010, [fmr53x]          ,   "Level         Microwave" },
        { 0x0011, [fmu4x]           ,   "Level         Ultrasonic" },
        { 0x0012, [fmp4x]           ,   "Level         Radar" },
        { 0x0013, [fmg60]           ,   "Level         Density - Nuclear" },
        { 0x0014, [nrf590]          },
        { 0x0017, [deltabars]       ,   "Pressure      Deltabar S Evolution" },
        { 0x0018, [cerabars]        ,   "Pressure      Cerabar S Evolution" },
        { 0x0019, [cerabar_m_5x]    ,   "Pressure      Absolute/Relative" },
        { 0x001A, [deltapilots]     ,   "Pressure      Deltapilot S Evolution" },
        { 0x001B, [fmu9x]           ,   "Level         Ultrasonic" },
        { 0x001D, [fmi5x]           ,   "Level" },
        { 0x001E, [fmr25x]          ,   "Level         Microwave" },
        { 0x001F, [fmr54x]          ,   "Level         Microwave" },
        { 0x0020, [fmp4x_i]         ,   "Level" },
        { 0x0021, [deltabar_m_5x]   ,   "Pressure      Differential" },
        { 0x0023, [deltapilot_m_5x] ,   "Level         Hydrostatic" },
        { 0x0024, [waterpilot_2x]   ,   "Level         Hydrostatic" },
        { 0x0032, [promag33]        ,   "Flow          Electromagnetic" },
        { 0x0033, [prowirl70]       ,   "Flow          Vortex" },
        { 0x0034, [promass63]       ,   "Flow          Coriolis Mass" },
        { 0x0035, [promag39]        ,   "Flow          Magmeter - Rack Version" },
        { 0x0036, [promag35s]       ,   "Flow          High Performance Magmeter" },
        { 0x0037, [prowirl77]       ,   "Flow          Vortex" },
        { 0x0039, [promass60]       ,   "Flow          Mass" },
        { 0x0040, [proson_f]        ,   "Flow          Ultrasonic" },
        { 0x0041, [promag50]        ,   "Flow          Magnetic" },
        { 0x0042, [promag53]        ,   "Flow          Magnetic" },
        { 0x0043, [promag51]        ,   "Flow          Magnetic - Custody Transfer" },
        { 0x0044, [promag55]        ,   "Flow          Magnetic" },
        { 0x0045, [promag10]        ,   "Flow          Magnetic" },
        { 0x0046, [promag23]        ,   "Flow          2-wire Magnetic" },
        { 0x0050, [promass80]       ,   "Flow          Coriolis Mass" },
        { 0x0051, [promass83]       ,   "Flow          Coriolis Mass" },
        { 0x0052, [promass84]       ,   "Flow          Coriolis Mass - Custody Transfer" },
        { 0x0053, [promass40]       ,   "Flow          Coriolis Mass" },
        { 0x0056, [prowirl72]       ,   "Flow          2-wire Vortex" },
        { 0x0057, [prowirl73]       ,   "Flow          2-wire Vortex" },
        { 0x0058, [pflow90]         ,   "Flow          Ultrasonic" },
        { 0x0059, [pflow93]         ,   "Flow          Ultrasonic" },
        { 0x0061, [pflow92]         ,   "Flow          Ultrasonic" },
        { 0x0062, [pflow91]         ,   "Flow          Ultrasonic" },
        { 0x0064, [at70]            ,   "Flow          Thermal" },
        { 0x0065, [t_mass65]        ,   "Flow          Thermal" },
        { 0x0078, [tmd832]          ,   "Temperature   Head Mounted" },
        { 0x0079, [tmd833]          ,   "Temperature   Compact" },
        { 0x007C, [tmd842]          ,   "Temperature   DIN Rail Mounted" },
        { 0x008C, [mypro_ph]        ,   "Analytical    pH" },
        { 0x008D, [mypro_lfc]       ,   "Analytical    Conductivity - Conductive" },
        { 0x008E, [mypro_lfi]       ,   "Analytical    Conductivity - Inductive" },
        { 0x00B5, [nmt530]          ,   "Temperature   Sensor" },
        { 0x00B6, [nms530]          ,   "Level         Servo" },
        { 0x00C8, [tmt182]          ,   "Temperature   Head Mounted" },
        { 0x00C9, [tmt122]          ,   "Temperature   DIN Rail" },
        { 0x00CA, [tmt162]          ,   "Temperature" },
        { 0x00CB, [tmt142]          ,   "Temperature" },
        { 0x1103, [fmu860]          ,   "Level         Ultrasonic" },
        { 0x1104, [fmu861]          ,   "Level         Ultrasonic" },
        { 0x1105, [fmu862]          ,   "Level         Ultrasonic" },
        { 0x1106, [fmr130]          ,   "Level         Radar - Microwave" },
        { 0x1107, [cerabar_s]       ,   "Pressure      Absolute" },
        { 0x1108, [fec12]           ,   "Level         Capacitance" },
        { 0x1109, [deltabar_s]      ,   "Pressure      Differential" },
        { 0x110A, [fmu231]          ,   "Level         Ultrasonic" },
        { 0x110B, [deltapilot]      ,   "Level         Hydrostatic" },
        { 0x110C, [fmr23x]          ,   "Level         Ultrasonic" },
        { 0x110D, [fmp200]          ,   "Level" },
        { 0x110E, [cerabar_m]       ,   "Pressure      Absolute/Relative" },
        { 0x110F, [fmr2xx]          ,   "Level         Microwave" },
        { 0x1110, [fmr53x]          ,   "Level         Microwave" },
        { 0x1111, [fmu4x]           ,   "Level         Ultrasonic" },
        { 0x1112, [fmp4x]           ,   "Level         Radar" },
        { 0x1113, [fmg60]           ,   "Level         Density - Nuclear" },
        { 0x1114, [nrf590]          },
        { 0x1117, [deltabars]       ,   "Pressure      Deltabar S Evolution" },
        { 0x1118, [cerabars]        ,   "Pressure      Cerabar S Evolution" },
        { 0x1119, [cerabar_m_5x]    ,   "Pressure      Absolute/Relative" },
        { 0x111A, [deltapilots]     ,   "Pressure      Deltapilot S Evolution" },
        { 0x111B, [fmu9x]           ,   "Level         Ultrasonic" },
        { 0x111D, [fmi5x]           ,   "Level" },
        { 0x111E, [fmr25x]          ,   "Level         Microwave" },
        { 0x111F, [fmr54x]          ,   "Level         Microwave" },
        { 0x1120, [fmp4x_i]         ,   "Level" },
        { 0x1121, [deltabar_m_5x]   ,   "Pressure      Differential" },
        { 0x1123, [deltapilot_m_5x] ,   "Level         Hydrostatic" },
        { 0x1124, [waterpilot_2x]   ,   "Level         Hydrostatic" },
        { 0x1132, [promag33]        ,   "Flow          Electromagnetic" },
        { 0x1133, [prowirl70]       ,   "Flow          Vortex" },
        { 0x1134, [promass63]       ,   "Flow          Coriolis Mass" },
        { 0x1135, [promag39]        ,   "Flow          Magmeter - Rack Version" },
        { 0x1136, [promag35s]       ,   "Flow          High Performance Magmeter" },
        { 0x1137, [prowirl77]       ,   "Flow          Vortex" },
        { 0x1139, [promass60]       ,   "Flow          Mass" },
        { 0x1140, [proson_f]        ,   "Flow          Ultrasonic" },
        { 0x1141, [promag50]        ,   "Flow          Magnetic" },
        { 0x1142, [promag53]        ,   "Flow          Magnetic" },
        { 0x1143, [promag51]        ,   "Flow          Magnetic - Custody Transfer" },
        { 0x1144, [promag55]        ,   "Flow          Magnetic" },
        { 0x1145, [promag10]        ,   "Flow          Magnetic" },
        { 0x1146, [promag23]        ,   "Flow          2-wire Magnetic" },
        { 0x1150, [promass80]       ,   "Flow          Coriolis Mass" },
        { 0x1151, [promass83]       ,   "Flow          Coriolis Mass" },
        { 0x1152, [promass84]       ,   "Flow          Coriolis Mass - Custody Transfer" },
        { 0x1153, [promass40]       ,   "Flow          Coriolis Mass" },
        { 0x1156, [prowirl72]       ,   "Flow          2-wire Vortex" },
        { 0x1157, [prowirl73]       ,   "Flow          2-wire Vortex" },
        { 0x1158, [pflow90]         ,   "Flow          Ultrasonic" },
        { 0x1159, [pflow93]         ,   "Flow          Ultrasonic" },
        { 0x1161, [pflow92]         ,   "Flow          Ultrasonic" },
        { 0x1162, [pflow91]         ,   "Flow          Ultrasonic" },
        { 0x1164, [at70]            ,   "Flow          Thermal" },
        { 0x1165, [t_mass65]        ,   "Flow          Thermal" },
        { 0x1178, [tmd832]          ,   "Temperature   Head Mounted" },
        { 0x1179, [tmd833]          ,   "Temperature   Compact" },
        { 0x117C, [tmd842]          ,   "Temperature   DIN Rail Mounted" },
        { 0x118C, [mypro_ph]        ,   "Analytical    pH" },
        { 0x118D, [mypro_lfc]       ,   "Analytical    Conductivity - Conductive" },
        { 0x118E, [mypro_lfi]       ,   "Analytical    Conductivity - Inductive" },
        { 0x11B5, [nmt530]          ,   "Temperature   Sensor" },
        { 0x11B6, [nms530]          ,   "Level         Servo" },
        { 0x11C8, [tmt182]          ,   "Temperature   Head Mounted" },
        { 0x11C9, [tmt122]          ,   "Temperature   DIN Rail" },
        { 0x11CA, [tmt162]          ,   "Temperature" },
        { 0x11CB, [tmt142]          ,   "Temperature" }
    }
}

/*********************************************************************************
 * ABB Device Type Codes
 *     Note: was Fischer and Porter
 */
VARIABLE Fischer_Porter_model_code    /* 0x0012 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0007, [xm2000]     ,   "Flow          Magnetic" },
        { 0x0008, [xe4000]     ,   "Flow          Magnetic" },
        { 0x000E, [vt1000]     ,   "Flow          Vortex" },
        { 0x000F, [vm1000]     ,   "Flow          Vortex" },
        { 0x0019, [xm1000]     ,   "Flow          Magnetic" },
        { 0x001A, [sm1000]     ,   "Flow          Magnetic" },
        { 0x0042, [pth]        ,   "Pressure      Differential" },
        { 0x0050, [tb82ph]     ,   "Analytical    pH" },
        { 0x0051, [tb82orp]    ,   "Analytical    ORP" },
        { 0x0052, [tb82pion]   ,   "Analytical    pION" },
        { 0x0053, [tb82iconc]  ,   "Analytical    IConc" },
        { 0x0054, [tb82cond]   ,   "Analytical    Electrode Conductivity" },
        { 0x0055, [tb82conc]   ,   "Analytical    Electrode Conductivity" },
        { 0x0056, [tb82tecond] ,   "Analytical    Electrode Conductivity" },
        { 0x0057, [tb82teconc] ,   "Analytical    Electrode Conductivity" },
        { 0x0058, [tb82tccond] ,   "Analytical    Toroidal Conductivity" },
        { 0x0059, [tb82tcconc] ,   "Analytical    Toroidal Conductivity" },
        { 0x1207, [xm2000]     ,   "Flow          Magnetic" },
        { 0x1208, [xe4000]     ,   "Flow          Magnetic" },
        { 0x120E, [vt1000]     ,   "Flow          Vortex" },
        { 0x120F, [vm1000]     ,   "Flow          Vortex" },
        { 0x1219, [xm1000]     ,   "Flow          Magnetic" },
        { 0x121A, [sm1000]     ,   "Flow          Magnetic" },
        { 0x1242, [pth]        ,   "Pressure      Differential" },
        { 0x1250, [tb82ph]     ,   "Analytical    pH" },
        { 0x1251, [tb82orp]    ,   "Analytical    ORP" },
        { 0x1252, [tb82pion]   ,   "Analytical    pION" },
        { 0x1253, [tb82iconc]  ,   "Analytical    IConc" },
        { 0x1254, [tb82cond]   ,   "Analytical    Electrode Conductivity" },
        { 0x1255, [tb82conc]   ,   "Analytical    Electrode Conductivity" },
        { 0x1256, [tb82tecond] ,   "Analytical    Electrode Conductivity" },
        { 0x1257, [tb82teconc] ,   "Analytical    Electrode Conductivity" },
        { 0x1258, [tb82tccond] ,   "Analytical    Toroidal Conductivity" },
        { 0x1259, [tb82tcconc] ,   "Analytical    Toroidal Conductivity" }
    }
}

/*********************************************************************************
 * Fisher Controls Device Type Codes
 */
VARIABLE Fisher_Controls_model_code    /* 0x0013 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0003, [dvc6000]               ,   "Valve         Positioner" },
        { 0x0005, [dvc2000]               ,   "Valve         Controller" },
        { 0x0008, [position_monitor_4320] },
        { 0x1303, [dvc6000]               ,   "Valve         Positioner" },
        { 0x1305, [dvc2000]               ,   "Valve         Controller" },
        { 0x1308, [position_monitor_4320] }
    }
}

/*********************************************************************************
 * Foxboro Device Type Codes
 */
VARIABLE Foxboro_model_code    /* 0x0014 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [mag2]            },
        { 0x0002, [iaspt_premium_2] ,   "Pressure" },
        { 0x0003, [cr876]           },
        { 0x0004, [ec876]           },
        { 0x0005, [ph876]           },
        { 0x001D, [imv31]           ,   "Pressure      Multivariable" },
        { 0x001E, [vortex_84]       ,   "Flow          Vortex" },
        { 0x0028, [imt96]           ,   "Flow          Magnetic" },
        { 0x0029, [imt25]           ,   "Flow          Magnetic" },
        { 0x002E, [ia_pressure]     ,   "Pressure" },
        { 0x002F, [imv_25]          ,   "Pressure      Multivariable" },
        { 0x0030, [fox_875ph]       ,   "Analytical    pH/ORP" },
        { 0x0033, [itvortex]        ,   "Flow          Vortex" },
        { 0x0034, [cft50]           ,   "Flow          Coriolis" },
        { 0x0035, [fox_875cr]       ,   "Analytical    Conductivity" },
        { 0x0036, [fox_875ec]       ,   "Analytical    Conductivity" },
        { 0x0038, [rtt15]           ,   "Temperature" },
        { 0x007D, [cft30x]          ,   "Flow          Coriolis" },
        { 0x1401, [mag2]            },
        { 0x1402, [iaspt_premium_2] ,   "Pressure" },
        { 0x1403, [cr876]           },
        { 0x1404, [ec876]           },
        { 0x1405, [ph876]           },
        { 0x141D, [imv31]           ,   "Pressure      Multivariable" },
        { 0x141E, [vortex_84]       ,   "Flow          Vortex" },
        { 0x1428, [imt96]           ,   "Flow          Magnetic" },
        { 0x1429, [imt25]           ,   "Flow          Magnetic" },
        { 0x142E, [ia_pressure]     ,   "Pressure" },
        { 0x142F, [imv_25]          ,   "Pressure      Multivariable" },
        { 0x1430, [fox_875ph]       ,   "Analytical    pH/ORP" },
        { 0x1433, [itvortex]        ,   "Flow          Vortex" },
        { 0x1434, [cft50]           ,   "Flow          Coriolis" },
        { 0x1435, [fox_875cr]       ,   "Analytical    Conductivity" },
        { 0x1436, [fox_875ec]       ,   "Analytical    Conductivity" },
        { 0x1438, [rtt15]           ,   "Temperature" },
        { 0x147D, [cft30x]          ,   "Flow          Coriolis" }
    }
}

/*********************************************************************************
 * Fuji Device Type Codes
 */
VARIABLE Fuji_model_code    /* 0x0015 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [fcx_ac]   ,   "Pressure" },
        { 0x0002, [fcx_a2c2] ,   "Pressure" },
        { 0x0081, [frc]      ,   "Temperature" },
        { 0x1501, [fcx_ac]   ,   "Pressure" },
        { 0x1502, [fcx_a2c2] ,   "Pressure" },
        { 0x1581, [frc]      ,   "Temperature" }
    }
}

/*********************************************************************************
 * ABB Device Type Codes
 *     Note: was Hartmann and Braun
 */
VARIABLE Hartmann_Braun_model_code    /* 0x0016 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0003, [teu471]  },
        { 0x0004, [teu421]  },
        { 0x0005, [teu211]  ,   "Temperature" },
        { 0x0006, [ts11]    ,   "Temperature" },
        { 0x0008, [th02]    ,   "Temperature" },
        { 0x0040, [tzid]    ,   "Valve         Positioner/Pneumatic" },
        { 0x0041, [tzidc]   ,   "Valve         Positioner/Pneumatic" },
        { 0x0085, [as800]   ,   "Pressure" },
        { 0x0087, [contrac] ,   "Valve         Actuator - Electrical" },
        { 0x1603, [teu471]  },
        { 0x1604, [teu421]  },
        { 0x1605, [teu211]  ,   "Temperature" },
        { 0x1606, [ts11]    ,   "Temperature" },
        { 0x1608, [th02]    ,   "Temperature" },
        { 0x1640, [tzid]    ,   "Valve         Positioner/Pneumatic" },
        { 0x1641, [tzidc]   ,   "Valve         Positioner/Pneumatic" },
        { 0x1685, [as800]   ,   "Pressure" },
        { 0x1687, [contrac] ,   "Valve         Actuator - Electrical" }
    }
}

/*********************************************************************************
 * Honeywell Device Type Codes
 */
VARIABLE Honeywell_model_code    /* 0x0017 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [st3000]       ,   "Pressure" },
        { 0x0002, [stt25t]       ,   "Temperature   Dual Input" },
        { 0x0003, [hwflow]       ,   "Flow          Magnetic" },
        { 0x0004, [stt25h]       ,   "Temperature" },
        { 0x0005, [herculine]    ,   "Valve         Actuator" },
        { 0x0006, [smartcet]     ,   "Analytical    Corrosion" },
        { 0x0007, [stt17h]       ,   "Temperature" },
        { 0x0008, [stt2500]      },
        { 0x0009, [stt25s]       ,   "Temperature" },
        { 0x000A, [smartcet5500] },
        { 0x0050, [twm9000]      ,   "Flow          Electromagnetic" },
        { 0x1701, [st3000]       ,   "Pressure" },
        { 0x1702, [stt25t]       ,   "Temperature   Dual Input" },
        { 0x1703, [hwflow]       ,   "Flow          Magnetic" },
        { 0x1704, [stt25h]       ,   "Temperature" },
        { 0x1705, [herculine]    ,   "Valve         Actuator" },
        { 0x1706, [smartcet]     ,   "Analytical    Corrosion" },
        { 0x1707, [stt17h]       ,   "Temperature" },
        { 0x1708, [stt2500]      },
        { 0x1709, [stt25s]       ,   "Temperature" },
        { 0x170A, [smartcet5500] },
        { 0x1750, [twm9000]      ,   "Flow          Electromagnetic" }
    }
}

/**********************************************************************
 * Thermo MeasureTech
 *     Note: was  KayRay
 */
VARIABLE kayray_model_code    /* 0x0019 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0008, [level_4050]         },
        { 0x0009, [density_3680]       ,   "Analytical    Density - Nuclear" },
        { 0x000A, [kayray4790]         ,   "Level         Continuous Gamma" },
        { 0x000B, [accu_pulse_pro]     ,   "Level         Laser Ranging" },
        { 0x000F, [steam_quality_3280] },
        { 0x1908, [level_4050]         },
        { 0x1909, [density_3680]       ,   "Analytical    Density - Nuclear" },
        { 0x190A, [kayray4790]         ,   "Level         Continuous Gamma" },
        { 0x190B, [accu_pulse_pro]     ,   "Level         Laser Ranging" },
        { 0x190F, [steam_quality_3280] }
    }
}

/*********************************************************************************
 * ABB Device Type Codes
 *     Note: was Kent
 */
VARIABLE ABB_model_code    /* 0x001A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [ksx]               ,   "Pressure" },
        { 0x0002, [abb_600t]          ,   "Pressure      Differential" },
        { 0x0003, [abb_2600t_268]     ,   "Pressure      Safety" },
        { 0x0004, [abb_2600t_262_264] ,   "Pressure" },
        { 0x0005, [abb_2600t_364]     ,   "Pressure" },
        { 0x0007, [abb_2600t_266]     ,   "Pressure" },
        { 0x0008, [abb_kst]           ,   "Temperature" },
        { 0x0009, [th01]              ,   "Temperature" },
        { 0x000A, [abb_658t]          ,   "Temperature" },
        { 0x000B, [ttx300_series]     ,   "Temperature" },
        { 0x000C, [abb_652]           ,   "Temperature" },
        { 0x000D, [ttx200]            ,   "Temperature" },
        { 0x000F, [abb_665]           ,   "Valve         Positioner" },
        { 0x0010, [deltapi_kt]        ,   "Valve         Positioner" },
        { 0x0018, [magmaster]         ,   "Flow          Electromagnetic" },
        { 0x001A, [fvs4000]           ,   "Flow          Vortex/Swirl" },
        { 0x001B, [fam540]            ,   "Flow          Variable Area" },
        { 0x001C, [fmt500ig]          ,   "Flow" },
        { 0x001D, [fsm4000]           ,   "Flow          Electromagnetic" },
        { 0x001E, [fex300]            ,   "Flow          Electromagnetic" },
        { 0x001F, [fex100]            ,   "Flow" },
        { 0x0021, [abb_2600ph]        ,   "Analytical    pH" },
        { 0x0023, [tb82ph_comb]       ,   "Analytical    pH" },
        { 0x0024, [tb82ec_comb]       ,   "Analytical    4 Electrode Conductivity" },
        { 0x0025, [tb82te_comb]       ,   "Analytical    2 Electrode Conductivity" },
        { 0x0026, [tb82tc_comb]       ,   "Analytical    Troidal Conductivity" },
        { 0x0027, [fmt300]            ,   "Flow" },
        { 0x0029, [ufte_pa]           },
        { 0x002A, [ufte_ff]           },
        { 0x0030, [apa592ph]          ,   "Analytical    pH/ORP/pIon/Ion Conc" },
        { 0x0034, [az200]             ,   "Analytical    Oxygen" },
        { 0x0089, [abb_263_265_2000t] ,   "Pressure      P, dP + Multivariable" },
        { 0x008A, [abb_2600t_267]     ,   "Pressure" },
        { 0x008C, [abb_261]           ,   "Pressure      Absolute" },
        { 0x008D, [edp300]            ,   "Valve         Positioner" },
        { 0x008E, [abb_2600t_266_mv]  ,   "Pressure" },
        { 0x0099, [nhu200_wl]         },
        { 0x1A01, [ksx]               ,   "Pressure" },
        { 0x1A02, [abb_600t]          ,   "Pressure      Differential" },
        { 0x1A03, [abb_2600t_268]     ,   "Pressure      Safety" },
        { 0x1A04, [abb_2600t_262_264] ,   "Pressure" },
        { 0x1A05, [abb_2600t_364]     ,   "Pressure" },
        { 0x1A07, [abb_2600t_266]     ,   "Pressure" },
        { 0x1A08, [abb_kst]           ,   "Temperature" },
        { 0x1A09, [th01]              ,   "Temperature" },
        { 0x1A0A, [abb_658t]          ,   "Temperature" },
        { 0x1A0B, [ttx300_series]     ,   "Temperature" },
        { 0x1A0C, [abb_652]           ,   "Temperature" },
        { 0x1A0D, [ttx200]            ,   "Temperature" },
        { 0x1A0F, [abb_665]           ,   "Valve         Positioner" },
        { 0x1A10, [deltapi_kt]        ,   "Valve         Positioner" },
        { 0x1A18, [magmaster]         ,   "Flow          Electromagnetic" },
        { 0x1A1A, [fvs4000]           ,   "Flow          Vortex/Swirl" },
        { 0x1A1B, [fam540]            ,   "Flow          Variable Area" },
        { 0x1A1C, [fmt500ig]          ,   "Flow" },
        { 0x1A1D, [fsm4000]           ,   "Flow          Electromagnetic" },
        { 0x1A1E, [fex300]            ,   "Flow          Electromagnetic" },
        { 0x1A1F, [fex100]            ,   "Flow" },
        { 0x1A21, [abb_2600ph]        ,   "Analytical    pH" },
        { 0x1A23, [tb82ph_comb]       ,   "Analytical    pH" },
        { 0x1A24, [tb82ec_comb]       ,   "Analytical    4 Electrode Conductivity" },
        { 0x1A25, [tb82te_comb]       ,   "Analytical    2 Electrode Conductivity" },
        { 0x1A26, [tb82tc_comb]       ,   "Analytical    Troidal Conductivity" },
        { 0x1A27, [fmt300]            ,   "Flow" },
        { 0x1A29, [ufte_pa]           },
        { 0x1A2A, [ufte_ff]           },
        { 0x1A30, [apa592ph]          ,   "Analytical    pH/ORP/pIon/Ion Conc" },
        { 0x1A34, [az200]             ,   "Analytical    Oxygen" },
        { 0x1A89, [abb_263_265_2000t] ,   "Pressure      P, dP + Multivariable" },
        { 0x1A8A, [abb_2600t_267]     ,   "Pressure" },
        { 0x1A8C, [abb_261]           ,   "Pressure      Absolute" },
        { 0x1A8D, [edp300]            ,   "Valve         Positioner" },
        { 0x1A8E, [abb_2600t_266_mv]  ,   "Pressure" },
        { 0x1A99, [nhu200_wl]         }
    }
}

/*********************************************************************************
 * M-System Co Device Type Codes
 */
VARIABLE M_System_Co_model_code    /* 0x001D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [b6u]           ,   "Temperature   2-wire" },
        { 0x0002, [b3hu]          ,   "Temperature" },
        { 0x0003, [m_system_27hu] ,   "Temperature   Head Mounted" },
        { 0x1D01, [b6u]           ,   "Temperature   2-wire" },
        { 0x1D02, [b3hu]          ,   "Temperature" },
        { 0x1D03, [m_system_27hu] ,   "Temperature   Head Mounted" }
    }
}

/**********************************************************************
 * Micro Motion Device Type Codes
 */
VARIABLE micro_motion_model_code    /* 0x001F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0007, [mass_flow_9712]  ,   "Flow          Coriolis Mass" },
        { 0x0014, [mass_flow_9720]  },
        { 0x0015, [mass_flow_9739]  ,   "Flow          Coriolis Mass" },
        { 0x001E, [mass_flow_9701]  ,   "Flow          Coriolis Mass" },
        { 0x0024, [mvd_2000_io]     ,   "Flow          Coriolis Mass" },
        { 0x0025, [mvd_1000_io]     ,   "Flow          Coriolis Mass" },
        { 0x0026, [mvd_2000_is]     ,   "Flow          Coriolis Mass" },
        { 0x0027, [mvd_1000_is]     ,   "Flow          Coriolis Mass" },
        { 0x0029, [mvd_1000_ao]     ,   "Flow          Coriolis Mass" },
        { 0x002A, [mvd_2000_ao]     ,   "Flow          Coriolis Mass" },
        { 0x0034, [mass_flow_2400s] ,   "Flow          Coriolis Mass" },
        { 0x003A, [analog_2200s]    ,   "Flow          Coriolis Mass" },
        { 0x0041, [mvd_3000]        ,   "Flow          Coriolis Mass" },
        { 0x1F07, [mass_flow_9712]  ,   "Flow          Coriolis Mass" },
        { 0x1F14, [mass_flow_9720]  },
        { 0x1F15, [mass_flow_9739]  ,   "Flow          Coriolis Mass" },
        { 0x1F1E, [mass_flow_9701]  ,   "Flow          Coriolis Mass" },
        { 0x1F24, [mvd_2000_io]     ,   "Flow          Coriolis Mass" },
        { 0x1F25, [mvd_1000_io]     ,   "Flow          Coriolis Mass" },
        { 0x1F26, [mvd_2000_is]     ,   "Flow          Coriolis Mass" },
        { 0x1F27, [mvd_1000_is]     ,   "Flow          Coriolis Mass" },
        { 0x1F29, [mvd_1000_ao]     ,   "Flow          Coriolis Mass" },
        { 0x1F2A, [mvd_2000_ao]     ,   "Flow          Coriolis Mass" },
        { 0x1F34, [mass_flow_2400s] ,   "Flow          Coriolis Mass" },
        { 0x1F3A, [analog_2200s]    ,   "Flow          Coriolis Mass" },
        { 0x1F41, [mvd_3000]        ,   "Flow          Coriolis Mass" }
    }
}

/*********************************************************************************
 * Moore Industries Device Type Codes
 */
VARIABLE Moore_Industries_model_code    /* 0x0020 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [trz]  ,   "Temperature" },
        { 0x0003, [thz]  ,   "Temperature" },
        { 0x0004, [thz2] ,   "Temperature" },
        { 0x0005, [htz]  ,   "Temperature" },
        { 0x0006, [tcm]  ,   "Temperature" },
        { 0x2001, [trz]  ,   "Temperature" },
        { 0x2003, [thz]  ,   "Temperature" },
        { 0x2004, [thz2] ,   "Temperature" },
        { 0x2005, [htz]  ,   "Temperature" },
        { 0x2006, [tcm]  ,   "Temperature" }
    }
}

/*********************************************************************************
 * PRIME Measurement Products Device Type Codes
 *     Note: was Moore Products
 */
VARIABLE Moore_Products_model_code    /* 0x0021 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [moore340a]  },
        { 0x0002, [moore340b]  },
        { 0x0003, [moore344]   },
        { 0x0005, [prime330]   ,   "Pressure" },
        { 0x0006, [moore340a2] ,   "Pressure      w/ PID" },
        { 0x0008, [moore340b2] },
        { 0x0009, [moore3442]  },
        { 0x000A, [moore340s]  ,   "Pressure      Saturated Steam" },
        { 0x000B, [moore343]   ,   "Temperature" },
        { 0x000C, [moore760d]  },
        { 0x000D, [moore345]   ,   "Pressure" },
        { 0x2101, [moore340a]  },
        { 0x2102, [moore340b]  },
        { 0x2103, [moore344]   },
        { 0x2105, [prime330]   ,   "Pressure" },
        { 0x2106, [moore340a2] ,   "Pressure      w/ PID" },
        { 0x2108, [moore340b2] },
        { 0x2109, [moore3442]  },
        { 0x210A, [moore340s]  ,   "Pressure      Saturated Steam" },
        { 0x210B, [moore343]   ,   "Temperature" },
        { 0x210C, [moore760d]  },
        { 0x210D, [moore345]   ,   "Pressure" }
    }
}

/*********************************************************************************
 * Ronan Device Type Codes
 */
VARIABLE Ronan_model_code    /* 0x0025 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0002, [x96_d]  ,   "Analytical    Density - Gamma Ray" },
        { 0x0003, [x96_l]  ,   "Level         Gamma Ray" },
        { 0x0004, [x96_w]  ,   "Analytical    Weight - Gamma Ray" },
        { 0x0005, [x96_ld] ,   "Level         w/ Density - Gamma Ray" },
        { 0x0006, [x99_md] ,   "Analytical    Motorized Density" },
        { 0x2502, [x96_d]  ,   "Analytical    Density - Gamma Ray" },
        { 0x2503, [x96_l]  ,   "Level         Gamma Ray" },
        { 0x2504, [x96_w]  ,   "Analytical    Weight - Gamma Ray" },
        { 0x2505, [x96_ld] ,   "Level         w/ Density - Gamma Ray" },
        { 0x2506, [x99_md] ,   "Analytical    Motorized Density" }
    }
}

/**********************************************************************
 * Rosemount Device Type Codes
 */
VARIABLE rosemount_model_code    /* 0x0026 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [pressure_3051]          },
        { 0x0002, [temperature_3044]       ,   "Temperature" },
        { 0x0003, [pressure_1151s]         ,   "Pressure" },
        { 0x0004, [mag_flow_8712]          ,   "Flow          Magnetic" },
        { 0x0005, [pressure_2001]          },
        { 0x0006, [pressure_3051c]         ,   "Pressure" },
        { 0x000B, [pressure_3001l]         },
        { 0x000C, [mag_flow_8712H]         ,   "Flow          Magnetic" },
        { 0x000D, [temperature_3044C]      ,   "Temperature" },
        { 0x000E, [pressure_3001c]         ,   "Pressure" },
        { 0x000F, [pressure_3051clp]       ,   "Pressure" },
        { 0x0010, [vortex_flow_8800]       ,   "Flow          Vortex" },
        { 0x0011, [htg_3201]               ,   "Level         Hydrostatic" },
        { 0x0012, [pressure_1152s]         },
        { 0x0013, [htg_3202]               ,   "Level         Hydrostatic" },
        { 0x0014, [pressure_3001s]         ,   "Pressure" },
        { 0x0015, [multi_3095FT]           },
        { 0x0016, [mv_3095]                ,   "Flow          Multivariable Mass" },
        { 0x0017, [temperature_544]        },
        { 0x0018, [temperature_644]        ,   "Temperature" },
        { 0x0019, [temperature_3144]       ,   "Temperature" },
        { 0x001A, [temperature_3244]       ,   "Temperature   Multivariable" },
        { 0x001B, [level_3700]             },
        { 0x001C, [level_3750]             ,   "Level" },
        { 0x001D, [TRI_LOOP]               ,   "Specialty     HART-to-Analog Signal Conv" },
        { 0x001E, [c_3095]                 ,   "Level" },
        { 0x001F, [mm_3095]                },
        { 0x0020, [tank_3701]              },
        { 0x0021, [level_3300]             ,   "Level         Radar" },
        { 0x0022, [asu_3702]               },
        { 0x0023, [pressure_2088s]         ,   "Pressure" },
        { 0x0024, [probar]                 ,   "Flow          dP" },
        { 0x0025, [massprobar]             },
        { 0x0026, [prov]                   },
        { 0x0027, [pressure_2090s]         ,   "Pressure" },
        { 0x0028, [probar_uc]              ,   "Flow          dP" },
        { 0x0029, [d_2055]                 },
        { 0x002A, [pv_3095]                },
        { 0x002D, [sentry]                 },
        { 0x002F, [proplate_uc]            ,   "Flow          dP" },
        { 0x0036, [pressure_1810]          ,   "Pressure" },
        { 0x0037, [mag_flow_8712d]         ,   "Flow          Magnetic" },
        { 0x0038, [pressure_4600]          ,   "Pressure" },
        { 0x003A, [vortex_flow_8800d]      ,   "Flow          Vortex" },
        { 0x003B, [temperature_248]        ,   "Temperature" },
        { 0x003C, [mag_flow_8732]          ,   "Flow          Magnetic" },
        { 0x0040, [pressure_2088lp]        ,   "Pressure      Low Power" },
        { 0x0041, [level_5600]             },
        { 0x0042, [presssure_951]          ,   "Pressure" },
        { 0x0043, [level_5400]             ,   "Level         Radar" },
        { 0x0044, [pressure_3051s_sis]     ,   "Pressure      Certified SIL2" },
        { 0x0045, [temperature_3144p_sis]  ,   "Temperature" },
        { 0x0047, [pressure_4500]          ,   "Pressure" },
        { 0x0049, [pressure_3051smv_fcmef] ,   "Flow" },
        { 0x004A, [pressure_3051s_diag]    ,   "Pressure" },
        { 0x004B, [pressure_3051smv_dpvo]  ,   "Pressure" },
        { 0x004E, [wireless_gateway]       },
        { 0x0050, [level_3100]             ,   "Level         Ultrasonic" },
        { 0x0051, [level_5300]             ,   "Level         Radar" },
        { 0x0055, [pressure_2051]          ,   "Pressure" },
        { 0x0056, [pressure_2051lp]        ,   "Pressure" },
        { 0x0057, [mag_flow_8712e]         ,   "Flow          Magnetic" },
        { 0x0080, [generic]                ,   "Interoperable" },
        { 0x2601, [pressure_3051]          },
        { 0x2602, [temperature_3044]       ,   "Temperature" },
        { 0x2603, [pressure_1151s]         ,   "Pressure" },
        { 0x2604, [mag_flow_8712]          ,   "Flow          Magnetic" },
        { 0x2605, [pressure_2001]          },
        { 0x2606, [pressure_3051c]         ,   "Pressure" },
        { 0x260B, [pressure_3001l]         },
        { 0x260C, [mag_flow_8712H]         ,   "Flow          Magnetic" },
        { 0x260D, [temperature_3044C]      ,   "Temperature" },
        { 0x260E, [pressure_3001c]         ,   "Pressure" },
        { 0x260F, [pressure_3051clp]       ,   "Pressure" },
        { 0x2610, [vortex_flow_8800]       ,   "Flow          Vortex" },
        { 0x2611, [htg_3201]               ,   "Level         Hydrostatic" },
        { 0x2612, [pressure_1152s]         },
        { 0x2613, [htg_3202]               ,   "Level         Hydrostatic" },
        { 0x2614, [pressure_3001s]         ,   "Pressure" },
        { 0x2615, [multi_3095FT]           },
        { 0x2616, [mv_3095]                ,   "Flow          Multivariable Mass" },
        { 0x2617, [temperature_544]        },
        { 0x2618, [temperature_644]        ,   "Temperature" },
        { 0x2619, [temperature_3144]       ,   "Temperature" },
        { 0x261A, [temperature_3244]       ,   "Temperature   Multivariable" },
        { 0x261B, [level_3700]             },
        { 0x261C, [level_3750]             ,   "Level" },
        { 0x261D, [TRI_LOOP]               ,   "Specialty     HART-to-Analog Signal Conv" },
        { 0x261E, [c_3095]                 ,   "Level" },
        { 0x261F, [mm_3095]                },
        { 0x2620, [tank_3701]              },
        { 0x2621, [level_3300]             ,   "Level         Radar" },
        { 0x2622, [asu_3702]               },
        { 0x2623, [pressure_2088s]         ,   "Pressure" },
        { 0x2624, [probar]                 ,   "Flow          dP" },
        { 0x2625, [massprobar]             },
        { 0x2626, [prov]                   },
        { 0x2627, [pressure_2090s]         ,   "Pressure" },
        { 0x2628, [probar_uc]              ,   "Flow          dP" },
        { 0x2629, [d_2055]                 },
        { 0x262A, [pv_3095]                },
        { 0x262D, [sentry]                 },
        { 0x262F, [proplate_uc]            ,   "Flow          dP" },
        { 0x2636, [pressure_1810]          ,   "Pressure" },
        { 0x2637, [mag_flow_8712d]         ,   "Flow          Magnetic" },
        { 0x2638, [pressure_4600]          ,   "Pressure" },
        { 0x263A, [vortex_flow_8800d]      ,   "Flow          Vortex" },
        { 0x263B, [temperature_248]        ,   "Temperature" },
        { 0x263C, [mag_flow_8732]          ,   "Flow          Magnetic" },
        { 0x2640, [pressure_2088lp]        ,   "Pressure      Low Power" },
        { 0x2641, [level_5600]             },
        { 0x2642, [presssure_951]          ,   "Pressure" },
        { 0x2643, [level_5400]             ,   "Level         Radar" },
        { 0x2644, [pressure_3051s_sis]     ,   "Pressure      Certified SIL2" },
        { 0x2645, [temperature_3144p_sis]  ,   "Temperature" },
        { 0x2647, [pressure_4500]          ,   "Pressure" },
        { 0x2649, [pressure_3051smv_fcmef] ,   "Flow" },
        { 0x264A, [pressure_3051s_diag]    ,   "Pressure" },
        { 0x264B, [pressure_3051smv_dpvo]  ,   "Pressure" },
        { 0x264E, [wireless_gateway]       },
        { 0x2650, [level_3100]             ,   "Level         Ultrasonic" },
        { 0x2651, [level_5300]             ,   "Level         Radar" },
        { 0x2655, [pressure_2051]          ,   "Pressure" },
        { 0x2656, [pressure_2051lp]        ,   "Pressure" },
        { 0x2657, [mag_flow_8712e]         ,   "Flow          Magnetic" },
        { 0x2680, [generic]                ,   "Interoperable" }
    }
}

/*********************************************************************************
 * Peek Measurement  Device Type Codes
 *     Note: was Sarasota
 */
VARIABLE Peek_Measurement_model_code    /* 0x0027 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0000, [peek900densitometer] ,   "Analytical    Density" },
        { 0x2700, [peek900densitometer] ,   "Analytical    Density" }
    }
}

/*********************************************************************************
 * Actaris Neptune Device Type Codes
 */
VARIABLE Actaris_Neptune_model_code    /* 0x0028 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [nexgen] ,   "Flow          Coriolis" },
        { 0x2801, [nexgen] ,   "Flow          Coriolis" }
    }
}

/*********************************************************************************
 * Siemens Device Type Codes
 */
VARIABLE Siemens_model_code    /* 0x002A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [micro_k]            },
        { 0x0002, [sitrans_l]          },
        { 0x0003, [sipan_ph]           },
        { 0x0004, [sitrans_fus]        ,   "Flow          Ultrasonic" },
        { 0x0005, [sipan_lf]           },
        { 0x0006, [sipan_o2]           },
        { 0x0007, [sitrans_lr]         ,   "Level         Radar" },
        { 0x000A, [sitrans_phs]        ,   "Pressure" },
        { 0x000B, [sitrans_pds]        ,   "Pressure" },
        { 0x000C, [sitrans_pes]        ,   "Pressure" },
        { 0x000D, [sitrans_pms]        ,   "Pressure" },
        { 0x000F, [sitrans_t2k]        },
        { 0x0010, [sitrans_tw]         ,   "Temperature" },
        { 0x0012, [sitrans_tkh]        ,   "Temperature" },
        { 0x0013, [sitrans_th300]      ,   "Temperature" },
        { 0x0015, [sipart_ps2]         ,   "Valve         Positioner/Electropneumatic" },
        { 0x0016, [sitrans_fm]         ,   "Flow          Electromagnetic" },
        { 0x0017, [sitrans_fva]        },
        { 0x0018, [sitrans_fm_magflo]  ,   "Flow          Magnetic Inductive" },
        { 0x0019, [sitrans_fc_massflo] ,   "Flow          Coriolis Mass" },
        { 0x001A, [sitrans_fm_it2_tm2] ,   "Flow" },
        { 0x001D, [sitrans_p300]       ,   "Pressure" },
        { 0x001F, [sitrans_tr300]      ,   "Temperature" },
        { 0x2A01, [micro_k]            },
        { 0x2A02, [sitrans_l]          },
        { 0x2A03, [sipan_ph]           },
        { 0x2A04, [sitrans_fus]        ,   "Flow          Ultrasonic" },
        { 0x2A05, [sipan_lf]           },
        { 0x2A06, [sipan_o2]           },
        { 0x2A07, [sitrans_lr]         ,   "Level         Radar" },
        { 0x2A0A, [sitrans_phs]        ,   "Pressure" },
        { 0x2A0B, [sitrans_pds]        ,   "Pressure" },
        { 0x2A0C, [sitrans_pes]        ,   "Pressure" },
        { 0x2A0D, [sitrans_pms]        ,   "Pressure" },
        { 0x2A0F, [sitrans_t2k]        },
        { 0x2A10, [sitrans_tw]         ,   "Temperature" },
        { 0x2A12, [sitrans_tkh]        ,   "Temperature" },
        { 0x2A13, [sitrans_th300]      ,   "Temperature" },
        { 0x2A15, [sipart_ps2]         ,   "Valve         Positioner/Electropneumatic" },
        { 0x2A16, [sitrans_fm]         ,   "Flow          Electromagnetic" },
        { 0x2A17, [sitrans_fva]        },
        { 0x2A18, [sitrans_fm_magflo]  ,   "Flow          Magnetic Inductive" },
        { 0x2A19, [sitrans_fc_massflo] ,   "Flow          Coriolis Mass" },
        { 0x2A1A, [sitrans_fm_it2_tm2] ,   "Flow" },
        { 0x2A1D, [sitrans_p300]       ,   "Pressure" },
        { 0x2A1F, [sitrans_tr300]      ,   "Temperature" }
    }
}

/*********************************************************************************
 * Toshiba  Device Type Codes
 */
VARIABLE Toshiba_model_code    /* 0x002C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0002, [ap3100] ,   "Pressure" },
        { 0x0003, [ap3110] },
        { 0x0004, [ap3120] },
        { 0x0005, [ap3140] },
        { 0x0006, [ap3150] },
        { 0x0007, [ap3170] },
        { 0x0008, [ap3180] },
        { 0x0009, [ap3190] },
        { 0x000A, [lf220]  ,   "Flow          Electromagnetic" },
        { 0x2C02, [ap3100] ,   "Pressure" },
        { 0x2C03, [ap3110] },
        { 0x2C04, [ap3120] },
        { 0x2C05, [ap3140] },
        { 0x2C06, [ap3150] },
        { 0x2C07, [ap3170] },
        { 0x2C08, [ap3180] },
        { 0x2C09, [ap3190] },
        { 0x2C0A, [lf220]  ,   "Flow          Electromagnetic" }
    }
}

/**********************************************************************
 * Rosemount Analytical Device Type Codes
 */
VARIABLE rosemount_analytical_model_code    /* 0x002E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0006, [ph_1181]                     ,   "Analytical    pH" },
        { 0x0007, [conductivity_1181]           ,   "Analytical    Conductivity" },
        { 0x000A, [ph_1054]                     },
        { 0x000B, [conductivity_1054]           },
        { 0x000C, [oxymitter_4000]              ,   "Analytical    Oxygen" },
        { 0x000D, [wc_3000]                     ,   "Analytical" },
        { 0x000E, [ra3081fg]                    ,   "Analytical" },
        { 0x000F, [opm_2000r]                   ,   "Analytical    Opacity Monitor" },
        { 0x0010, [ocx_4000]                    ,   "Analytical    Oxygen/Combustion" },
        { 0x0014, [ph_3081]                     ,   "Analytical    pH" },
        { 0x0015, [c_3081]                      ,   "Analytical    2-wire Conductivity" },
        { 0x0016, [ra3081_81con]                ,   "Analytical    2-wire Conductivity w/ pure H20" },
        { 0x0017, [ra3081_81t]                  ,   "Analytical    2-wire Conductivity w/ % conc" },
        { 0x0018, [ocx_cl_oz_5081a]             ,   "Analytical    2-wire Oxygen/Chlorine/Ozone" },
        { 0x0019, [conductivity_5081c_t]        ,   "Analytical    2-wire Conductivity" },
        { 0x001A, [ph_5081]                     ,   "Analytical    2-wire pH/ORP" },
        { 0x001B, [xmt_a]                       ,   "Analytical    2-wire Oxygen/Chlorine/Ozone" },
        { 0x001C, [xmt_c_t]                     ,   "Analytical    2-wire Contacting/Toroidal" },
        { 0x001D, [xmt_ph]                      ,   "Analytical    2-wire pH/ORP" },
        { 0x001E, [oxygen_5081fg]               ,   "Analytical    Oxygen - High Temperature" },
        { 0x001F, [ph_orp_6081_p]               },
        { 0x0020, [conductivity_6081c_wireless] ,   "Analytical    Conductivity" },
        { 0x002B, [xs_o2]                       ,   "Analytical    Oxygen" },
        { 0x0050, [ph_orp_54]                   ,   "Analytical    pH/ORP" },
        { 0x0051, [c_54]                        ,   "Analytical    Conductivity w/ % conc" },
        { 0x0052, [ra52eph_orp]                 ,   "Analytical    pH/ORP/ISE" },
        { 0x0053, [ra54ea]                      ,   "Analytical    Amperometric Analyzer" },
        { 0x0055, [di_analyzer_1056]            ,   "Analytical    Dual Input Analyzer" },
        { 0x0056, [model_56]                    },
        { 0x2E06, [ph_1181]                     ,   "Analytical    pH" },
        { 0x2E07, [conductivity_1181]           ,   "Analytical    Conductivity" },
        { 0x2E0A, [ph_1054]                     },
        { 0x2E0B, [conductivity_1054]           },
        { 0x2E0C, [oxymitter_4000]              ,   "Analytical    Oxygen" },
        { 0x2E0D, [wc_3000]                     ,   "Analytical" },
        { 0x2E0E, [ra3081fg]                    ,   "Analytical" },
        { 0x2E0F, [opm_2000r]                   ,   "Analytical    Opacity Monitor" },
        { 0x2E10, [ocx_4000]                    ,   "Analytical    Oxygen/Combustion" },
        { 0x2E14, [ph_3081]                     ,   "Analytical    pH" },
        { 0x2E15, [c_3081]                      ,   "Analytical    2-wire Conductivity" },
        { 0x2E16, [ra3081_81con]                ,   "Analytical    2-wire Conductivity w/ pure H20" },
        { 0x2E17, [ra3081_81t]                  ,   "Analytical    2-wire Conductivity w/ % conc" },
        { 0x2E18, [ocx_cl_oz_5081a]             ,   "Analytical    2-wire Oxygen/Chlorine/Ozone" },
        { 0x2E19, [conductivity_5081c_t]        ,   "Analytical    2-wire Conductivity" },
        { 0x2E1A, [ph_5081]                     ,   "Analytical    2-wire pH/ORP" },
        { 0x2E1B, [xmt_a]                       ,   "Analytical    2-wire Oxygen/Chlorine/Ozone" },
        { 0x2E1C, [xmt_c_t]                     ,   "Analytical    2-wire Contacting/Toroidal" },
        { 0x2E1D, [xmt_ph]                      ,   "Analytical    2-wire pH/ORP" },
        { 0x2E1E, [oxygen_5081fg]               ,   "Analytical    Oxygen - High Temperature" },
        { 0x2E1F, [ph_orp_6081_p]               },
        { 0x2E20, [conductivity_6081c_wireless] ,   "Analytical    Conductivity" },
        { 0x2E2B, [xs_o2]                       ,   "Analytical    Oxygen" },
        { 0x2E50, [ph_orp_54]                   ,   "Analytical    pH/ORP" },
        { 0x2E51, [c_54]                        ,   "Analytical    Conductivity w/ % conc" },
        { 0x2E52, [ra52eph_orp]                 ,   "Analytical    pH/ORP/ISE" },
        { 0x2E53, [ra54ea]                      ,   "Analytical    Amperometric Analyzer" },
        { 0x2E55, [di_analyzer_1056]            ,   "Analytical    Dual Input Analyzer" },
        { 0x2E56, [model_56]                    }
    }
}

/*********************************************************************************
 * Metso Automation Device Type Codes
 *     Note: was Valmet Automation
 */
VARIABLE Valmet_Automation_model_code    /* 0x002F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [psmart]    ,   "Pressure      Pressure/Level" },
        { 0x003C, [smartpulp] ,   "Analytical    Consistency" },
        { 0x003D, [smartlx]   ,   "Analytical    Consistency" },
        { 0x003E, [mcai]      ,   "Analytical    Microwave-Pulp Consistency" },
        { 0x003F, [smartlc]   ,   "Analytical    Consistency" },
        { 0x0040, [mca]       ,   "Analytical    Microwave Consistency" },
        { 0x2F01, [psmart]    ,   "Pressure      Pressure/Level" },
        { 0x2F3C, [smartpulp] ,   "Analytical    Consistency" },
        { 0x2F3D, [smartlx]   ,   "Analytical    Consistency" },
        { 0x2F3E, [mcai]      ,   "Analytical    Microwave-Pulp Consistency" },
        { 0x2F3F, [smartlc]   ,   "Analytical    Consistency" },
        { 0x2F40, [mca]       ,   "Analytical    Microwave Consistency" }
    }
}

/*********************************************************************************
 * Flowserve Device Type Codes
 */
VARIABLE Flowserve_model_code    /* 0x0030 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [logix_12xx]   ,   "Valve         Digital Positioner" },
        { 0x0002, [kemmer_c2100] ,   "Valve         Positioner" },
        { 0x0003, [logix_520]    ,   "Valve         Digital Positioner" },
        { 0x0004, [Logix_3200iq] ,   "Valve         Digital Positioner" },
        { 0x0005, [logix_3200md] ,   "Valve         Positioner" },
        { 0x0006, [logix_520md]  ,   "Valve         Positioner" },
        { 0x3001, [logix_12xx]   ,   "Valve         Digital Positioner" },
        { 0x3002, [kemmer_c2100] ,   "Valve         Positioner" },
        { 0x3003, [logix_520]    ,   "Valve         Digital Positioner" },
        { 0x3004, [Logix_3200iq] ,   "Valve         Digital Positioner" },
        { 0x3005, [logix_3200md] ,   "Valve         Positioner" },
        { 0x3006, [logix_520md]  ,   "Valve         Positioner" }
    }
}

/*********************************************************************************
 * Viatran Device Type Codes
 */
VARIABLE Viatran_model_code    /* 0x0032 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [viatran970]          ,   "Pressure" },
        { 0x002E, [viatran_ia_pressure] ,   "Pressure" },
        { 0x3201, [viatran970]          ,   "Pressure" },
        { 0x322E, [viatran_ia_pressure] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Yamatake Device Type Codes
 */
VARIABLE Yamatake_model_code    /* 0x0036 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [magnew]     ,   "Flow          Magnetic" },
        { 0x0002, [st3000]     ,   "Pressure" },
        { 0x0003, [svp]        ,   "Valve         Smart Valve Positioner" },
        { 0x0004, [thermoplus] ,   "Temperature" },
        { 0x0005, [ptg]        ,   "Pressure" },
        { 0x0008, [magnew_2w]  ,   "Flow          Electromagnetic" },
        { 0x000C, [magnew4w]   ,   "Flow          Magnetic" },
        { 0x000D, [at9000]     ,   "Pressure" },
        { 0x3601, [magnew]     ,   "Flow          Magnetic" },
        { 0x3602, [st3000]     ,   "Pressure" },
        { 0x3603, [svp]        ,   "Valve         Smart Valve Positioner" },
        { 0x3604, [thermoplus] ,   "Temperature" },
        { 0x3605, [ptg]        ,   "Pressure" },
        { 0x3608, [magnew_2w]  ,   "Flow          Electromagnetic" },
        { 0x360C, [magnew4w]   ,   "Flow          Magnetic" },
        { 0x360D, [at9000]     ,   "Pressure" }
    }
}

/*********************************************************************************
 * Yokogawa Device Type Codes
 */
VARIABLE Yokogawa_model_code    /* 0x0037 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [yewflo]     ,   "Flow          Vortex" },
        { 0x0002, [yt200]      ,   "Temperature   Differential" },
        { 0x0003, [unicom]     ,   "Pressure" },
        { 0x0004, [eja]        ,   "Pressure      Differential" },
        { 0x0005, [admag_ae]   ,   "Flow          Magnetic" },
        { 0x0006, [am11]       ,   "Flow" },
        { 0x0008, [admag_se]   ,   "Flow" },
        { 0x0009, [yta]        ,   "Temperature" },
        { 0x000A, [yta70e]     ,   "Temperature" },
        { 0x000B, [dyf]        ,   "Flow          Vortex" },
        { 0x000C, [zr202]      ,   "Analytical    Oxygen" },
        { 0x000D, [zr402]      ,   "Analytical    Oxygen" },
        { 0x0014, [isc202]     ,   "Analytical    Conductivity - Inductive" },
        { 0x0015, [ph202]      ,   "Analytical    pH" },
        { 0x0016, [sc202]      ,   "Analytical    Conductivity" },
        { 0x0018, [do202]      ,   "Analytical    Dissolved Oxygen" },
        { 0x0027, [ph150]      ,   "Analytical    pH Controller" },
        { 0x0028, [sc150]      ,   "Analytical    Conductivity/Resistivity Controller" },
        { 0x002B, [ph450]      ,   "Analytical    pH" },
        { 0x002C, [sc450]      ,   "Analytical    Conductivity/Resistivity" },
        { 0x002D, [isc450]     ,   "Analytical    Conductivity - Inductive" },
        { 0x0040, [rotamass]   ,   "Flow          Mass" },
        { 0x0041, [ramc]       ,   "Flow          Variable Area" },
        { 0x0042, [rcct_f3]    ,   "Flow          Mass" },
        { 0x0050, [axfa11]     ,   "Flow          Magnetic" },
        { 0x0051, [ejx]        ,   "Pressure" },
        { 0x0052, [axfa14]     ,   "Flow          Magnetic" },
        { 0x0053, [av550g]     ,   "Analytical    Oxygen" },
        { 0x0054, [ejx_mv]     ,   "Pressure      Multivariable" },
        { 0x0057, [axr]        ,   "Flow          Electromagnetic" },
        { 0x0058, [flxa21_ph]  },
        { 0x0059, [flxa21_sc]  },
        { 0x005A, [flxa21_isc] },
        { 0x005B, [flxa21_do]  },
        { 0x3701, [yewflo]     ,   "Flow          Vortex" },
        { 0x3702, [yt200]      ,   "Temperature   Differential" },
        { 0x3703, [unicom]     ,   "Pressure" },
        { 0x3704, [eja]        ,   "Pressure      Differential" },
        { 0x3705, [admag_ae]   ,   "Flow          Magnetic" },
        { 0x3706, [am11]       ,   "Flow" },
        { 0x3708, [admag_se]   ,   "Flow" },
        { 0x3709, [yta]        ,   "Temperature" },
        { 0x370A, [yta70e]     ,   "Temperature" },
        { 0x370B, [dyf]        ,   "Flow          Vortex" },
        { 0x370C, [zr202]      ,   "Analytical    Oxygen" },
        { 0x370D, [zr402]      ,   "Analytical    Oxygen" },
        { 0x3714, [isc202]     ,   "Analytical    Conductivity - Inductive" },
        { 0x3715, [ph202]      ,   "Analytical    pH" },
        { 0x3716, [sc202]      ,   "Analytical    Conductivity" },
        { 0x3718, [do202]      ,   "Analytical    Dissolved Oxygen" },
        { 0x3727, [ph150]      ,   "Analytical    pH Controller" },
        { 0x3728, [sc150]      ,   "Analytical    Conductivity/Resistivity Controller" },
        { 0x372B, [ph450]      ,   "Analytical    pH" },
        { 0x372C, [sc450]      ,   "Analytical    Conductivity/Resistivity" },
        { 0x372D, [isc450]     ,   "Analytical    Conductivity - Inductive" },
        { 0x3740, [rotamass]   ,   "Flow          Mass" },
        { 0x3741, [ramc]       ,   "Flow          Variable Area" },
        { 0x3742, [rcct_f3]    ,   "Flow          Mass" },
        { 0x3750, [axfa11]     ,   "Flow          Magnetic" },
        { 0x3751, [ejx]        ,   "Pressure" },
        { 0x3752, [axfa14]     ,   "Flow          Magnetic" },
        { 0x3753, [av550g]     ,   "Analytical    Oxygen" },
        { 0x3754, [ejx_mv]     ,   "Pressure      Multivariable" },
        { 0x3757, [axr]        ,   "Flow          Electromagnetic" },
        { 0x3758, [flxa21_ph]  },
        { 0x3759, [flxa21_sc]  },
        { 0x375A, [flxa21_isc] },
        { 0x375B, [flxa21_do]  }
    }
}

/*********************************************************************************
 * Mobrey Device Type Codes
 *     Note: was Solartron Mobrey
 */
VARIABLE Solartron_Mobrey_model_code    /* 0x003B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0013, [solartron4301] ,   "Pressure      w/ PID" },
        { 0x0014, [solartron3301] },
        { 0x0015, [msp100]        ,   "Level" },
        { 0x0021, [level_3300]    ,   "Level         Radar" },
        { 0x0029, [mlt100]        ,   "Level         Displacement" },
        { 0x002A, [solartron4291] },
        { 0x002B, [msm400]        },
        { 0x002C, [msl600]        },
        { 0x002D, [mcu900]        },
        { 0x002E, [msp900_400]    ,   "Level         Ultrasonic" },
        { 0x002F, [mrl700]        ,   "Level         Radar" },
        { 0x0030, [mrl800]        },
        { 0x0031, [mrl850]        },
        { 0x3B13, [solartron4301] ,   "Pressure      w/ PID" },
        { 0x3B14, [solartron3301] },
        { 0x3B15, [msp100]        ,   "Level" },
        { 0x3B21, [level_3300]    ,   "Level         Radar" },
        { 0x3B29, [mlt100]        ,   "Level         Displacement" },
        { 0x3B2A, [solartron4291] },
        { 0x3B2B, [msm400]        },
        { 0x3B2C, [msl600]        },
        { 0x3B2D, [mcu900]        },
        { 0x3B2E, [msp900_400]    ,   "Level         Ultrasonic" },
        { 0x3B2F, [mrl700]        ,   "Level         Radar" },
        { 0x3B30, [mrl800]        },
        { 0x3B31, [mrl850]        }
    }
}

/*********************************************************************************
 * Princo Device Type Codes
 */
VARIABLE Princo_model_code    /* 0x003D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [l4610] },
        { 0x3D01, [l4610] }
    }
}

/*********************************************************************************
 * Smar Device Type Codes
 */
VARIABLE Smar_model_code    /* 0x003E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [ld301] ,   "Pressure      w/ PID" },
        { 0x0002, [tt301] ,   "Temperature   w/ PID" },
        { 0x0003, [fy301] ,   "Valve         Positioner/Electropneumatic" },
        { 0x0004, [ld291] ,   "Pressure" },
        { 0x0005, [tp301] ,   "Valve         Positioner" },
        { 0x0006, [dt301] ,   "Analytical    Density" },
        { 0x000A, [ld400] ,   "Pressure" },
        { 0x3E01, [ld301] ,   "Pressure      w/ PID" },
        { 0x3E02, [tt301] ,   "Temperature   w/ PID" },
        { 0x3E03, [fy301] ,   "Valve         Positioner/Electropneumatic" },
        { 0x3E04, [ld291] ,   "Pressure" },
        { 0x3E05, [tp301] ,   "Valve         Positioner" },
        { 0x3E06, [dt301] ,   "Analytical    Density" },
        { 0x3E0A, [ld400] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Foxboro Eckardt Device Type Codes
 */
VARIABLE Foxboro_Eckardt_model_code    /* 0x003F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [tsv175]   ,   "Temperature" },
        { 0x0002, [dmu130]   ,   "Pressure" },
        { 0x0003, [ti_rtt20] ,   "Temperature" },
        { 0x0004, [srd991]   ,   "Valve         Positioner" },
        { 0x0005, [dmu140]   ,   "Pressure" },
        { 0x0006, [srd960]   ,   "Valve         Universal Positioner" },
        { 0x3F01, [tsv175]   ,   "Temperature" },
        { 0x3F02, [dmu130]   ,   "Pressure" },
        { 0x3F03, [ti_rtt20] ,   "Temperature" },
        { 0x3F04, [srd991]   ,   "Valve         Positioner" },
        { 0x3F05, [dmu140]   ,   "Pressure" },
        { 0x3F06, [srd960]   ,   "Valve         Universal Positioner" }
    }
}

/*********************************************************************************
 * Measurement Technology Device Type Codes
 */
VARIABLE Measurement_Technology_model_code    /* 0x0040 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0015, [mtl4841] },
        { 0x0022, [mtl8512] },
        { 0x4015, [mtl4841] },
        { 0x4022, [mtl8512] }
    }
}

/*********************************************************************************
 * Samson Device Type Codes
 */
VARIABLE Samson_model_code    /* 0x0042 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [samson373x_3] ,   "Valve         Positioner" },
        { 0x00F9, [samson3780]   ,   "Valve         Controller" },
        { 0x42EF, [samson373x_3] ,   "Valve         Positioner" },
        { 0x42F9, [samson3780]   ,   "Valve         Controller" }
    }
}

/*********************************************************************************
 * Sparling Instruments Device Type Codes
 */
VARIABLE Sparling_Instruments_model_code    /* 0x0043 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EE, [fm6xx] ,   "Flow          Magnetic" },
        { 0x43EE, [fm6xx] ,   "Flow          Magnetic" }
    }
}

/*********************************************************************************
 * Krohne Device Type Codes
 */
VARIABLE Krohne_model_code    /* 0x0045 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00D2, [ufc400]        },
        { 0x00D3, [tt51cr]        },
        { 0x00D4, [gfc_300_steam] },
        { 0x00D5, [gfc_300_gas]   },
        { 0x00D9, [ifc100]        ,   "Flow          Electromagnetic" },
        { 0x00DB, [tt50cr]        ,   "Temperature" },
        { 0x00DD, [mfc300]        ,   "Flow          Coriolis Mass" },
        { 0x00DE, [vfc070]        ,   "Flow          Vortex" },
        { 0x00E2, [esk2a]         ,   "Flow          Variable Area" },
        { 0x00E3, [ifc300]        ,   "Flow          Electromagnetic" },
        { 0x00E4, [optiflex1300c] ,   "Level         Radar" },
        { 0x00E5, [optiwave7300c] ,   "Level         Radar" },
        { 0x00E6, [m8e]           ,   "Flow          Variable Area" },
        { 0x00E7, [ufc030]        ,   "Flow          Ultrasonic" },
        { 0x00E8, [mfc05x]        ,   "Flow          Coriolis Mass" },
        { 0x00E9, [ifc040]        ,   "Flow          Electromagnetic" },
        { 0x00EA, [m10]           ,   "Flow          Variable Area" },
        { 0x00EB, [ifc210]        },
        { 0x00EC, [bm102]         ,   "Level         Radar - Reflex" },
        { 0x00ED, [vfm31]         ,   "Flow          Vortex" },
        { 0x00EE, [bm100]         ,   "Level         Radar - Reflex" },
        { 0x00EF, [ifc020]        },
        { 0x00F0, [vfm1091]       },
        { 0x00F2, [eskii]         ,   "Flow          Variable Area" },
        { 0x00F3, [ifc110]        ,   "Flow          Magnetic" },
        { 0x00F4, [ifc090]        ,   "Flow          Magnetic" },
        { 0x00F5, [ufc500]        ,   "Flow          Ultrasonic" },
        { 0x00F6, [ifc010]        },
        { 0x00F7, [mfc08x]        ,   "Flow          Coriolis Mass" },
        { 0x00F8, [ifc080]        ,   "Flow          Magnetic" },
        { 0x00F9, [bm70]          ,   "Level         Radar" },
        { 0x45D2, [ufc400]        },
        { 0x45D3, [tt51cr]        },
        { 0x45D4, [gfc_300_steam] },
        { 0x45D5, [gfc_300_gas]   },
        { 0x45D9, [ifc100]        ,   "Flow          Electromagnetic" },
        { 0x45DB, [tt50cr]        ,   "Temperature" },
        { 0x45DD, [mfc300]        ,   "Flow          Coriolis Mass" },
        { 0x45DE, [vfc070]        ,   "Flow          Vortex" },
        { 0x45E2, [esk2a]         ,   "Flow          Variable Area" },
        { 0x45E3, [ifc300]        ,   "Flow          Electromagnetic" },
        { 0x45E4, [optiflex1300c] ,   "Level         Radar" },
        { 0x45E5, [optiwave7300c] ,   "Level         Radar" },
        { 0x45E6, [m8e]           ,   "Flow          Variable Area" },
        { 0x45E7, [ufc030]        ,   "Flow          Ultrasonic" },
        { 0x45E8, [mfc05x]        ,   "Flow          Coriolis Mass" },
        { 0x45E9, [ifc040]        ,   "Flow          Electromagnetic" },
        { 0x45EA, [m10]           ,   "Flow          Variable Area" },
        { 0x45EB, [ifc210]        },
        { 0x45EC, [bm102]         ,   "Level         Radar - Reflex" },
        { 0x45ED, [vfm31]         ,   "Flow          Vortex" },
        { 0x45EE, [bm100]         ,   "Level         Radar - Reflex" },
        { 0x45EF, [ifc020]        },
        { 0x45F0, [vfm1091]       },
        { 0x45F2, [eskii]         ,   "Flow          Variable Area" },
        { 0x45F3, [ifc110]        ,   "Flow          Magnetic" },
        { 0x45F4, [ifc090]        ,   "Flow          Magnetic" },
        { 0x45F5, [ufc500]        ,   "Flow          Ultrasonic" },
        { 0x45F6, [ifc010]        },
        { 0x45F7, [mfc08x]        ,   "Flow          Coriolis Mass" },
        { 0x45F8, [ifc080]        ,   "Flow          Magnetic" },
        { 0x45F9, [bm70]          ,   "Level         Radar" }
    }
}

/*********************************************************************************
 * Druck Device Type Codes
 */
VARIABLE Druck_model_code    /* 0x0047 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E9, [rtx1000h_gauge] ,   "Pressure      Gauge" },
        { 0x00EC, [rtx1000h_sg]    ,   "Pressure      Sealed Gauge" },
        { 0x00EF, [rtx1000h_abs]   ,   "Pressure      Absolute" },
        { 0x47E9, [rtx1000h_gauge] ,   "Pressure      Gauge" },
        { 0x47EC, [rtx1000h_sg]    ,   "Pressure      Sealed Gauge" },
        { 0x47EF, [rtx1000h_abs]   ,   "Pressure      Absolute" }
    }
}

/*********************************************************************************
 * Elcon Instruments Device Type Codes
 */
VARIABLE Elcon_Instruments_model_code    /* 0x0049 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EB, [ao895]      },
        { 0x00EC, [ai895]      },
        { 0x00ED, [mux_2700_f] },
        { 0x00EE, [mux_2700_e] },
        { 0x49EB, [ao895]      },
        { 0x49EC, [ai895]      },
        { 0x49ED, [mux_2700_f] },
        { 0x49EE, [mux_2700_e] }
    }
}

/*********************************************************************************
 * Westlock Controls Device Type Codes
 */
VARIABLE Westlock_Controls_model_code    /* 0x004D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [icot]       ,   "Valve         Digital Positioner w/ PID" },
        { 0x0002, [smartcal]   ,   "Valve         Intelligent Positioner" },
        { 0x0003, [d_epic]     ,   "Valve         Digital Positioner" },
        { 0x0004, [d_epic_esd] ,   "Valve         Digital Positioner" },
        { 0x4D01, [icot]       ,   "Valve         Digital Positioner w/ PID" },
        { 0x4D02, [smartcal]   ,   "Valve         Intelligent Positioner" },
        { 0x4D03, [d_epic]     ,   "Valve         Digital Positioner" },
        { 0x4D04, [d_epic_esd] ,   "Valve         Digital Positioner" }
    }
}

/*********************************************************************************
 * Drexelbrook Device Type Codes
 */
VARIABLE Drexelbrook_model_code    /* 0x004E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0002, [universal_iii] ,   "Level" },
        { 0x00EB, [usonic]        ,   "Level         Ultrasonic" },
        { 0x4E02, [universal_iii] ,   "Level" },
        { 0x4EEB, [usonic]        ,   "Level         Ultrasonic" }
    }
}

/*********************************************************************************
 * Saab Tank Control Device Type Codes
 */
VARIABLE Saab_Tank_Control_model_code    /* 0x004F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00ED, [saab_5600]    ,   "Level         Radar" },
        { 0x00EF, [tankradarpro] ,   "Level         Radar" },
        { 0x4FED, [saab_5600]    ,   "Level         Radar" },
        { 0x4FEF, [tankradarpro] ,   "Level         Radar" }
    }
}

/*********************************************************************************
 * K-TEK Device Type Codes
 */
VARIABLE KTEK_model_code    /* 0x0050 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0067, [spm100]           },
        { 0x0072, [at100_vol]        },
        { 0x0073, [at100_2_vol]      },
        { 0x0076, [at100_temp_vol]   },
        { 0x0077, [at100_2_temp_vol] },
        { 0x0078, [at100]            },
        { 0x007A, [at100_lcd]        },
        { 0x007B, [at100_2_lcd]      },
        { 0x007E, [at100_temp_lcd]   },
        { 0x007F, [at100_2_temp_lcd] },
        { 0x0098, [mt2000]           },
        { 0x00CB, [spm200]           },
        { 0x5067, [spm100]           },
        { 0x5072, [at100_vol]        },
        { 0x5073, [at100_2_vol]      },
        { 0x5076, [at100_temp_vol]   },
        { 0x5077, [at100_2_temp_vol] },
        { 0x5078, [at100]            },
        { 0x507A, [at100_lcd]        },
        { 0x507B, [at100_2_lcd]      },
        { 0x507E, [at100_temp_lcd]   },
        { 0x507F, [at100_2_temp_lcd] },
        { 0x5098, [mt2000]           },
        { 0x50CB, [spm200]           }
    }
}

/*********************************************************************************
 * Draeger Device Type Codes
 */
VARIABLE Draeger_model_code    /* 0x0052 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E9, [pir_7000]     ,   "Analytical    Gas Detector" },
        { 0x00EB, [polytron7000] ,   "Analytical    Gas Detector" },
        { 0x00ED, [polytron2_ir] ,   "Analytical    Infrared Gas Detector" },
        { 0x00F7, [polytron2]    ,   "Analytical    Electrochemical Gas Detector" },
        { 0x52E9, [pir_7000]     ,   "Analytical    Gas Detector" },
        { 0x52EB, [polytron7000] ,   "Analytical    Gas Detector" },
        { 0x52ED, [polytron2_ir] ,   "Analytical    Infrared Gas Detector" },
        { 0x52F7, [polytron2]    ,   "Analytical    Electrochemical Gas Detector" }
    }
}

/*********************************************************************************
 * Siemens Milltronics PI Device Type Codes
 *     Note: was Meridian 
 */
VARIABLE Meridian_model_code    /* 0x0054 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00F8, [msp2002] ,   "Level         Capacitance" },
        { 0x00F9, [mst9500] ,   "Level         Capacitance" },
        { 0x54F8, [msp2002] ,   "Level         Capacitance" },
        { 0x54F9, [mst9500] ,   "Level         Capacitance" }
    }
}

/*********************************************************************************
 * BTG Device Type Codes
 */
VARIABLE BTG_model_code    /* 0x0055 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00DE, [hcm_8000] ,   "Analytical    Measuring Instruments" },
        { 0x55DE, [hcm_8000] ,   "Analytical    Measuring Instruments" }
    }
}

/*********************************************************************************
 * Magnetrol Device Type Codes
 */
VARIABLE Magnetrol_model_code    /* 0x0056 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E2, [model_r82]    ,   "Level         Radar" },
        { 0x00E3, [e3_modulevel] ,   "Level" },
        { 0x00E4, [model_355]    ,   "Level         Ultrasonic" },
        { 0x00E5, [model_705_3x] ,   "Level" },
        { 0x00E6, [model_rx5]    ,   "Level" },
        { 0x00E7, [model_704]    ,   "Level" },
        { 0x00E8, [jupiter]      ,   "Level         Magnostrictive" },
        { 0x00E9, [model_ta2]    ,   "Flow          Mass" },
        { 0x00EA, [model_707]    ,   "Level" },
        { 0x00EB, [model_705_2x] ,   "Level" },
        { 0x00EC, [model_708]    ,   "Level" },
        { 0x00ED, [model_805]    ,   "Level" },
        { 0x00EE, [model_705]    ,   "Level" },
        { 0x00EF, [smartez]      ,   "Level" },
        { 0x56E2, [model_r82]    ,   "Level         Radar" },
        { 0x56E3, [e3_modulevel] ,   "Level" },
        { 0x56E4, [model_355]    ,   "Level         Ultrasonic" },
        { 0x56E5, [model_705_3x] ,   "Level" },
        { 0x56E6, [model_rx5]    ,   "Level" },
        { 0x56E7, [model_704]    ,   "Level" },
        { 0x56E8, [jupiter]      ,   "Level         Magnostrictive" },
        { 0x56E9, [model_ta2]    ,   "Flow          Mass" },
        { 0x56EA, [model_707]    ,   "Level" },
        { 0x56EB, [model_705_2x] ,   "Level" },
        { 0x56EC, [model_708]    ,   "Level" },
        { 0x56ED, [model_805]    ,   "Level" },
        { 0x56EE, [model_705]    ,   "Level" },
        { 0x56EF, [smartez]      ,   "Level" }
    }
}

/*********************************************************************************
 * Metso Automation Device Type Codes
 */
VARIABLE Metso_Automation_model_code    /* 0x0057 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E4, [nd9100ht]  ,   "Valve         Positioner" },
        { 0x00E5, [nd9100h]   ,   "Valve         Positioner" },
        { 0x00EB, [valvguard] ,   "Valve         On/Off Valve Controller" },
        { 0x00EE, [nd800_pt]  ,   "Valve         Positioner/Pneumatic" },
        { 0x00EF, [nd800]     ,   "Valve         Positioner/Pneumatic" },
        { 0x57E4, [nd9100ht]  ,   "Valve         Positioner" },
        { 0x57E5, [nd9100h]   ,   "Valve         Positioner" },
        { 0x57EB, [valvguard] ,   "Valve         On/Off Valve Controller" },
        { 0x57EE, [nd800_pt]  ,   "Valve         Positioner/Pneumatic" },
        { 0x57EF, [nd800]     ,   "Valve         Positioner/Pneumatic" }
    }
}

/*********************************************************************************
 * Siemens Milltronics PI Device Type Codes
 */
VARIABLE Milltronics_model_code    /* 0x0058 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00C8, [probe_86x]     ,   "Level         Ultrasonic" },
        { 0x00C9, [sitrans_lr300] ,   "Level         Radar - Pulse" },
        { 0x00CA, [lr_200]        ,   "Level         Radar" },
        { 0x00CC, [sitrans_lr400] ,   "Level         Radar" },
        { 0x00CD, [probe_lu6m]    ,   "Level         Ultrasonic" },
        { 0x00CE, [probe_lu12m]   ,   "Level         Ultrasonic" },
        { 0x00CF, [probe_lr]      ,   "Level         Radar" },
        { 0x00D1, [sitrans_lr250] ,   "Level         Radar - Pulse" },
        { 0x00D3, [sitrans_lr460] ,   "Level         Radar" },
        { 0x00D4, [sitrans_lr260] ,   "Level         Radar - Pulse" },
        { 0x00D6, [sitrans_lr200] ,   "Level         Radar - Pulse" },
        { 0x00D8, [sitrans_aw200] },
        { 0x58C8, [probe_86x]     ,   "Level         Ultrasonic" },
        { 0x58C9, [sitrans_lr300] ,   "Level         Radar - Pulse" },
        { 0x58CA, [lr_200]        ,   "Level         Radar" },
        { 0x58CC, [sitrans_lr400] ,   "Level         Radar" },
        { 0x58CD, [probe_lu6m]    ,   "Level         Ultrasonic" },
        { 0x58CE, [probe_lu12m]   ,   "Level         Ultrasonic" },
        { 0x58CF, [probe_lr]      ,   "Level         Radar" },
        { 0x58D1, [sitrans_lr250] ,   "Level         Radar - Pulse" },
        { 0x58D3, [sitrans_lr460] ,   "Level         Radar" },
        { 0x58D4, [sitrans_lr260] ,   "Level         Radar - Pulse" },
        { 0x58D6, [sitrans_lr200] ,   "Level         Radar - Pulse" },
        { 0x58D8, [sitrans_aw200] }
    }
}

/*********************************************************************************
 * Anderson Instrument Company Device Type Codes
 */
VARIABLE Anderson_Instrument_Company_model_code    /* 0x005A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00C8, [andrsn1] ,   "Pressure" },
        { 0x5AC8, [andrsn1] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Inor Device Type Codes
 */
VARIABLE Inor_model_code    /* 0x005B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EB, [ipaq_c520_r520] },
        { 0x00EF, [meso]           ,   "Temperature" },
        { 0x5BEB, [ipaq_c520_r520] },
        { 0x5BEF, [meso]           ,   "Temperature" }
    }
}

/*********************************************************************************
 * Robertshaw Device Type Codes
 */
VARIABLE Robertshaw_model_code    /* 0x005C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00C8, [excalibur_7000] ,   "Level" },
        { 0x5CC8, [excalibur_7000] ,   "Level" }
    }
}

/*********************************************************************************
 * PEPPERL FUCHS Device Type Codes
 */
VARIABLE PEPPERL_FUCHS_model_code    /* 0x005D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E0, [pf_wha_gw]    },
        { 0x00E1, [pf_wha_adp]   },
        { 0x00E2, [pf_wha_ut]    },
        { 0x00E3, [pf_wha_rpt]   },
        { 0x00E4, [corrtran]     ,   "Analytical    Corrosion" },
        { 0x00E5, [luc_m]        },
        { 0x00E6, [mux2700_g]    },
        { 0x00E7, [rsd_uo_ex8h]  },
        { 0x00E8, [rsd_ci_ex8h]  },
        { 0x00E9, [ksd2_gw2_pro] },
        { 0x00EA, [barcon_m]     },
        { 0x00EB, [luc_plus]     },
        { 0x00EC, [pulscon_plus] },
        { 0x00ED, [pulscon]      },
        { 0x00EE, [barcon]       },
        { 0x00EF, [kfd2_hmm_16]  },
        { 0x5DE0, [pf_wha_gw]    },
        { 0x5DE1, [pf_wha_adp]   },
        { 0x5DE2, [pf_wha_ut]    },
        { 0x5DE3, [pf_wha_rpt]   },
        { 0x5DE4, [corrtran]     ,   "Analytical    Corrosion" },
        { 0x5DE5, [luc_m]        },
        { 0x5DE6, [mux2700_g]    },
        { 0x5DE7, [rsd_uo_ex8h]  },
        { 0x5DE8, [rsd_ci_ex8h]  },
        { 0x5DE9, [ksd2_gw2_pro] },
        { 0x5DEA, [barcon_m]     },
        { 0x5DEB, [luc_plus]     },
        { 0x5DEC, [pulscon_plus] },
        { 0x5DED, [pulscon]      },
        { 0x5DEE, [barcon]       },
        { 0x5DEF, [kfd2_hmm_16]  }
    }
}

/*********************************************************************************
 * Accutech Device Type Codes
 */
VARIABLE Accutech_model_code    /* 0x005E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EE, [press_dp_xmtr] ,   "Pressure" },
        { 0x00EF, [ai1500]        ,   "Temperature" },
        { 0x5EEE, [press_dp_xmtr] ,   "Pressure" },
        { 0x5EEF, [ai1500]        ,   "Temperature" }
    }
}

/*********************************************************************************
 * Bourdon-Haenni Device Type Codes
 */
VARIABLE Bourdon_Haenni_model_code    /* 0x0060 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00ED, [flexbar_3501] ,   "Pressure" },
        { 0x00EE, [flexbar_hrt]  ,   "Pressure" },
        { 0x00EF, [flextop_hrt]  ,   "Temperature" },
        { 0x60ED, [flexbar_3501] ,   "Pressure" },
        { 0x60EE, [flexbar_hrt]  ,   "Pressure" },
        { 0x60EF, [flextop_hrt]  ,   "Temperature" }
    }
}

/*********************************************************************************
 * Knick Device Type Codes
 */
VARIABLE Knick_model_code    /* 0x0061 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E4, [condi_a211] ,   "Analytical    Conductivity" },
        { 0x00E5, [cond_a211]  ,   "Analytical    Conductivity" },
        { 0x00E6, [oxy_a211]   ,   "Analytical    Dissolved Oxygen" },
        { 0x00E7, [ph_a211]    ,   "Analytical    pH" },
        { 0x00E8, [condi_2211] ,   "Analytical    Conductivity" },
        { 0x00E9, [oxy_2211]   ,   "Analytical    Dissolved Oxygen" },
        { 0x00EA, [cond_2211]  ,   "Analytical    Conductivity" },
        { 0x00EB, [ph_2211]    ,   "Analytical    pH" },
        { 0x61E4, [condi_a211] ,   "Analytical    Conductivity" },
        { 0x61E5, [cond_a211]  ,   "Analytical    Conductivity" },
        { 0x61E6, [oxy_a211]   ,   "Analytical    Dissolved Oxygen" },
        { 0x61E7, [ph_a211]    ,   "Analytical    pH" },
        { 0x61E8, [condi_2211] ,   "Analytical    Conductivity" },
        { 0x61E9, [oxy_2211]   ,   "Analytical    Dissolved Oxygen" },
        { 0x61EA, [cond_2211]  ,   "Analytical    Conductivity" },
        { 0x61EB, [ph_2211]    ,   "Analytical    pH" }
    }
}

/*********************************************************************************
 * VEGA Device Type Codes
 */
VARIABLE VEGA_model_code    /* 0x0062 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00D0, [vegaflex_67] },
        { 0x00D1, [vegaflex_66] },
        { 0x00D2, [vegaflex_65] },
        { 0x00D3, [vegaflex_63] },
        { 0x00D4, [vegaflex_62] },
        { 0x00D5, [vegaflex_61] },
        { 0x00D6, [vegapuls_68] },
        { 0x00D7, [vegapuls_67] },
        { 0x00D8, [vegapuls_66] },
        { 0x00D9, [vegapuls_65] },
        { 0x00DA, [vegapuls_63] },
        { 0x00DB, [vegapuls_62] },
        { 0x00DC, [vegapuls_61] },
        { 0x62D0, [vegaflex_67] },
        { 0x62D1, [vegaflex_66] },
        { 0x62D2, [vegaflex_65] },
        { 0x62D3, [vegaflex_63] },
        { 0x62D4, [vegaflex_62] },
        { 0x62D5, [vegaflex_61] },
        { 0x62D6, [vegapuls_68] },
        { 0x62D7, [vegapuls_67] },
        { 0x62D8, [vegapuls_66] },
        { 0x62D9, [vegapuls_65] },
        { 0x62DA, [vegapuls_63] },
        { 0x62DB, [vegapuls_62] },
        { 0x62DC, [vegapuls_61] }
    }
}

/*********************************************************************************
 * MTS Systems Corp. Device Type Codes
 */
VARIABLE MTS_SYS_CORPS_model_code    /* 0x0063 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00ED, [m_series] ,   "Level" },
        { 0x63ED, [m_series] ,   "Level" }
    }
}

/*********************************************************************************
 * Oval Device Type Codes
 */
VARIABLE Oval_model_code    /* 0x0064 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0064, [ultraoval]     ,   "Flow" },
        { 0x0065, [exdelta]       ,   "Flow          Vortex" },
        { 0x006E, [mass_flo_9401] ,   "Flow          Coriolis Mass" },
        { 0x006F, [mass_flo_9801] ,   "Flow          Coriolis Mass" },
        { 0x0070, [mass_flo_9201] ,   "Flow          Coriolis Mass" },
        { 0x007B, [mass_flo_9431] ,   "Flow          Coriolis Mass" },
        { 0x6464, [ultraoval]     ,   "Flow" },
        { 0x6465, [exdelta]       ,   "Flow          Vortex" },
        { 0x646E, [mass_flo_9401] ,   "Flow          Coriolis Mass" },
        { 0x646F, [mass_flo_9801] ,   "Flow          Coriolis Mass" },
        { 0x6470, [mass_flo_9201] ,   "Flow          Coriolis Mass" },
        { 0x647B, [mass_flo_9431] ,   "Flow          Coriolis Mass" }
    }
}

/*********************************************************************************
 * Masoneilan-Dresser Device Type Codes
 */
VARIABLE Masoneilan_model_code    /* 0x0065 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0064, [hdlt]    ,   "Level" },
        { 0x00C8, [svi]     ,   "Valve         Positioner" },
        { 0x00C9, [svi2]    ,   "Valve         Positioner" },
        { 0x00CA, [svi2a]   ,   "Valve         Positioner" },
        { 0x00CB, [svi2esd] ,   "Valve         Controller" },
        { 0x6564, [hdlt]    ,   "Level" },
        { 0x65C8, [svi]     ,   "Valve         Positioner" },
        { 0x65C9, [svi2]    ,   "Valve         Positioner" },
        { 0x65CA, [svi2a]   ,   "Valve         Positioner" },
        { 0x65CB, [svi2esd] ,   "Valve         Controller" }
    }
}

/*********************************************************************************
 * Besta Device Type Codes
 */
VARIABLE Besta_model_code    /* 0x0066 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [cls_4_20] ,   "Level         Continuous Capactive" },
        { 0x66EF, [cls_4_20] ,   "Level         Continuous Capactive" }
    }
}

/*********************************************************************************
 * Ohmart Device Type Codes
 */
VARIABLE Ohmart_model_code    /* 0x0067 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E0, [dsth_lsth]      ,   "Level         Density - Nuclear" },
        { 0x00E1, [dsth_lsth_comp] ,   "Level         Density - Nuclear" },
        { 0x67E0, [dsth_lsth]      ,   "Level         Density - Nuclear" },
        { 0x67E1, [dsth_lsth_comp] ,   "Level         Density - Nuclear" }
    }
}

/*********************************************************************************
 * Harold Beck and Sons Device Type Codes
 */
VARIABLE Harold_Beck_and_Sons_model_code    /* 0x0068 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [esr_d]    ,   "Valve         Damper Actuator" },
        { 0x000A, [beck_dcm] ,   "Valve         Electric Damper Actuator" },
        { 0x00EF, [beck_mk2] ,   "Valve         Damper Actuator" },
        { 0x6801, [esr_d]    ,   "Valve         Damper Actuator" },
        { 0x680A, [beck_dcm] ,   "Valve         Electric Damper Actuator" },
        { 0x68EF, [beck_mk2] ,   "Valve         Damper Actuator" }
    }
}

/*********************************************************************************
 * Wika Device Type Codes
 */
VARIABLE Wika_model_code    /* 0x006B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EE, [unitrans] ,   "Pressure" },
        { 0x00EF, [t32]      ,   "Temperature" },
        { 0x6BEE, [unitrans] ,   "Pressure" },
        { 0x6BEF, [t32]      ,   "Temperature" }
    }
}

/*********************************************************************************
 * Bopp & Reuther Messtechnik Device Type Codes
 * Note: was Bopp & Reuther Heinrichs
 */
VARIABLE Bopp_Reuther_Heinrichs_model_code    /* 0x006C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EB, [umc2] ,   "Flow          Mass" },
        { 0x00EC, [es]   ,   "Flow          Electronic" },
        { 0x00ED, [vtx]  ,   "Flow          Vortex" },
        { 0x00EE, [dimf] ,   "Analytical    Density" },
        { 0x00EF, [ust1] ,   "Flow" },
        { 0x6CEB, [umc2] ,   "Flow          Mass" },
        { 0x6CEC, [es]   ,   "Flow          Electronic" },
        { 0x6CED, [vtx]  ,   "Flow          Vortex" },
        { 0x6CEE, [dimf] ,   "Analytical    Density" },
        { 0x6CEF, [ust1] ,   "Flow" }
    }
}

/*********************************************************************************
 * PR Electronics Device Type Codes
 */
VARIABLE PR_Electronics_model_code    /* 0x006D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00DF, [t55]           ,   "Temperature" },
        { 0x00EE, [pretrans_6335] ,   "Temperature" },
        { 0x00EF, [pretop_5335]   ,   "Temperature" },
        { 0x6DDF, [t55]           ,   "Temperature" },
        { 0x6DEE, [pretrans_6335] ,   "Temperature" },
        { 0x6DEF, [pretop_5335]   ,   "Temperature" }
    }
}

/*********************************************************************************
 * Apparatebau Hundsbach Device Type Codes
 */
VARIABLE Apparatebau_Hundsbach_model_code    /* 0x0071 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EE, [mt115] ,   "Temperature" },
        { 0x71EE, [mt115] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Dynisco Device Type Codes
 */
VARIABLE Dynisco_model_code    /* 0x0072 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00DE, [spx]   ,   "Pressure" },
        { 0x00DF, [ipxii] ,   "Pressure      Multivariable" },
        { 0x00E0, [ipx]   ,   "Pressure      Multivariable" },
        { 0x72DE, [spx]   ,   "Pressure" },
        { 0x72DF, [ipxii] ,   "Pressure      Multivariable" },
        { 0x72E0, [ipx]   ,   "Pressure      Multivariable" }
    }
}

/*********************************************************************************
 * Direct Measurement Device Type Codes
 */
VARIABLE Direct_Measurement_model_code    /* 0x0074 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [dmc_r1a] ,   "Flow          Coriolis Mass" },
        { 0x74EF, [dmc_r1a] ,   "Flow          Coriolis Mass" }
    }
}

/*********************************************************************************
 * Klay Device Type Codes
 */
VARIABLE Klay_model_code    /* 0x0075 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [klay_2000] ,   "Pressure" },
        { 0x75EF, [klay_2000] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Buerkert Fluid Control Systems Device Type Codes
 */
VARIABLE Buerkert_Fluid_Control_Systems_model_code    /* 0x0078 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [burkert8630] },
        { 0x78EF, [burkert8630] }
    }
}

/*********************************************************************************
 * GLI Device Type Codes
 */
VARIABLE GLI_model_code    /* 0x007C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EE, [m33_53p] },
        { 0x00EF, [m33_53c] },
        { 0x7CEE, [m33_53p] },
        { 0x7CEF, [m33_53c] }
    }
}

/*********************************************************************************
 * Paper Machine Components Device Type Codes
 */
VARIABLE Paper_Machine_Components_model_code    /* 0x007E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00E0, [smt_el] ,   "Pressure" },
        { 0x7EE0, [smt_el] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Labom Device Type Codes
 */
VARIABLE Labom_model_code    /* 0x007F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x003C, [pascal_ci] ,   "Pressure" },
        { 0x00E0, [ipx]       ,   "Pressure      Multivariable" },
        { 0x00EF, [pascal_cv] },
        { 0x7F3C, [pascal_ci] ,   "Pressure" },
        { 0x7FE0, [ipx]       ,   "Pressure      Multivariable" },
        { 0x7FEF, [pascal_cv] }
    }
}

/*********************************************************************************
 * Danfoss Device Type Codes
 */
VARIABLE Danfoss_model_code    /* 0x0080 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0003, [magflo] ,   "Flow          Magnetic" },
        { 0x8003, [magflo] ,   "Flow          Magnetic" }
    }
}

/*********************************************************************************
 * Turbo Device Type Codes
 */
VARIABLE Turbo_model_code    /* 0x0081 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [intermag_transmag] ,   "Flow          Magnetic" },
        { 0x817F, [intermag_transmag] ,   "Flow          Magnetic" }
    }
}

/*********************************************************************************
 * TOKYO KEISO Device Type Codes
 */
VARIABLE Tokyo_Keiso_model_code    /* 0x0082 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007B, [fw_9000]  ,   "Level" },
        { 0x007F, [fst_3000] ,   "Level" },
        { 0x827B, [fw_9000]  ,   "Level" },
        { 0x827F, [fst_3000] ,   "Level" }
    }
}

/*********************************************************************************
 * SMC Device Type Codes
 */
VARIABLE SMC_model_code    /* 0x0083 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007D, [ip8001]    ,   "Valve         Positioner/Electropneumatic" },
        { 0x007E, [ip8101]    ,   "Valve         Positioner/Electropneumatic" },
        { 0x00EF, [f793_e701] ,   "Valve         Positioner/Electropneumatic" },
        { 0x837D, [ip8001]    ,   "Valve         Positioner/Electropneumatic" },
        { 0x837E, [ip8101]    ,   "Valve         Positioner/Electropneumatic" },
        { 0x83EF, [f793_e701] ,   "Valve         Positioner/Electropneumatic" }
    }
}

/*********************************************************************************
 * Status Instruments Device Type Codes
 */
VARIABLE Status_Instruments_model_code    /* 0x0084 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [sem_300] ,   "Temperature" },
        { 0x84EF, [sem_300] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Huakong Device Type Codes
 */
VARIABLE Huakong_model_code    /* 0x0085 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [hk_tt01] ,   "Temperature" },
        { 0x857F, [hk_tt01] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Duon System Device Type Codes
 */
VARIABLE Duon_System_model_code    /* 0x0086 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0061, [apt3200]  ,   "Pressure" },
        { 0x006B, [apt3100]  ,   "Pressure" },
        { 0x0075, [att2100s] ,   "Temperature" },
        { 0x8661, [apt3200]  ,   "Pressure" },
        { 0x866B, [apt3100]  ,   "Pressure" },
        { 0x8675, [att2100s] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Vortek Instruments, LLC Device Type Codes
 */
VARIABLE Vortek_Instruments_model_code    /* 0x0087 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [innova_mass] ,   "Flow          Vortex - Multiparameter Mass" },
        { 0x8701, [innova_mass] ,   "Flow          Vortex - Multiparameter Mass" }
    }
}

/*********************************************************************************
 * Action Instruments Device Type Codes
 */
VARIABLE Action_Instruments_model_code    /* 0x0089 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [t798] ,   "Temperature" },
        { 0x89EF, [t798] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Magtech Device Type Codes
 */
VARIABLE Magtech_model_code    /* 0x008C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0088, [ltm_100] ,   "Level         Magnostrictive" },
        { 0x0089, [ltm_300] ,   "Level" },
        { 0x8C88, [ltm_100] ,   "Level         Magnostrictive" },
        { 0x8C89, [ltm_300] ,   "Level" }
    }
}

/*********************************************************************************
 * Rueger Device Type Codes
 */
VARIABLE Rueger_model_code    /* 0x008D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [s95_hrt]  ,   "Temperature" },
        { 0x007F, [s95_3u_2] ,   "Temperature" },
        { 0x8D01, [s95_hrt]  ,   "Temperature" },
        { 0x8D7F, [s95_3u_2] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Mettler Toledo Device Type Codes
 */
VARIABLE Mettler_Toledo_model_code    /* 0x008E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0074, [condi_m420] ,   "Analytical    Conductivity" },
        { 0x0075, [cond_m420]  ,   "Analytical    Conductivity" },
        { 0x0076, [o2_m420]    ,   "Analytical    Dissolved Oxygen" },
        { 0x0077, [ph_m420]    ,   "Analytical    pH" },
        { 0x0078, [condi7100]  ,   "Analytical    Conductivity" },
        { 0x0079, [o2_4100e]   ,   "Analytical    Dissolved Oxygen" },
        { 0x007A, [cond7100]   ,   "Analytical    Conductivity" },
        { 0x007B, [ph_2100]    ,   "Analytical    pH" },
        { 0x8E74, [condi_m420] ,   "Analytical    Conductivity" },
        { 0x8E75, [cond_m420]  ,   "Analytical    Conductivity" },
        { 0x8E76, [o2_m420]    ,   "Analytical    Dissolved Oxygen" },
        { 0x8E77, [ph_m420]    ,   "Analytical    pH" },
        { 0x8E78, [condi7100]  ,   "Analytical    Conductivity" },
        { 0x8E79, [o2_4100e]   ,   "Analytical    Dissolved Oxygen" },
        { 0x8E7A, [cond7100]   ,   "Analytical    Conductivity" },
        { 0x8E7B, [ph_2100]    ,   "Analytical    pH" }
    }
}

/*********************************************************************************
 * Det-Tronics Device Type Codes
 */
VARIABLE Det_Tronics_model_code    /* 0x008F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0076, [x2200]    ,   "Analytical    UV Flame Detector" },
        { 0x0077, [x5200]    ,   "Analytical    UVIR Flame Detector" },
        { 0x0078, [x9800]    ,   "Analytical    IR Flame Detector" },
        { 0x0079, [x3302]    ,   "Analytical    Fire Detector" },
        { 0x007A, [ud10]     ,   "Analytical    Gas Detector Display Interface" },
        { 0x007B, [gt3000]   ,   "Analytical    Toxic Gas Detector" },
        { 0x007C, [x3301]    ,   "Analytical    Flame Detector" },
        { 0x007E, [opecl_rx] ,   "Analytical    Infrared Gas Detector" },
        { 0x007F, [eclipse]  ,   "Analytical    Infrared Gas Detector" },
        { 0x8F76, [x2200]    ,   "Analytical    UV Flame Detector" },
        { 0x8F77, [x5200]    ,   "Analytical    UVIR Flame Detector" },
        { 0x8F78, [x9800]    ,   "Analytical    IR Flame Detector" },
        { 0x8F79, [x3302]    ,   "Analytical    Fire Detector" },
        { 0x8F7A, [ud10]     ,   "Analytical    Gas Detector Display Interface" },
        { 0x8F7B, [gt3000]   ,   "Analytical    Toxic Gas Detector" },
        { 0x8F7C, [x3301]    ,   "Analytical    Flame Detector" },
        { 0x8F7E, [opecl_rx] ,   "Analytical    Infrared Gas Detector" },
        { 0x8F7F, [eclipse]  ,   "Analytical    Infrared Gas Detector" }
    }
}

/*********************************************************************************
 * Thermo MeasureTech Device Type Codes
 */
VARIABLE Thermo_MeasureTech_model_code    /* 0x0090 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007D, [ndmi]      ,   "Analytical    Density - Nuclear" },
        { 0x007E, [accu_wave] ,   "Level         Radar" },
        { 0x007F, [ncmi]      ,   "Level         Nuclear" },
        { 0x907D, [ndmi]      ,   "Analytical    Density - Nuclear" },
        { 0x907E, [accu_wave] ,   "Level         Radar" },
        { 0x907F, [ncmi]      ,   "Level         Nuclear" }
    }
}

/*********************************************************************************
 * Dezurik Device Type Codes
 */
VARIABLE Dezurik_model_code    /* 0x0091 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [dezurik_positioner] ,   "Valve         Positioner/Electropneumatic" },
        { 0x91EF, [dezurik_positioner] ,   "Valve         Positioner/Electropneumatic" }
    }
}

/*********************************************************************************
 * Phase Dynamics Device Type Codes
 */
VARIABLE Phase_Dynamics_model_code    /* 0x0092 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [analyzer] ,   "Analytical    Microwave" },
        { 0x927F, [analyzer] ,   "Analytical    Microwave" }
    }
}

/*********************************************************************************
 * Welltech Device Type Codes
 */
VARIABLE Welltech_model_code    /* 0x0093 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007A, [wt3600] },
        { 0x007B, [wt3000] },
        { 0x007C, [wt2000] ,   "Pressure" },
        { 0x937A, [wt3600] },
        { 0x937B, [wt3000] },
        { 0x937C, [wt2000] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Metran Device Type Codes
 */
VARIABLE Metran_model_code    /* 0x0099 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0077, [metran_303pr]  ,   "Flow" },
        { 0x0079, [metran_150]    ,   "Pressure" },
        { 0x007B, [metran_390]    },
        { 0x007C, [metran_300prm] },
        { 0x007D, [metran_49]     },
        { 0x007E, [metran_280]    ,   "Temperature" },
        { 0x007F, [metran_100]    ,   "Pressure" },
        { 0x9977, [metran_303pr]  ,   "Flow" },
        { 0x9979, [metran_150]    ,   "Pressure" },
        { 0x997B, [metran_390]    },
        { 0x997C, [metran_300prm] },
        { 0x997D, [metran_49]     },
        { 0x997E, [metran_280]    ,   "Temperature" },
        { 0x997F, [metran_100]    ,   "Pressure" }
    }
}

/*********************************************************************************
 * Milton Roy Co. Device Type Codes
 */
VARIABLE Milton_Roy_model_code    /* 0x009A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [p_series] },
        { 0x9A7F, [p_series] }
    }
}

/*********************************************************************************
 * PMV Device Type Codes
 */
VARIABLE PMV_model_code    /* 0x009B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00D3, [d3] ,   "Valve         Positioner" },
        { 0x9BD3, [d3] ,   "Valve         Positioner" }
    }
}

/*********************************************************************************
 * Turck Device Type Codes
 */
VARIABLE Turck_model_code    /* 0x009C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [kmu_hli] ,   "Temperature" },
        { 0x9C01, [kmu_hli] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Panametrics Device Type Codes
 */
VARIABLE Panametrics_model_code    /* 0x009D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0070, [x868] ,   "Flow          Ultrasonic" },
        { 0x9D70, [x868] ,   "Flow          Ultrasonic" }
    }
}

/*********************************************************************************
 * Stahl Device Type Codes
 */
VARIABLE Stahl_model_code    /* 0x009E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [ics_mux]          },
        { 0x0002, [ics_1000]         },
        { 0x0003, [vos_200]          },
        { 0x0004, [ics_9148]         },
        { 0x0005, [is_remote_io]     },
        { 0x0006, [is_pac_9192_16ch] },
        { 0x0007, [is_pac_9192_32ch] },
        { 0x9E01, [ics_mux]          },
        { 0x9E02, [ics_1000]         },
        { 0x9E03, [vos_200]          },
        { 0x9E04, [ics_9148]         },
        { 0x9E05, [is_remote_io]     },
        { 0x9E06, [is_pac_9192_16ch] },
        { 0x9E07, [is_pac_9192_32ch] }
    }
}

/*********************************************************************************
 * Analytical Technology Inc. Device Type Codes
 */
VARIABLE Analytical_Technology_Inc_model_code    /* 0x009F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [D12] ,   "Analytical    Gas Detector" },
        { 0x9F7F, [D12] ,   "Analytical    Gas Detector" }
    }
}

/*********************************************************************************
 * FINT Device Type Codes
 */
VARIABLE FINT_model_code    /* 0x00A0 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0002, [pir_2000] ,   "Analytical    Gas Detector" },
        { 0x00ED, [oxi5000]  ,   "Analytical    Oxygen" },
        { 0xA002, [pir_2000] ,   "Analytical    Gas Detector" },
        { 0xA0ED, [oxi5000]  ,   "Analytical    Oxygen" }
    }
}

/*********************************************************************************
 * BERTHOLD Device Type Codes
 */
VARIABLE BERTHOLD_model_code    /* 0x00A1 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007C, [lb466] },
        { 0x007D, [lb491] ,   "Analytical    Density - Radiometric" },
        { 0x007E, [lb460] ,   "Level         Radiometric" },
        { 0x007F, [lb490] ,   "Level         Radiometric" },
        { 0xA17C, [lb466] },
        { 0xA17D, [lb491] ,   "Analytical    Density - Radiometric" },
        { 0xA17E, [lb460] ,   "Level         Radiometric" },
        { 0xA17F, [lb490] ,   "Level         Radiometric" }
    }
}

/*********************************************************************************
 * InterCorr Device Type Codes
 */
VARIABLE InterCorr_model_code    /* 0x00A2 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [smartcet_18c] ,   "Analytical    Corrosion" },
        { 0xA2EF, [smartcet_18c] ,   "Analytical    Corrosion" }
    }
}

/*********************************************************************************
 * Components Device Type Codes
 */
VARIABLE Fluid_Components_model_code    /* 0x00A6 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0078, [st98] ,   "Flow" },
        { 0xA678, [st98] ,   "Flow" }
    }
}

/*********************************************************************************
 * Invensys Device Type Codes
 */
VARIABLE Invensys_model_code    /* 0x00A9 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x002E, [inv_ia_pressure] ,   "Pressure" },
        { 0x0034, [cft50]           },
        { 0xA92E, [inv_ia_pressure] ,   "Pressure" },
        { 0xA934, [cft50]           }
    }
}

/*********************************************************************************
 * TycoValveControls Device Type Codes
 */
VARIABLE Tyco_Valve_Controls_model_code    /* 0x00AB */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [smartcal] ,   "Valve         Digital Positioner w/ PID" },
        { 0xAB01, [smartcal] ,   "Valve         Digital Positioner w/ PID" }
    }
}

/*********************************************************************************
 * J-Tec Associates Device Type Codes
 */
VARIABLE JTec_Associates_model_code    /* 0x00AD */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0000, [jtec_gasflowmeter]    ,   "Analytical    Gas/Steam" },
        { 0x0001, [jtec_liquidflowmeter] },
        { 0xAD00, [jtec_gasflowmeter]    ,   "Analytical    Gas/Steam" },
        { 0xAD01, [jtec_liquidflowmeter] }
    }
}

/*********************************************************************************
 * Tracerco Device Type Codes
 */
VARIABLE Tracerco_model_code    /* 0x00AE */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [pri_150]                ,   "Level         Nucleonic" },
        { 0x009F, [level_combination_unit] },
        { 0xAE7F, [pri_150]                ,   "Level         Nucleonic" },
        { 0xAE9F, [level_combination_unit] }
    }
}

/*********************************************************************************
 * Phoenix Contact Device Type Codes
 */
VARIABLE Phoenix_Contact_model_code    /* 0x00B0 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [mcr_ts_lp]           ,   "Temperature   DIN Rail Mounted" },
        { 0x0002, [mcr_ht_ts]           ,   "Temperature   Head Mounted" },
        { 0x0003, [macx_mcr_s_mux_16ch] },
        { 0x0004, [macx_mcr_s_mux_32ch] },
        { 0xB001, [mcr_ts_lp]           ,   "Temperature   DIN Rail Mounted" },
        { 0xB002, [mcr_ht_ts]           ,   "Temperature   Head Mounted" },
        { 0xB003, [macx_mcr_s_mux_16ch] },
        { 0xB004, [macx_mcr_s_mux_32ch] }
    }
}

/*********************************************************************************
 * Amer. Level Instr. Device Type Codes
 */
VARIABLE Amer_Level_Instr_model_code    /* 0x00B2 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [model_32e] ,   "Level         Capacitance" },
        { 0xB27F, [model_32e] ,   "Level         Capacitance" }
    }
}

/*********************************************************************************
 * YTC Device Type Codes
 */
VARIABLE YTC_model_code    /* 0x00B4 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [yt_2300] ,   "Valve         Positioner" },
        { 0x0002, [yt_2400] ,   "Valve         Positioner" },
        { 0xB401, [yt_2300] ,   "Valve         Positioner" },
        { 0xB402, [yt_2400] ,   "Valve         Positioner" }
    }
}

/*********************************************************************************
 * Pyromation Inc. Device Type Codes
 */
VARIABLE Pyromation_Inc_model_code    /* 0x00B5 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [series442] ,   "Temperature" },
        { 0x0080, [series642] ,   "Temperature" },
        { 0xB57F, [series442] ,   "Temperature" },
        { 0xB580, [series642] ,   "Temperature" }
    }
}

/*********************************************************************************
 * Satron Instruments Device Type Codes
 */
VARIABLE Satron_Instruments_model_code    /* 0x00B6 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [v_series] ,   "Pressure" },
        { 0xB67F, [v_series] ,   "Pressure" }
    }
}

/*********************************************************************************
 * BD Sensors Device Type Codes
 */
VARIABLE BD_Sensors_model_code    /* 0x00B9 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007F, [dmd_331_a] ,   "Pressure" },
        { 0xB97F, [dmd_331_a] ,   "Pressure" }
    }
}

/*********************************************************************************
 * APLISENS Device Type Codes
 */
VARIABLE APLISENS_model_code    /* 0x00BC */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007A, [li_24]       ,   "Temperature" },
        { 0x007B, [apc_2000alw] ,   "Pressure" },
        { 0xBC7A, [li_24]       ,   "Temperature" },
        { 0xBC7B, [apc_2000alw] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Badger Meter Device Type Codes
 */
VARIABLE Badger_Meter_model_code    /* 0x00BD */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [primo_advanced] ,   "Flow          Electromagnetic" },
        { 0xBD01, [primo_advanced] ,   "Flow          Electromagnetic" }
    }
}

/*********************************************************************************
 * GP:50 Device Type Codes
 */
VARIABLE GP_50_model_code    /* 0x00BF */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x007C, [mdl_400] ,   "Pressure" },
        { 0xBF7C, [mdl_400] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Kongsberg Maritime Device Type Codes
 */
VARIABLE Kongsberg_Maritime_model_code    /* 0x00C0 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x00EF, [gt400] ,   "Pressure" },
        { 0xC0EF, [gt400] ,   "Pressure" }
    }
}

/*********************************************************************************
 * ASA S.p.A. Device Type Codes
 */
VARIABLE ASA_SpA_model_code    /* 0x00C1 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [cg_asameter] },
        { 0xC101, [cg_asameter] }
    }
}

/*********************************************************************************
 * Hengesbach Device Type Codes
 */
VARIABLE Hengesbach_model_code    /* 0x00C2 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0021, [te_52] ,   "Temperature   Head Mounted" },
        { 0xC221, [te_52] ,   "Temperature   Head Mounted" }
    }
}

/*********************************************************************************
 * Lanlian Instruments Device Type Codes
 */
VARIABLE Lanlian_Instruments_model_code    /* 0x00C3 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0074, [lsiii_pressure] ,   "Pressure" },
        { 0xC374, [lsiii_pressure] ,   "Pressure" }
    }
}

/*********************************************************************************
 * Spectrum Controls Device Type Codes
 */
VARIABLE Spectrum_Controls_model_code    /* 0x00C4 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, [spectrum_io_module] },
        { 0xC401, [spectrum_io_module] }
    }
}

/*********************************************************************************
 * Kajaani Process Measurements Device Type Codes
 */
VARIABLE Kajaani_Process_Measurements_model_code    /* 0x00C5 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [kc3] ,   "Analytical    Blade Consistency" },
        { 0x0081, [kc5] ,   "Analytical    Rotary Consistency" },
        { 0xC580, [kc3] ,   "Analytical    Blade Consistency" },
        { 0xC581, [kc5] ,   "Analytical    Rotary Consistency" }
    }
}

/*********************************************************************************
 * FAFNIR Device Type Codes
 */
VARIABLE FAFNIR_model_code    /* 0x00C6 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [torrix] },
        { 0xC680, [torrix] }
    }
}

/*********************************************************************************
 * SICK-MAIHAK Device Type Codes
 */
VARIABLE SICK_model_code    /* 0x00C7 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [flowsic] ,   "Flow          Ultrasonic" },
        { 0xC780, [flowsic] ,   "Flow          Ultrasonic" }
    }
}

/*********************************************************************************
 * Spirax Sarco Italy Device Type Codes
 */
VARIABLE Spirax_Sarco_Italy_model_code    /* 0x00CA */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [sp301] ,   "Valve         Smart Valve Positioner" },
        { 0xCA80, [sp301] ,   "Valve         Smart Valve Positioner" }
    }
}

/*********************************************************************************
 * ecfluid SA Device Type Codes
 */
VARIABLE Tecfluid_SA_model_code    /* 0x00CC */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [ch420l] },
        { 0x0081, [ch420r] },
        { 0xCC80, [ch420l] },
        { 0xCC81, [ch420r] }
    }
}

/*********************************************************************************
 * Roost Device Type Codes
 */
VARIABLE Roost_model_code    /* 0x00CE */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [epp300] ,   "Valve         Positioner/Electropneumatic" },
        { 0xCE80, [epp300] ,   "Valve         Positioner/Electropneumatic" }
    }
}

/*********************************************************************************
 * KOSO Device Type Codes
 */
VARIABLE KOSO_model_code    /* 0x00CF */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [ep1000] ,   "Valve         Positioner/Electropneumatic" },
        { 0x0081, [ep1001] ,   "Valve         Positioner/Electropneumatic" },
        { 0xCF80, [ep1000] ,   "Valve         Positioner/Electropneumatic" },
        { 0xCF81, [ep1001] ,   "Valve         Positioner/Electropneumatic" }
    }
}

/*********************************************************************************
 * HEINRICHS Device Type Codes
 */
VARIABLE HEINRICHS_model_code    /* 0x00D3 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [pad] ,   "Pressure      Absolute/Differential" },
        { 0x0081, [pas] ,   "Pressure      Absolute" },
        { 0xD380, [pad] ,   "Pressure      Absolute/Differential" },
        { 0xD381, [pas] ,   "Pressure      Absolute" }
    }
}

/*********************************************************************************
 * SIC Device Type Codes
 */
VARIABLE SIC_model_code    /* 0x00D4 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [pes]         ,   "Pressure" },
        { 0x0082, [hvp]         ,   "Positioner" },
        { 0x0085, [hvp1114]     ,   "Valve         Positioner/Pneumatic" },
        { 0x0086, [flow_master] ,   "Flow          Electromagnetic" },
        { 0xD480, [pes]         ,   "Pressure" },
        { 0xD482, [hvp]         ,   "Positioner" },
        { 0xD485, [hvp1114]     ,   "Valve         Positioner/Pneumatic" },
        { 0xD486, [flow_master] ,   "Flow          Electromagnetic" }
    }
}

/*********************************************************************************
 * HACH LANGE Device Type Codes
 */
VARIABLE HACH_LANGE_model_code    /* 0x00D5 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [si792p] ,   "Analytical    pH" },
        { 0x0081, [si792c] ,   "Analytical    Conductivity" },
        { 0x0082, [si792t] ,   "Analytical    Conductivity" },
        { 0x0083, [si792e] ,   "Analytical    Conductivity" },
        { 0x0084, [si792d] ,   "Analytical    Dissolved Oxygen" },
        { 0xD580, [si792p] ,   "Analytical    pH" },
        { 0xD581, [si792c] ,   "Analytical    Conductivity" },
        { 0xD582, [si792t] ,   "Analytical    Conductivity" },
        { 0xD583, [si792e] ,   "Analytical    Conductivity" },
        { 0xD584, [si792d] ,   "Analytical    Dissolved Oxygen" }
    }
}

/*********************************************************************************
 * Spectrex Device Type Codes
 */
VARIABLE Spectrex_model_code    /* 0x00DB */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [sharpeye] ,   "Analytical    Flame Detector" },
        { 0x0081, [safeye]   },
        { 0xDB80, [sharpeye] ,   "Analytical    Flame Detector" },
        { 0xDB81, [safeye]   }
    }
}

/*********************************************************************************
 * General Monitors Device Type Codes
 */
VARIABLE General_Monitors_model_code    /* 0x00DF */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [fl4000]  ,   "Analytical    Flame Detector" },
        { 0x0081, [s4000ch] ,   "Analytical    Combustible Gas Detector" },
        { 0x0082, [s4000th] ,   "Analytical    Toxic Gas Detector" },
        { 0x0083, [ir400]   ,   "Analytical    Point Infrared Gas Detector" },
        { 0x0084, [ir4000]  ,   "Analytical    Multi-Detector Monitor System" },
        { 0x0089, [ts4000h] ,   "Analytical    Toxic Gas Detector" },
        { 0x0090, [fl310xh] ,   "Analytical    Flame Detector" },
        { 0xDF80, [fl4000]  ,   "Analytical    Flame Detector" },
        { 0xDF81, [s4000ch] ,   "Analytical    Combustible Gas Detector" },
        { 0xDF82, [s4000th] ,   "Analytical    Toxic Gas Detector" },
        { 0xDF83, [ir400]   ,   "Analytical    Point Infrared Gas Detector" },
        { 0xDF84, [ir4000]  ,   "Analytical    Multi-Detector Monitor System" },
        { 0xDF89, [ts4000h] ,   "Analytical    Toxic Gas Detector" },
        { 0xDF90, [fl310xh] ,   "Analytical    Flame Detector" }
    }
}

/*********************************************************************************
 * Manufacturer Expansion Device Type Codes
 */
VARIABLE manufacturer_expansion_model_code    /* 0x00E0 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [esd3000]               },
        { 0x00EC, [est3051t]              },
        { 0x00ED, [est3051s]              },
        { 0x0082, [sdt420]                },
        { 0x00B4, [stf]                   ,   "Flow          Thermal" },
        { 0x00B5, [smf]                   ,   "Flow          Electromagnetic" },
        { 0x0083, [rt_ex15]               },
        { 0x0084, [ss]                    ,   "Valve         Positioner" },
        { 0x0085, [apm_3dlevelscanner_m]  },
        { 0x0086, [apm_3dlevelscanner_s]  },
        { 0x0087, [apm_3dlevelscanner_l]  },
        { 0x0088, [ex200h_positioner]     ,   "Valve         Positioner/Electro-hydraulic" },
        { 0x0089, [is200h_positioner]     },
        { 0x008A, [r3x]                   },
        { 0x008B, [detcon_700_bridge]     },
        { 0x008C, [ultima_xl_xt]          ,   "Analytical    Gas Detector" },
        { 0x009F, [ultimaxeh]             ,   "Analytical    Gas Detector" },
        { 0x00BC, [flamegard]             },
        { 0x00F2, [safeye]                },
        { 0x00F3, [primax]                },
        { 0x008D, [cmm_01_mass_flow]      ,   "Flow          Coriolis Mass" },
        { 0x00C8, [cvm_01]                },
        { 0x00C9, [tdm_01]                },
        { 0x0081, [sensor_don]            },
        { 0x008E, [jlt_6000]              },
        { 0x008F, [smartronic_ma]         },
        { 0x0090, [cms_standard]          },
        { 0x0091, [millennium_2]          },
        { 0x009E, [millennium_2_basic]    ,   "Analytical    Gas Detector" },
        { 0x00DF, [jb_mphf_series]        ,   "Analytical    Fire Detector" },
        { 0x0092, [him1008]               },
        { 0x0093, [cxt]                   },
        { 0x0094, [cjt]                   },
        { 0x0095, [hbm_165_h]             },
        { 0x0096, [hbm_167_h]             },
        { 0x0097, [wbm_165_h]             },
        { 0x0098, [obm_165_h]             },
        { 0x0099, [obm_167_h]             },
        { 0x009A, [mbm_165_h]             },
        { 0x009B, [mbm_167_h]             },
        { 0x009C, [mark_series]           },
        { 0x009D, [tr]                    },
        { 0x00A0, [position_xmitter]      },
        { 0x00CE, [valve_monitor_4310]    },
        { 0x00EB, [valve_controller_4350] ,   "Valve         Controller" },
        { 0x00A1, [hrt1]                  ,   "Flow          Totalizer - Rate Indicator" },
        { 0x00F1, [freq_ma]               },
        { 0x00A2, [dn2510_smartmesh]      },
        { 0x00A3, [m2510_smartmesh]       },
        { 0x00A4, [pm2510_smartmesh]      },
        { 0x00A5, [vfm_4097]              },
        { 0x00A6, [ifc_031]               },
        { 0x00A7, [ifc_021]               },
        { 0x00A8, [smartpro_cond_8967]    },
        { 0x00A9, [smartpro_ph_8966]      },
        { 0x00AA, [smartpro_do_8968]      },
        { 0x00AB, [am_2000]               },
        { 0x00AC, [mactek_wa]             },
        { 0x00AD, [csi_9420]              },
        { 0x00AE, [kms_2]                 },
        { 0x00AF, [mwt_3905]              },
        { 0x00B0, [uwt_1000]              },
        { 0x00B1, [cwt_9020]              },
        { 0x00B2, [a_1000_h]              },
        { 0x00B3, [ncs_pt105_ii]          },
        { 0x00CF, [ncs_pt105ii_sp]        },
        { 0x00D0, [ncs_tt105]             },
        { 0x00B6, [ty_tds_p]              },
        { 0x00B7, [ty_trans_f]            },
        { 0x00B8, [ty_trans_l]            },
        { 0x00B9, [ty_trans_ps]           },
        { 0x00BA, [ty_trans_a]            },
        { 0x00BB, [pmh]                   },
        { 0x00BD, [fluxus]                },
        { 0x00BE, [mrg_10a]               },
        { 0x00BF, [mrf_10]                },
        { 0x00C0, [ultramate_136_ult]     },
        { 0x00D8, [microguide_132_tdr]    },
        { 0x00D9, [micromate_138_plr]     },
        { 0x00C1, [flow_control_system]   },
        { 0x00C2, [axiom]                 ,   "Valve         Monitor" },
        { 0x00C3, [eumag]                 },
        { 0x00C5, [mtrt]                  },
        { 0x00C4, [ba47x_67x_series]      ,   "Temperature" },
        { 0x00C6, [cap_30xx]              },
        { 0x00C7, [nemesis_1000]          },
        { 0x00CA, [elemer_air_10h]        },
        { 0x00CB, [elemer_air_20h]        },
        { 0x00CC, [elemer_air_30h]        },
        { 0x00E7, [elemer_sapphire_22]    },
        { 0x00E8, [elemer_100]            },
        { 0x00CD, [frankenstein]          },
        { 0x00D1, [wideplus_ba]           },
        { 0x00D2, [wideplus_a]            },
        { 0x00D3, [oxitec_5000]           },
        { 0x00D4, [comtec_6000]           },
        { 0x00D5, [ihp]                   },
        { 0x00D6, [idp]                   },
        { 0x00D7, [mft_b_series]          },
        { 0x00DB, [sgh350]                },
        { 0x00DC, [irmax]                 },
        { 0x00DD, [ir_display]            },
        { 0x00DE, [tixo3]                 },
        { 0x00E0, [master_touch]          },
        { 0x00E1, [dlt9000]               },
        { 0x00E2, [ffg_p_level]           },
        { 0x00E3, [swh_5700_steam]        },
        { 0x00E4, [rwh_5500_relief]       },
        { 0x00E5, [twh_5100_temp]         },
        { 0x00E6, [n7]                    },
        { 0x00E9, [a2_4_20ma_hrt]         },
        { 0x00EA, [f0_series]             }
    }
}

/*********************************************************************************
 * HCF Device Type Codes
 */
VARIABLE HCF_model_code    /* 0x00F9 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0080, [wirelesshart_net_mgr] },
        { 0x0081, [wirelesshart_gateway] },
        { 0x0082, [generic]              ,   "Interoperable" },
        { 0x0083, [sdc625]               },
        { 0x0084, [analys]               },
        { 0xF980, [wirelesshart_net_mgr] },
        { 0xF981, [wirelesshart_gateway] },
        { 0xF982, [generic]              ,   "Interoperable" },
        { 0xF983, [sdc625]               },
        { 0xF984, [analys]               }
    }
}

/*********************************************************************************
 * ExSaf Device Type Codes
 */
VARIABLE ExSaf_model_code    /* 0x6000 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE080, [esd3000]  },
        { 0xE0EC, [est3051t] },
        { 0xE0ED, [est3051s] }
    }
}

/*********************************************************************************
 * SEOJIN INSTECH Device Type Codes
 */
VARIABLE SEOJIN_INSTECH_model_code    /* 0x6001 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE082, [sdt420] },
        { 0xE0B4, [stf]    ,   "Flow          Thermal" },
        { 0xE0B5, [smf]    ,   "Flow          Electromagnetic" }
    }
}

/*********************************************************************************
 * TASI FLOW Device Type Codes
 */
VARIABLE TASI_FLOW_model_code    /* 0x6002 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE083, [rt_ex15] }
    }
}

/*********************************************************************************
 * Daehan Control Device Type Codes
 */
VARIABLE Daehan_Control_model_code    /* 0x6003 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE084, [ss] ,   "Valve         Positioner" }
    }
}

/*********************************************************************************
 * APM Device Type Codes
 */
VARIABLE APM_model_code    /* 0x6004 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE085, [apm_3dlevelscanner_m] },
        { 0xE086, [apm_3dlevelscanner_s] },
        { 0xE087, [apm_3dlevelscanner_l] }
    }
}

/*********************************************************************************
 * ORANGE INST UK Device Type Codes
 */
VARIABLE ORANGE_INST_UK_model_code    /* 0x6005 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE088, [ex200h_positioner] ,   "Valve         Positioner/Electro-hydraulic" },
        { 0xE089, [is200h_positioner] }
    }
}

/*********************************************************************************
 * BARTEC Device Type Codes
 */
VARIABLE BARTEC_model_code    /* 0x6006 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08A, [r3x] }
    }
}

/*********************************************************************************
 * Detcon Device Type Codes
 */
VARIABLE Detcon_model_code    /* 0x6007 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08B, [detcon_700_bridge] }
    }
}

/*********************************************************************************
 * MSA Device Type Codes
 */
VARIABLE MSA_model_code    /* 0x6008 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08C, [ultima_xl_xt] ,   "Analytical    Gas Detector" },
        { 0xE09F, [ultimaxeh]    ,   "Analytical    Gas Detector" },
        { 0xE0BC, [flamegard]    },
        { 0xE0F2, [safeye]       },
        { 0xE0F3, [primax]       }
    }
}

/*********************************************************************************
 * METROVAL Device Type Codes
 */
VARIABLE METROVAL_model_code    /* 0x6009 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08D, [cmm_01_mass_flow] ,   "Flow          Coriolis Mass" },
        { 0xE0C8, [cvm_01]           },
        { 0xE0C9, [tdm_01]           }
    }
}

/*********************************************************************************
 * Etalon Rus Device Type Codes
 */
VARIABLE Etalon_Rus_model_code    /* 0x600A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE081, [sensor_don] }
    }
}

/*********************************************************************************
 * JOGLER Device Type Codes
 */
VARIABLE JOGLER_model_code    /* 0x600B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08E, [jlt_6000] }
    }
}

/*********************************************************************************
 * KSB Device Type Codes
 */
VARIABLE KSB_model_code    /* 0x600C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE08F, [smartronic_ma] }
    }
}

/*********************************************************************************
 * Richter CT Device Type Codes
 */
VARIABLE Richter_CT_model_code    /* 0x600D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE090, [cms_standard] }
    }
}

/*********************************************************************************
 * NET SAFETY Device Type Codes
 */
VARIABLE NET_SAFETY_model_code    /* 0x600E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE091, [millennium_2]       },
        { 0xE09E, [millennium_2_basic] ,   "Analytical    Gas Detector" },
        { 0xE0DF, [jb_mphf_series]     ,   "Analytical    Fire Detector" }
    }
}

/*********************************************************************************
 * SECanada Device Type Codes
 */
VARIABLE SECanada_model_code    /* 0x600F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE092, [him1008] }
    }
}

/*********************************************************************************
 * SUPCON Device Type Codes
 */
VARIABLE SUPCON_model_code    /* 0x6010 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE093, [cxt] },
        { 0xE094, [cjt] }
    }
}

/*********************************************************************************
 * DKK - TOA Device Type Codes
 */
VARIABLE DKK_TOA_model_code    /* 0x6011 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE095, [hbm_165_h] },
        { 0xE096, [hbm_167_h] },
        { 0xE097, [wbm_165_h] },
        { 0xE098, [obm_165_h] },
        { 0xE099, [obm_167_h] },
        { 0xE09A, [mbm_165_h] },
        { 0xE09B, [mbm_167_h] }
    }
}

/*********************************************************************************
 * Dwyer Instruments Device Type Codes
 */
VARIABLE Dwyer_Instruments_model_code    /* 0x6012 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE09C, [mark_series] }
    }
}

/*********************************************************************************
 * FineTek Device Type Codes
 */
VARIABLE FineTek_model_code    /* 0x6013 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE09D, [tr] }
    }
}

/*********************************************************************************
 * TopWorx Inc. Device Type Codes
 */
VARIABLE TopWorx_model_code    /* 0x6014 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0A0, [position_xmitter]      },
        { 0xE0CE, [valve_monitor_4310]    },
        { 0xE0EB, [valve_controller_4350] ,   "Valve         Controller" }
    }
}

/*********************************************************************************
 * HOFFER FLOW CNTRLS Device Type Codes
 */
VARIABLE HOFFER_FLOW_CNTRLS_model_code    /* 0x6015 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0A1, [hrt1]    ,   "Flow          Totalizer - Rate Indicator" },
        { 0xE0F1, [freq_ma] }
    }
}

/*********************************************************************************
 * DUST NETWORKS Device Type Codes
 */
VARIABLE DUST_NETWORKS_model_code    /* 0x6016 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0A2, [dn2510_smartmesh] },
        { 0xE0A3, [m2510_smartmesh]  },
        { 0xE0A4, [pm2510_smartmesh] }
    }
}

/*********************************************************************************
 * Forbes Marshall Device Type Codes
 */
VARIABLE Forbes_Marshall_model_code    /* 0x6017 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0A5, [vfm_4097]           },
        { 0xE0A6, [ifc_031]            },
        { 0xE0A7, [ifc_021]            },
        { 0xE0A8, [smartpro_cond_8967] },
        { 0xE0A9, [smartpro_ph_8966]   },
        { 0xE0AA, [smartpro_do_8968]   }
    }
}

/*********************************************************************************
 * All Measures, Ltd. Device Type Codes
 */
VARIABLE All_Measures_Ltd_model_code    /* 0x6018 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0AB, [am_2000] }
    }
}

/*********************************************************************************
 * MACTek Device Type Codes
 */
VARIABLE MACTek_model_code    /* 0x6019 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0AC, [mactek_wa] }
    }
}

/*********************************************************************************
 * CSI Device Type Codes
 */
VARIABLE CSI_model_code    /* 0x601A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0AD, [csi_9420] }
    }
}

/*********************************************************************************
 * TC Fluid Control Device Type Codes
 */
VARIABLE TC_Fluid_Control_model_code    /* 0x601B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0AE, [kms_2] }
    }
}

/*********************************************************************************
 * Rohrback Cosasco Device Type Codes
 */
VARIABLE Rohrback_Cosasco_model_code    /* 0x601C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0AF, [mwt_3905] },
        { 0xE0B0, [uwt_1000] },
        { 0xE0B1, [cwt_9020] }
    }
}

/*********************************************************************************
 * AirSprite Device Type Codes
 */
VARIABLE AirSprite_model_code    /* 0x601D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0B2, [a_1000_h] }
    }
}

/*********************************************************************************
 * Microcyber Inc. Device Type Codes
 */
VARIABLE Microcyber_model_code    /* 0x601E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0B3, [ncs_pt105_ii]   },
        { 0xE0CF, [ncs_pt105ii_sp] },
        { 0xE0D0, [ncs_tt105]      }
    }
}

/*********************************************************************************
 * TIG Device Type Codes
 */
VARIABLE TIG_model_code    /* 0x601F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0B6, [ty_tds_p]    },
        { 0xE0B7, [ty_trans_f]  },
        { 0xE0B8, [ty_trans_l]  },
        { 0xE0B9, [ty_trans_ps] },
        { 0xE0BA, [ty_trans_a]  }
    }
}

/*********************************************************************************
 * ifm prover Gmbh Device Type Codes
 */
VARIABLE ifm_prover_Gmbh_model_code    /* 0x6020 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0BB, [pmh] }
    }
}

/*********************************************************************************
 * FLEXIM Device Type Codes
 */
VARIABLE FLEXIM_model_code    /* 0x6021 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0BD, [fluxus] }
    }
}

/*********************************************************************************
 * TOKIMEC.INC Device Type Codes
 */
VARIABLE TOKIMEC_model_code    /* 0x6022 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0BE, [mrg_10a] },
        { 0xE0BF, [mrf_10]  }
    }
}

/*********************************************************************************
 * SBEM Device Type Codes
 */
VARIABLE SBEM_model_code    /* 0x6023 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C0, [ultramate_136_ult]  },
        { 0xE0D8, [microguide_132_tdr] },
        { 0xE0D9, [micromate_138_plr]  }
    }
}

/*********************************************************************************
 * SkoFlo Industries, Inc. Device Type Codes
 */
VARIABLE SkoFlo_Industries_model_code    /* 0x6024 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C1, [flow_control_system] }
    }
}

/*********************************************************************************
 * StoneL Corporation Device Type Codes
 */
VARIABLE StoneL_Corporation_model_code    /* 0x6025 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C2, [axiom] ,   "Valve         Monitor" }
    }
}

/*********************************************************************************
 * EUREKA FLOW Device Type Codes
 */
VARIABLE EUREKA_FLOW_model_code    /* 0x6026 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C3, [eumag] },
        { 0xE0C5, [mtrt]  }
    }
}

/*********************************************************************************
 * BEKA associates Device Type Codes
 */
VARIABLE BEKA_associates_model_code    /* 0x6027 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C4, [ba47x_67x_series] ,   "Temperature" }
    }
}

/*********************************************************************************
 * CAPSTAR AUTOMATION Device Type Codes
 */
VARIABLE CAPSTAR_AUTOMATION_model_code    /* 0x6028 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C6, [cap_30xx] }
    }
}

/*********************************************************************************
 * Pulsar Device Type Codes
 */
VARIABLE Pulsar_model_code    /* 0x6029 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0C7, [nemesis_1000] }
    }
}

/*********************************************************************************
 * Elemer Device Type Codes
 */
VARIABLE Elemer_model_code    /* 0x602A */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0CA, [elemer_air_10h]     },
        { 0xE0CB, [elemer_air_20h]     },
        { 0xE0CC, [elemer_air_30h]     },
        { 0xE0E7, [elemer_sapphire_22] },
        { 0xE0E8, [elemer_100]         }
    }
}

/*********************************************************************************
 * Soft Tech Group Device Type Codes
 */
VARIABLE Soft_Tech_Group_model_code    /* 0x602B */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0CD, [frankenstein] }
    }
}

/*********************************************************************************
 * FUJIAN WIDEPLUS PRECISION INSTRUMENTS CO., LTD Device Type Codes
 */
VARIABLE FUJIAN_WIDEPLUS_PRECISION_INSTR_model_code    /* 0x602C */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0D1, [wideplus_ba] },
        { 0xE0D2, [wideplus_a]  }
    }
}

/*********************************************************************************
 * ENOTEC GmbH Device Type Codes
 */
VARIABLE ENOTEC_GmbH_model_code    /* 0x602D */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0D3, [oxitec_5000] },
        { 0xE0D4, [comtec_6000] }
    }
}

/*********************************************************************************
 * Val Controls A/S Device Type Codes
 */
VARIABLE Val_Controls_AS_model_code    /* 0x602E */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0D5, [ihp] },
        { 0xE0D6, [idp] }
    }
}

/*********************************************************************************
 * Kurz Instruments Device Type Codes
 */
VARIABLE Kurz_Instruments_model_code    /* 0x602F */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0D7, [mft_b_series] }
    }
}

/*********************************************************************************
 * E-Senza Technologies Device Type Codes
 */
VARIABLE E_Senza_Technologies_model_code    /* 0x6030 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0DB, [sgh350] }
    }
}

/*********************************************************************************
 * Crowcon Device Type Codes
 */
VARIABLE Crowcon_model_code    /* 0x6031 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0DC, [irmax]      },
        { 0xE0DD, [ir_display] }
    }
}

/*********************************************************************************
 * GEORGIN Device Type Codes
 */
VARIABLE GEORGIN_model_code    /* 0x6032 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0DE, [tixo3] }
    }
}

/*********************************************************************************
 * Eldridge Products Device Type Codes
 */
VARIABLE Eldridge_Products_model_code    /* 0x6033 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E0, [master_touch] }
    }
}

/*********************************************************************************
 * DDTOP Device Type Codes
 */
VARIABLE DDTOP_model_code    /* 0x6034 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E1, [dlt9000] }
    }
}

/*********************************************************************************
 * KSR Kuebler Device Type Codes
 */
VARIABLE KSR_Kuebler_model_code    /* 0x6035 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E2, [ffg_p_level] }
    }
}

/*********************************************************************************
 * Armstrong Intl Device Type Codes
 */
VARIABLE Armstrong_Intl_model_code    /* 0x6036 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E3, [swh_5700_steam]  },
        { 0xE0E4, [rwh_5500_relief] },
        { 0xE0E5, [twh_5100_temp]   }
    }
}

/*********************************************************************************
 * Hitachi High-Tech Device Type Codes
 */
VARIABLE Hitachi_High_Tech_model_code    /* 0x6037 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E6, [n7] }
    }
}

/*********************************************************************************
 * AMFLOW Device Type Codes
 */
VARIABLE AMFLOW_model_code    /* 0x6038 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0E9, [a2_4_20ma_hrt] }
    }
}

/*********************************************************************************
 * Fluidwell Device Type Codes
 */
VARIABLE Fluidwell_model_code    /* 0x6039 */
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0xE0EA, [f0_series] }
    }
}

/*********************************************************************************
 * Table 1. Expanded Device Type Codes
 */
VARIABLE device_type_code
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0304,  Ametek_model_code(0x0304)                         }, // 0x0003

        { 0x0A01,  Brooks_Instrument_model_code(0x0A01)              }, // 0x000A
        { 0x0A02,  Brooks_Instrument_model_code(0x0A02)              }, // 0x000A
        { 0x0A03,  Brooks_Instrument_model_code(0x0A03)              }, // 0x000A
        { 0x0A04,  Brooks_Instrument_model_code(0x0A04)              }, // 0x000A

        { 0x0D14,  Daniel_Industries_model_code(0x0D14)              }, // 0x000D
        { 0x0D28,  Daniel_Industries_model_code(0x0D28)              }, // 0x000D

        { 0x0E01,  Delta_model_code(0x0E01)                          }, // 0x000E

        { 0x1103,  Endress_Hauser_model_code(0x1103)                 }, // 0x0011
        { 0x1104,  Endress_Hauser_model_code(0x1104)                 }, // 0x0011
        { 0x1105,  Endress_Hauser_model_code(0x1105)                 }, // 0x0011
        { 0x1106,  Endress_Hauser_model_code(0x1106)                 }, // 0x0011
        { 0x1107,  Endress_Hauser_model_code(0x1107)                 }, // 0x0011
        { 0x1108,  Endress_Hauser_model_code(0x1108)                 }, // 0x0011
        { 0x1109,  Endress_Hauser_model_code(0x1109)                 }, // 0x0011
        { 0x110A,  Endress_Hauser_model_code(0x110A)                 }, // 0x0011
        { 0x110B,  Endress_Hauser_model_code(0x110B)                 }, // 0x0011
        { 0x110C,  Endress_Hauser_model_code(0x110C)                 }, // 0x0011
        { 0x110D,  Endress_Hauser_model_code(0x110D)                 }, // 0x0011
        { 0x110E,  Endress_Hauser_model_code(0x110E)                 }, // 0x0011
        { 0x110F,  Endress_Hauser_model_code(0x110F)                 }, // 0x0011
        { 0x1110,  Endress_Hauser_model_code(0x1110)                 }, // 0x0011
        { 0x1111,  Endress_Hauser_model_code(0x1111)                 }, // 0x0011
        { 0x1112,  Endress_Hauser_model_code(0x1112)                 }, // 0x0011
        { 0x1113,  Endress_Hauser_model_code(0x1113)                 }, // 0x0011
        { 0x1114,  Endress_Hauser_model_code(0x1114)                 }, // 0x0011
        { 0x1117,  Endress_Hauser_model_code(0x1117)                 }, // 0x0011
        { 0x1118,  Endress_Hauser_model_code(0x1118)                 }, // 0x0011
        { 0x1119,  Endress_Hauser_model_code(0x1119)                 }, // 0x0011
        { 0x111A,  Endress_Hauser_model_code(0x111A)                 }, // 0x0011
        { 0x111B,  Endress_Hauser_model_code(0x111B)                 }, // 0x0011
        { 0x111D,  Endress_Hauser_model_code(0x111D)                 }, // 0x0011
        { 0x111E,  Endress_Hauser_model_code(0x111E)                 }, // 0x0011
        { 0x111F,  Endress_Hauser_model_code(0x111F)                 }, // 0x0011
        { 0x1120,  Endress_Hauser_model_code(0x1120)                 }, // 0x0011
        { 0x1121,  Endress_Hauser_model_code(0x1121)                 }, // 0x0011
        { 0x1123,  Endress_Hauser_model_code(0x1123)                 }, // 0x0011
        { 0x1124,  Endress_Hauser_model_code(0x1124)                 }, // 0x0011
        { 0x1132,  Endress_Hauser_model_code(0x1132)                 }, // 0x0011
        { 0x1133,  Endress_Hauser_model_code(0x1133)                 }, // 0x0011
        { 0x1134,  Endress_Hauser_model_code(0x1134)                 }, // 0x0011
        { 0x1135,  Endress_Hauser_model_code(0x1135)                 }, // 0x0011
        { 0x1136,  Endress_Hauser_model_code(0x1136)                 }, // 0x0011
        { 0x1137,  Endress_Hauser_model_code(0x1137)                 }, // 0x0011
        { 0x1139,  Endress_Hauser_model_code(0x1139)                 }, // 0x0011
        { 0x1140,  Endress_Hauser_model_code(0x1140)                 }, // 0x0011
        { 0x1141,  Endress_Hauser_model_code(0x1141)                 }, // 0x0011
        { 0x1142,  Endress_Hauser_model_code(0x1142)                 }, // 0x0011
        { 0x1143,  Endress_Hauser_model_code(0x1143)                 }, // 0x0011
        { 0x1144,  Endress_Hauser_model_code(0x1144)                 }, // 0x0011
        { 0x1145,  Endress_Hauser_model_code(0x1145)                 }, // 0x0011
        { 0x1146,  Endress_Hauser_model_code(0x1146)                 }, // 0x0011
        { 0x1150,  Endress_Hauser_model_code(0x1150)                 }, // 0x0011
        { 0x1151,  Endress_Hauser_model_code(0x1151)                 }, // 0x0011
        { 0x1152,  Endress_Hauser_model_code(0x1152)                 }, // 0x0011
        { 0x1153,  Endress_Hauser_model_code(0x1153)                 }, // 0x0011
        { 0x1156,  Endress_Hauser_model_code(0x1156)                 }, // 0x0011
        { 0x1157,  Endress_Hauser_model_code(0x1157)                 }, // 0x0011
        { 0x1158,  Endress_Hauser_model_code(0x1158)                 }, // 0x0011
        { 0x1159,  Endress_Hauser_model_code(0x1159)                 }, // 0x0011
        { 0x1161,  Endress_Hauser_model_code(0x1161)                 }, // 0x0011
        { 0x1162,  Endress_Hauser_model_code(0x1162)                 }, // 0x0011
        { 0x1164,  Endress_Hauser_model_code(0x1164)                 }, // 0x0011
        { 0x1165,  Endress_Hauser_model_code(0x1165)                 }, // 0x0011
        { 0x1178,  Endress_Hauser_model_code(0x1178)                 }, // 0x0011
        { 0x1179,  Endress_Hauser_model_code(0x1179)                 }, // 0x0011
        { 0x117C,  Endress_Hauser_model_code(0x117C)                 }, // 0x0011
        { 0x118C,  Endress_Hauser_model_code(0x118C)                 }, // 0x0011
        { 0x118D,  Endress_Hauser_model_code(0x118D)                 }, // 0x0011
        { 0x118E,  Endress_Hauser_model_code(0x118E)                 }, // 0x0011
        { 0x11B5,  Endress_Hauser_model_code(0x11B5)                 }, // 0x0011
        { 0x11B6,  Endress_Hauser_model_code(0x11B6)                 }, // 0x0011
        { 0x11C8,  Endress_Hauser_model_code(0x11C8)                 }, // 0x0011
        { 0x11C9,  Endress_Hauser_model_code(0x11C9)                 }, // 0x0011
        { 0x11CA,  Endress_Hauser_model_code(0x11CA)                 }, // 0x0011
        { 0x11CB,  Endress_Hauser_model_code(0x11CB)                 }, // 0x0011

        { 0x1207,  Fischer_Porter_model_code(0x1207)                 }, // 0x0012
        { 0x1208,  Fischer_Porter_model_code(0x1208)                 }, // 0x0012
        { 0x120E,  Fischer_Porter_model_code(0x120E)                 }, // 0x0012
        { 0x120F,  Fischer_Porter_model_code(0x120F)                 }, // 0x0012
        { 0x1219,  Fischer_Porter_model_code(0x1219)                 }, // 0x0012
        { 0x121A,  Fischer_Porter_model_code(0x121A)                 }, // 0x0012
        { 0x1242,  Fischer_Porter_model_code(0x1242)                 }, // 0x0012
        { 0x1250,  Fischer_Porter_model_code(0x1250)                 }, // 0x0012
        { 0x1251,  Fischer_Porter_model_code(0x1251)                 }, // 0x0012
        { 0x1252,  Fischer_Porter_model_code(0x1252)                 }, // 0x0012
        { 0x1253,  Fischer_Porter_model_code(0x1253)                 }, // 0x0012
        { 0x1254,  Fischer_Porter_model_code(0x1254)                 }, // 0x0012
        { 0x1255,  Fischer_Porter_model_code(0x1255)                 }, // 0x0012
        { 0x1256,  Fischer_Porter_model_code(0x1256)                 }, // 0x0012
        { 0x1257,  Fischer_Porter_model_code(0x1257)                 }, // 0x0012
        { 0x1258,  Fischer_Porter_model_code(0x1258)                 }, // 0x0012
        { 0x1259,  Fischer_Porter_model_code(0x1259)                 }, // 0x0012

        { 0x1303,  Fisher_Controls_model_code(0x1303)                }, // 0x0013
        { 0x1305,  Fisher_Controls_model_code(0x1305)                }, // 0x0013
        { 0x1308,  Fisher_Controls_model_code(0x1308)                }, // 0x0013

        { 0x1401,  Foxboro_model_code(0x1401)                        }, // 0x0014
        { 0x1402,  Foxboro_model_code(0x1402)                        }, // 0x0014
        { 0x1403,  Foxboro_model_code(0x1403)                        }, // 0x0014
        { 0x1404,  Foxboro_model_code(0x1404)                        }, // 0x0014
        { 0x1405,  Foxboro_model_code(0x1405)                        }, // 0x0014
        { 0x141D,  Foxboro_model_code(0x141D)                        }, // 0x0014
        { 0x141E,  Foxboro_model_code(0x141E)                        }, // 0x0014
        { 0x1428,  Foxboro_model_code(0x1428)                        }, // 0x0014
        { 0x1429,  Foxboro_model_code(0x1429)                        }, // 0x0014
        { 0x142E,  Foxboro_model_code(0x142E)                        }, // 0x0014
        { 0x142F,  Foxboro_model_code(0x142F)                        }, // 0x0014
        { 0x1430,  Foxboro_model_code(0x1430)                        }, // 0x0014
        { 0x1433,  Foxboro_model_code(0x1433)                        }, // 0x0014
        { 0x1434,  Foxboro_model_code(0x1434)                        }, // 0x0014
        { 0x1435,  Foxboro_model_code(0x1435)                        }, // 0x0014
        { 0x1436,  Foxboro_model_code(0x1436)                        }, // 0x0014
        { 0x1438,  Foxboro_model_code(0x1438)                        }, // 0x0014
        { 0x147D,  Foxboro_model_code(0x147D)                        }, // 0x0014

        { 0x1501,  Fuji_model_code(0x1501)                           }, // 0x0015
        { 0x1502,  Fuji_model_code(0x1502)                           }, // 0x0015
        { 0x1581,  Fuji_model_code(0x1581)                           }, // 0x0015

        { 0x1603,  Hartmann_Braun_model_code(0x1603)                 }, // 0x0016
        { 0x1604,  Hartmann_Braun_model_code(0x1604)                 }, // 0x0016
        { 0x1605,  Hartmann_Braun_model_code(0x1605)                 }, // 0x0016
        { 0x1606,  Hartmann_Braun_model_code(0x1606)                 }, // 0x0016
        { 0x1608,  Hartmann_Braun_model_code(0x1608)                 }, // 0x0016
        { 0x1640,  Hartmann_Braun_model_code(0x1640)                 }, // 0x0016
        { 0x1641,  Hartmann_Braun_model_code(0x1641)                 }, // 0x0016
        { 0x1685,  Hartmann_Braun_model_code(0x1685)                 }, // 0x0016
        { 0x1687,  Hartmann_Braun_model_code(0x1687)                 }, // 0x0016

        { 0x1701,  Honeywell_model_code(0x1701)                      }, // 0x0017
        { 0x1702,  Honeywell_model_code(0x1702)                      }, // 0x0017
        { 0x1703,  Honeywell_model_code(0x1703)                      }, // 0x0017
        { 0x1704,  Honeywell_model_code(0x1704)                      }, // 0x0017
        { 0x1705,  Honeywell_model_code(0x1705)                      }, // 0x0017
        { 0x1706,  Honeywell_model_code(0x1706)                      }, // 0x0017
        { 0x1707,  Honeywell_model_code(0x1707)                      }, // 0x0017
        { 0x1708,  Honeywell_model_code(0x1708)                      }, // 0x0017
        { 0x1709,  Honeywell_model_code(0x1709)                      }, // 0x0017
        { 0x170A,  Honeywell_model_code(0x170A)                      }, // 0x0017
        { 0x1750,  Honeywell_model_code(0x1750)                      }, // 0x0017

        { 0x1908,  kayray_model_code(0x1908)                         }, // 0x0019
        { 0x1909,  kayray_model_code(0x1909)                         }, // 0x0019
        { 0x190A,  kayray_model_code(0x190A)                         }, // 0x0019
        { 0x190B,  kayray_model_code(0x190B)                         }, // 0x0019
        { 0x190F,  kayray_model_code(0x190F)                         }, // 0x0019

        { 0x1A01,  ABB_model_code(0x1A01)                            }, // 0x001A
        { 0x1A02,  ABB_model_code(0x1A02)                            }, // 0x001A
        { 0x1A03,  ABB_model_code(0x1A03)                            }, // 0x001A
        { 0x1A04,  ABB_model_code(0x1A04)                            }, // 0x001A
        { 0x1A05,  ABB_model_code(0x1A05)                            }, // 0x001A
        { 0x1A07,  ABB_model_code(0x1A07)                            }, // 0x001A
        { 0x1A08,  ABB_model_code(0x1A08)                            }, // 0x001A
        { 0x1A09,  ABB_model_code(0x1A09)                            }, // 0x001A
        { 0x1A0A,  ABB_model_code(0x1A0A)                            }, // 0x001A
        { 0x1A0B,  ABB_model_code(0x1A0B)                            }, // 0x001A
        { 0x1A0C,  ABB_model_code(0x1A0C)                            }, // 0x001A
        { 0x1A0D,  ABB_model_code(0x1A0D)                            }, // 0x001A
        { 0x1A0F,  ABB_model_code(0x1A0F)                            }, // 0x001A
        { 0x1A10,  ABB_model_code(0x1A10)                            }, // 0x001A
        { 0x1A18,  ABB_model_code(0x1A18)                            }, // 0x001A
        { 0x1A1A,  ABB_model_code(0x1A1A)                            }, // 0x001A
        { 0x1A1B,  ABB_model_code(0x1A1B)                            }, // 0x001A
        { 0x1A1C,  ABB_model_code(0x1A1C)                            }, // 0x001A
        { 0x1A1D,  ABB_model_code(0x1A1D)                            }, // 0x001A
        { 0x1A1E,  ABB_model_code(0x1A1E)                            }, // 0x001A
        { 0x1A1F,  ABB_model_code(0x1A1F)                            }, // 0x001A
        { 0x1A21,  ABB_model_code(0x1A21)                            }, // 0x001A
        { 0x1A23,  ABB_model_code(0x1A23)                            }, // 0x001A
        { 0x1A24,  ABB_model_code(0x1A24)                            }, // 0x001A
        { 0x1A25,  ABB_model_code(0x1A25)                            }, // 0x001A
        { 0x1A26,  ABB_model_code(0x1A26)                            }, // 0x001A
        { 0x1A27,  ABB_model_code(0x1A27)                            }, // 0x001A
        { 0x1A29,  ABB_model_code(0x1A29)                            }, // 0x001A
        { 0x1A2A,  ABB_model_code(0x1A2A)                            }, // 0x001A
        { 0x1A30,  ABB_model_code(0x1A30)                            }, // 0x001A
        { 0x1A34,  ABB_model_code(0x1A34)                            }, // 0x001A
        { 0x1A89,  ABB_model_code(0x1A89)                            }, // 0x001A
        { 0x1A8A,  ABB_model_code(0x1A8A)                            }, // 0x001A
        { 0x1A8C,  ABB_model_code(0x1A8C)                            }, // 0x001A
        { 0x1A8D,  ABB_model_code(0x1A8D)                            }, // 0x001A
        { 0x1A8E,  ABB_model_code(0x1A8E)                            }, // 0x001A
        { 0x1A99,  ABB_model_code(0x1A99)                            }, // 0x001A

        { 0x1D01,  M_System_Co_model_code(0x1D01)                    }, // 0x001D
        { 0x1D02,  M_System_Co_model_code(0x1D02)                    }, // 0x001D
        { 0x1D03,  M_System_Co_model_code(0x1D03)                    }, // 0x001D

        { 0x1F07,  micro_motion_model_code(0x1F07)                   }, // 0x001F
        { 0x1F14,  micro_motion_model_code(0x1F14)                   }, // 0x001F
        { 0x1F15,  micro_motion_model_code(0x1F15)                   }, // 0x001F
        { 0x1F1E,  micro_motion_model_code(0x1F1E)                   }, // 0x001F
        { 0x1F24,  micro_motion_model_code(0x1F24)                   }, // 0x001F
        { 0x1F25,  micro_motion_model_code(0x1F25)                   }, // 0x001F
        { 0x1F26,  micro_motion_model_code(0x1F26)                   }, // 0x001F
        { 0x1F27,  micro_motion_model_code(0x1F27)                   }, // 0x001F
        { 0x1F29,  micro_motion_model_code(0x1F29)                   }, // 0x001F
        { 0x1F2A,  micro_motion_model_code(0x1F2A)                   }, // 0x001F
        { 0x1F34,  micro_motion_model_code(0x1F34)                   }, // 0x001F
        { 0x1F3A,  micro_motion_model_code(0x1F3A)                   }, // 0x001F
        { 0x1F41,  micro_motion_model_code(0x1F41)                   }, // 0x001F

        { 0x2001,  Moore_Industries_model_code(0x2001)               }, // 0x0020
        { 0x2003,  Moore_Industries_model_code(0x2003)               }, // 0x0020
        { 0x2004,  Moore_Industries_model_code(0x2004)               }, // 0x0020
        { 0x2005,  Moore_Industries_model_code(0x2005)               }, // 0x0020
        { 0x2006,  Moore_Industries_model_code(0x2006)               }, // 0x0020

        { 0x2101,  Moore_Products_model_code(0x2101)                 }, // 0x0021
        { 0x2102,  Moore_Products_model_code(0x2102)                 }, // 0x0021
        { 0x2103,  Moore_Products_model_code(0x2103)                 }, // 0x0021
        { 0x2105,  Moore_Products_model_code(0x2105)                 }, // 0x0021
        { 0x2106,  Moore_Products_model_code(0x2106)                 }, // 0x0021
        { 0x2108,  Moore_Products_model_code(0x2108)                 }, // 0x0021
        { 0x2109,  Moore_Products_model_code(0x2109)                 }, // 0x0021
        { 0x210A,  Moore_Products_model_code(0x210A)                 }, // 0x0021
        { 0x210B,  Moore_Products_model_code(0x210B)                 }, // 0x0021
        { 0x210C,  Moore_Products_model_code(0x210C)                 }, // 0x0021
        { 0x210D,  Moore_Products_model_code(0x210D)                 }, // 0x0021

        { 0x2502,  Ronan_model_code(0x2502)                          }, // 0x0025
        { 0x2503,  Ronan_model_code(0x2503)                          }, // 0x0025
        { 0x2504,  Ronan_model_code(0x2504)                          }, // 0x0025
        { 0x2505,  Ronan_model_code(0x2505)                          }, // 0x0025
        { 0x2506,  Ronan_model_code(0x2506)                          }, // 0x0025

        { 0x2601,  rosemount_model_code(0x2601)                      }, // 0x0026
        { 0x2602,  rosemount_model_code(0x2602)                      }, // 0x0026
        { 0x2603,  rosemount_model_code(0x2603)                      }, // 0x0026
        { 0x2604,  rosemount_model_code(0x2604)                      }, // 0x0026
        { 0x2605,  rosemount_model_code(0x2605)                      }, // 0x0026
        { 0x2606,  rosemount_model_code(0x2606)                      }, // 0x0026
        { 0x260B,  rosemount_model_code(0x260B)                      }, // 0x0026
        { 0x260C,  rosemount_model_code(0x260C)                      }, // 0x0026
        { 0x260D,  rosemount_model_code(0x260D)                      }, // 0x0026
        { 0x260E,  rosemount_model_code(0x260E)                      }, // 0x0026
        { 0x260F,  rosemount_model_code(0x260F)                      }, // 0x0026
        { 0x2610,  rosemount_model_code(0x2610)                      }, // 0x0026
        { 0x2611,  rosemount_model_code(0x2611)                      }, // 0x0026
        { 0x2612,  rosemount_model_code(0x2612)                      }, // 0x0026
        { 0x2613,  rosemount_model_code(0x2613)                      }, // 0x0026
        { 0x2614,  rosemount_model_code(0x2614)                      }, // 0x0026
        { 0x2615,  rosemount_model_code(0x2615)                      }, // 0x0026
        { 0x2616,  rosemount_model_code(0x2616)                      }, // 0x0026
        { 0x2617,  rosemount_model_code(0x2617)                      }, // 0x0026
        { 0x2618,  rosemount_model_code(0x2618)                      }, // 0x0026
        { 0x2619,  rosemount_model_code(0x2619)                      }, // 0x0026
        { 0x261A,  rosemount_model_code(0x261A)                      }, // 0x0026
        { 0x261B,  rosemount_model_code(0x261B)                      }, // 0x0026
        { 0x261C,  rosemount_model_code(0x261C)                      }, // 0x0026
        { 0x261D,  rosemount_model_code(0x261D)                      }, // 0x0026
        { 0x261E,  rosemount_model_code(0x261E)                      }, // 0x0026
        { 0x261F,  rosemount_model_code(0x261F)                      }, // 0x0026
        { 0x2620,  rosemount_model_code(0x2620)                      }, // 0x0026
        { 0x2621,  rosemount_model_code(0x2621)                      }, // 0x0026
        { 0x2622,  rosemount_model_code(0x2622)                      }, // 0x0026
        { 0x2623,  rosemount_model_code(0x2623)                      }, // 0x0026
        { 0x2624,  rosemount_model_code(0x2624)                      }, // 0x0026
        { 0x2625,  rosemount_model_code(0x2625)                      }, // 0x0026
        { 0x2626,  rosemount_model_code(0x2626)                      }, // 0x0026
        { 0x2627,  rosemount_model_code(0x2627)                      }, // 0x0026
        { 0x2628,  rosemount_model_code(0x2628)                      }, // 0x0026
        { 0x2629,  rosemount_model_code(0x2629)                      }, // 0x0026
        { 0x262A,  rosemount_model_code(0x262A)                      }, // 0x0026
        { 0x262D,  rosemount_model_code(0x262D)                      }, // 0x0026
        { 0x262F,  rosemount_model_code(0x262F)                      }, // 0x0026
        { 0x2636,  rosemount_model_code(0x2636)                      }, // 0x0026
        { 0x2637,  rosemount_model_code(0x2637)                      }, // 0x0026
        { 0x2638,  rosemount_model_code(0x2638)                      }, // 0x0026
        { 0x263A,  rosemount_model_code(0x263A)                      }, // 0x0026
        { 0x263B,  rosemount_model_code(0x263B)                      }, // 0x0026
        { 0x263C,  rosemount_model_code(0x263C)                      }, // 0x0026
        { 0x2640,  rosemount_model_code(0x2640)                      }, // 0x0026
        { 0x2641,  rosemount_model_code(0x2641)                      }, // 0x0026
        { 0x2642,  rosemount_model_code(0x2642)                      }, // 0x0026
        { 0x2643,  rosemount_model_code(0x2643)                      }, // 0x0026
        { 0x2644,  rosemount_model_code(0x2644)                      }, // 0x0026
        { 0x2645,  rosemount_model_code(0x2645)                      }, // 0x0026
        { 0x2647,  rosemount_model_code(0x2647)                      }, // 0x0026
        { 0x2649,  rosemount_model_code(0x2649)                      }, // 0x0026
        { 0x264A,  rosemount_model_code(0x264A)                      }, // 0x0026
        { 0x264B,  rosemount_model_code(0x264B)                      }, // 0x0026
        { 0x264E,  rosemount_model_code(0x264E)                      }, // 0x0026
        { 0x2650,  rosemount_model_code(0x2650)                      }, // 0x0026
        { 0x2651,  rosemount_model_code(0x2651)                      }, // 0x0026
        { 0x2655,  rosemount_model_code(0x2655)                      }, // 0x0026
        { 0x2656,  rosemount_model_code(0x2656)                      }, // 0x0026
        { 0x2657,  rosemount_model_code(0x2657)                      }, // 0x0026
        { 0x2680,  rosemount_model_code(0x2680)                      }, // 0x0026

        { 0x2700,  Peek_Measurement_model_code(0x2700)               }, // 0x0027

        { 0x2801,  Actaris_Neptune_model_code(0x2801)                }, // 0x0028

        { 0x2A01,  Siemens_model_code(0x2A01)                        }, // 0x002A
        { 0x2A02,  Siemens_model_code(0x2A02)                        }, // 0x002A
        { 0x2A03,  Siemens_model_code(0x2A03)                        }, // 0x002A
        { 0x2A04,  Siemens_model_code(0x2A04)                        }, // 0x002A
        { 0x2A05,  Siemens_model_code(0x2A05)                        }, // 0x002A
        { 0x2A06,  Siemens_model_code(0x2A06)                        }, // 0x002A
        { 0x2A07,  Siemens_model_code(0x2A07)                        }, // 0x002A
        { 0x2A0A,  Siemens_model_code(0x2A0A)                        }, // 0x002A
        { 0x2A0B,  Siemens_model_code(0x2A0B)                        }, // 0x002A
        { 0x2A0C,  Siemens_model_code(0x2A0C)                        }, // 0x002A
        { 0x2A0D,  Siemens_model_code(0x2A0D)                        }, // 0x002A
        { 0x2A0F,  Siemens_model_code(0x2A0F)                        }, // 0x002A
        { 0x2A10,  Siemens_model_code(0x2A10)                        }, // 0x002A
        { 0x2A12,  Siemens_model_code(0x2A12)                        }, // 0x002A
        { 0x2A13,  Siemens_model_code(0x2A13)                        }, // 0x002A
        { 0x2A15,  Siemens_model_code(0x2A15)                        }, // 0x002A
        { 0x2A16,  Siemens_model_code(0x2A16)                        }, // 0x002A
        { 0x2A17,  Siemens_model_code(0x2A17)                        }, // 0x002A
        { 0x2A18,  Siemens_model_code(0x2A18)                        }, // 0x002A
        { 0x2A19,  Siemens_model_code(0x2A19)                        }, // 0x002A
        { 0x2A1A,  Siemens_model_code(0x2A1A)                        }, // 0x002A
        { 0x2A1D,  Siemens_model_code(0x2A1D)                        }, // 0x002A
        { 0x2A1F,  Siemens_model_code(0x2A1F)                        }, // 0x002A

        { 0x2C02,  Toshiba_model_code(0x2C02)                        }, // 0x002C
        { 0x2C03,  Toshiba_model_code(0x2C03)                        }, // 0x002C
        { 0x2C04,  Toshiba_model_code(0x2C04)                        }, // 0x002C
        { 0x2C05,  Toshiba_model_code(0x2C05)                        }, // 0x002C
        { 0x2C06,  Toshiba_model_code(0x2C06)                        }, // 0x002C
        { 0x2C07,  Toshiba_model_code(0x2C07)                        }, // 0x002C
        { 0x2C08,  Toshiba_model_code(0x2C08)                        }, // 0x002C
        { 0x2C09,  Toshiba_model_code(0x2C09)                        }, // 0x002C
        { 0x2C0A,  Toshiba_model_code(0x2C0A)                        }, // 0x002C

        { 0x2E06,  rosemount_analytical_model_code(0x2E06)           }, // 0x002E
        { 0x2E07,  rosemount_analytical_model_code(0x2E07)           }, // 0x002E
        { 0x2E0A,  rosemount_analytical_model_code(0x2E0A)           }, // 0x002E
        { 0x2E0B,  rosemount_analytical_model_code(0x2E0B)           }, // 0x002E
        { 0x2E0C,  rosemount_analytical_model_code(0x2E0C)           }, // 0x002E
        { 0x2E0D,  rosemount_analytical_model_code(0x2E0D)           }, // 0x002E
        { 0x2E0E,  rosemount_analytical_model_code(0x2E0E)           }, // 0x002E
        { 0x2E0F,  rosemount_analytical_model_code(0x2E0F)           }, // 0x002E
        { 0x2E10,  rosemount_analytical_model_code(0x2E10)           }, // 0x002E
        { 0x2E14,  rosemount_analytical_model_code(0x2E14)           }, // 0x002E
        { 0x2E15,  rosemount_analytical_model_code(0x2E15)           }, // 0x002E
        { 0x2E16,  rosemount_analytical_model_code(0x2E16)           }, // 0x002E
        { 0x2E17,  rosemount_analytical_model_code(0x2E17)           }, // 0x002E
        { 0x2E18,  rosemount_analytical_model_code(0x2E18)           }, // 0x002E
        { 0x2E19,  rosemount_analytical_model_code(0x2E19)           }, // 0x002E
        { 0x2E1A,  rosemount_analytical_model_code(0x2E1A)           }, // 0x002E
        { 0x2E1B,  rosemount_analytical_model_code(0x2E1B)           }, // 0x002E
        { 0x2E1C,  rosemount_analytical_model_code(0x2E1C)           }, // 0x002E
        { 0x2E1D,  rosemount_analytical_model_code(0x2E1D)           }, // 0x002E
        { 0x2E1E,  rosemount_analytical_model_code(0x2E1E)           }, // 0x002E
        { 0x2E1F,  rosemount_analytical_model_code(0x2E1F)           }, // 0x002E
        { 0x2E20,  rosemount_analytical_model_code(0x2E20)           }, // 0x002E
        { 0x2E2B,  rosemount_analytical_model_code(0x2E2B)           }, // 0x002E
        { 0x2E50,  rosemount_analytical_model_code(0x2E50)           }, // 0x002E
        { 0x2E51,  rosemount_analytical_model_code(0x2E51)           }, // 0x002E
        { 0x2E52,  rosemount_analytical_model_code(0x2E52)           }, // 0x002E
        { 0x2E53,  rosemount_analytical_model_code(0x2E53)           }, // 0x002E
        { 0x2E55,  rosemount_analytical_model_code(0x2E55)           }, // 0x002E
        { 0x2E56,  rosemount_analytical_model_code(0x2E56)           }, // 0x002E

        { 0x2F01,  Valmet_Automation_model_code(0x2F01)              }, // 0x002F
        { 0x2F3C,  Valmet_Automation_model_code(0x2F3C)              }, // 0x002F
        { 0x2F3D,  Valmet_Automation_model_code(0x2F3D)              }, // 0x002F
        { 0x2F3E,  Valmet_Automation_model_code(0x2F3E)              }, // 0x002F
        { 0x2F3F,  Valmet_Automation_model_code(0x2F3F)              }, // 0x002F
        { 0x2F40,  Valmet_Automation_model_code(0x2F40)              }, // 0x002F

        { 0x3001,  Flowserve_model_code(0x3001)                      }, // 0x0030
        { 0x3002,  Flowserve_model_code(0x3002)                      }, // 0x0030
        { 0x3003,  Flowserve_model_code(0x3003)                      }, // 0x0030
        { 0x3004,  Flowserve_model_code(0x3004)                      }, // 0x0030
        { 0x3005,  Flowserve_model_code(0x3005)                      }, // 0x0030
        { 0x3006,  Flowserve_model_code(0x3006)                      }, // 0x0030

        { 0x3201,  Viatran_model_code(0x3201)                        }, // 0x0032
        { 0x322E,  Viatran_model_code(0x322E)                        }, // 0x0032

        { 0x3601,  Yamatake_model_code(0x3601)                       }, // 0x0036
        { 0x3602,  Yamatake_model_code(0x3602)                       }, // 0x0036
        { 0x3603,  Yamatake_model_code(0x3603)                       }, // 0x0036
        { 0x3604,  Yamatake_model_code(0x3604)                       }, // 0x0036
        { 0x3605,  Yamatake_model_code(0x3605)                       }, // 0x0036
        { 0x3608,  Yamatake_model_code(0x3608)                       }, // 0x0036
        { 0x360C,  Yamatake_model_code(0x360C)                       }, // 0x0036
        { 0x360D,  Yamatake_model_code(0x360D)                       }, // 0x0036

        { 0x3701,  Yokogawa_model_code(0x3701)                       }, // 0x0037
        { 0x3702,  Yokogawa_model_code(0x3702)                       }, // 0x0037
        { 0x3703,  Yokogawa_model_code(0x3703)                       }, // 0x0037
        { 0x3704,  Yokogawa_model_code(0x3704)                       }, // 0x0037
        { 0x3705,  Yokogawa_model_code(0x3705)                       }, // 0x0037
        { 0x3706,  Yokogawa_model_code(0x3706)                       }, // 0x0037
        { 0x3708,  Yokogawa_model_code(0x3708)                       }, // 0x0037
        { 0x3709,  Yokogawa_model_code(0x3709)                       }, // 0x0037
        { 0x370A,  Yokogawa_model_code(0x370A)                       }, // 0x0037
        { 0x370B,  Yokogawa_model_code(0x370B)                       }, // 0x0037
        { 0x370C,  Yokogawa_model_code(0x370C)                       }, // 0x0037
        { 0x370D,  Yokogawa_model_code(0x370D)                       }, // 0x0037
        { 0x3714,  Yokogawa_model_code(0x3714)                       }, // 0x0037
        { 0x3715,  Yokogawa_model_code(0x3715)                       }, // 0x0037
        { 0x3716,  Yokogawa_model_code(0x3716)                       }, // 0x0037
        { 0x3718,  Yokogawa_model_code(0x3718)                       }, // 0x0037
        { 0x3727,  Yokogawa_model_code(0x3727)                       }, // 0x0037
        { 0x3728,  Yokogawa_model_code(0x3728)                       }, // 0x0037
        { 0x372B,  Yokogawa_model_code(0x372B)                       }, // 0x0037
        { 0x372C,  Yokogawa_model_code(0x372C)                       }, // 0x0037
        { 0x372D,  Yokogawa_model_code(0x372D)                       }, // 0x0037
        { 0x3740,  Yokogawa_model_code(0x3740)                       }, // 0x0037
        { 0x3741,  Yokogawa_model_code(0x3741)                       }, // 0x0037
        { 0x3742,  Yokogawa_model_code(0x3742)                       }, // 0x0037
        { 0x3750,  Yokogawa_model_code(0x3750)                       }, // 0x0037
        { 0x3751,  Yokogawa_model_code(0x3751)                       }, // 0x0037
        { 0x3752,  Yokogawa_model_code(0x3752)                       }, // 0x0037
        { 0x3753,  Yokogawa_model_code(0x3753)                       }, // 0x0037
        { 0x3754,  Yokogawa_model_code(0x3754)                       }, // 0x0037
        { 0x3757,  Yokogawa_model_code(0x3757)                       }, // 0x0037
        { 0x3758,  Yokogawa_model_code(0x3758)                       }, // 0x0037
        { 0x3759,  Yokogawa_model_code(0x3759)                       }, // 0x0037
        { 0x375A,  Yokogawa_model_code(0x375A)                       }, // 0x0037
        { 0x375B,  Yokogawa_model_code(0x375B)                       }, // 0x0037

        { 0x3B13,  Solartron_Mobrey_model_code(0x3B13)               }, // 0x003B
        { 0x3B14,  Solartron_Mobrey_model_code(0x3B14)               }, // 0x003B
        { 0x3B15,  Solartron_Mobrey_model_code(0x3B15)               }, // 0x003B
        { 0x3B21,  Solartron_Mobrey_model_code(0x3B21)               }, // 0x003B
        { 0x3B29,  Solartron_Mobrey_model_code(0x3B29)               }, // 0x003B
        { 0x3B2A,  Solartron_Mobrey_model_code(0x3B2A)               }, // 0x003B
        { 0x3B2B,  Solartron_Mobrey_model_code(0x3B2B)               }, // 0x003B
        { 0x3B2C,  Solartron_Mobrey_model_code(0x3B2C)               }, // 0x003B
        { 0x3B2D,  Solartron_Mobrey_model_code(0x3B2D)               }, // 0x003B
        { 0x3B2E,  Solartron_Mobrey_model_code(0x3B2E)               }, // 0x003B
        { 0x3B2F,  Solartron_Mobrey_model_code(0x3B2F)               }, // 0x003B
        { 0x3B30,  Solartron_Mobrey_model_code(0x3B30)               }, // 0x003B
        { 0x3B31,  Solartron_Mobrey_model_code(0x3B31)               }, // 0x003B

        { 0x3D01,  Princo_model_code(0x3D01)                         }, // 0x003D

        { 0x3E01,  Smar_model_code(0x3E01)                           }, // 0x003E
        { 0x3E02,  Smar_model_code(0x3E02)                           }, // 0x003E
        { 0x3E03,  Smar_model_code(0x3E03)                           }, // 0x003E
        { 0x3E04,  Smar_model_code(0x3E04)                           }, // 0x003E
        { 0x3E05,  Smar_model_code(0x3E05)                           }, // 0x003E
        { 0x3E06,  Smar_model_code(0x3E06)                           }, // 0x003E
        { 0x3E0A,  Smar_model_code(0x3E0A)                           }, // 0x003E

        { 0x3F01,  Foxboro_Eckardt_model_code(0x3F01)                }, // 0x003F
        { 0x3F02,  Foxboro_Eckardt_model_code(0x3F02)                }, // 0x003F
        { 0x3F03,  Foxboro_Eckardt_model_code(0x3F03)                }, // 0x003F
        { 0x3F04,  Foxboro_Eckardt_model_code(0x3F04)                }, // 0x003F
        { 0x3F05,  Foxboro_Eckardt_model_code(0x3F05)                }, // 0x003F
        { 0x3F06,  Foxboro_Eckardt_model_code(0x3F06)                }, // 0x003F

        { 0x4015,  Measurement_Technology_model_code(0x4015)         }, // 0x0040
        { 0x4022,  Measurement_Technology_model_code(0x4022)         }, // 0x0040

        { 0x42EF,  Samson_model_code(0x42EF)                         }, // 0x0042
        { 0x42F9,  Samson_model_code(0x42F9)                         }, // 0x0042

        { 0x43EE,  Sparling_Instruments_model_code(0x43EE)           }, // 0x0043

        { 0x45D2,  Krohne_model_code(0x45D2)                         }, // 0x0045
        { 0x45D3,  Krohne_model_code(0x45D3)                         }, // 0x0045
        { 0x45D4,  Krohne_model_code(0x45D4)                         }, // 0x0045
        { 0x45D5,  Krohne_model_code(0x45D5)                         }, // 0x0045
        { 0x45D9,  Krohne_model_code(0x45D9)                         }, // 0x0045
        { 0x45DB,  Krohne_model_code(0x45DB)                         }, // 0x0045
        { 0x45DD,  Krohne_model_code(0x45DD)                         }, // 0x0045
        { 0x45DE,  Krohne_model_code(0x45DE)                         }, // 0x0045
        { 0x45E2,  Krohne_model_code(0x45E2)                         }, // 0x0045
        { 0x45E3,  Krohne_model_code(0x45E3)                         }, // 0x0045
        { 0x45E4,  Krohne_model_code(0x45E4)                         }, // 0x0045
        { 0x45E5,  Krohne_model_code(0x45E5)                         }, // 0x0045
        { 0x45E6,  Krohne_model_code(0x45E6)                         }, // 0x0045
        { 0x45E7,  Krohne_model_code(0x45E7)                         }, // 0x0045
        { 0x45E8,  Krohne_model_code(0x45E8)                         }, // 0x0045
        { 0x45E9,  Krohne_model_code(0x45E9)                         }, // 0x0045
        { 0x45EA,  Krohne_model_code(0x45EA)                         }, // 0x0045
        { 0x45EB,  Krohne_model_code(0x45EB)                         }, // 0x0045
        { 0x45EC,  Krohne_model_code(0x45EC)                         }, // 0x0045
        { 0x45ED,  Krohne_model_code(0x45ED)                         }, // 0x0045
        { 0x45EE,  Krohne_model_code(0x45EE)                         }, // 0x0045
        { 0x45EF,  Krohne_model_code(0x45EF)                         }, // 0x0045
        { 0x45F0,  Krohne_model_code(0x45F0)                         }, // 0x0045
        { 0x45F2,  Krohne_model_code(0x45F2)                         }, // 0x0045
        { 0x45F3,  Krohne_model_code(0x45F3)                         }, // 0x0045
        { 0x45F4,  Krohne_model_code(0x45F4)                         }, // 0x0045
        { 0x45F5,  Krohne_model_code(0x45F5)                         }, // 0x0045
        { 0x45F6,  Krohne_model_code(0x45F6)                         }, // 0x0045
        { 0x45F7,  Krohne_model_code(0x45F7)                         }, // 0x0045
        { 0x45F8,  Krohne_model_code(0x45F8)                         }, // 0x0045
        { 0x45F9,  Krohne_model_code(0x45F9)                         }, // 0x0045

        { 0x47E9,  Druck_model_code(0x47E9)                          }, // 0x0047
        { 0x47EC,  Druck_model_code(0x47EC)                          }, // 0x0047
        { 0x47EF,  Druck_model_code(0x47EF)                          }, // 0x0047

        { 0x49EB,  Elcon_Instruments_model_code(0x49EB)              }, // 0x0049
        { 0x49EC,  Elcon_Instruments_model_code(0x49EC)              }, // 0x0049
        { 0x49ED,  Elcon_Instruments_model_code(0x49ED)              }, // 0x0049
        { 0x49EE,  Elcon_Instruments_model_code(0x49EE)              }, // 0x0049

        { 0x4D01,  Westlock_Controls_model_code(0x4D01)              }, // 0x004D
        { 0x4D02,  Westlock_Controls_model_code(0x4D02)              }, // 0x004D
        { 0x4D03,  Westlock_Controls_model_code(0x4D03)              }, // 0x004D
        { 0x4D04,  Westlock_Controls_model_code(0x4D04)              }, // 0x004D

        { 0x4E02,  Drexelbrook_model_code(0x4E02)                    }, // 0x004E
        { 0x4EEB,  Drexelbrook_model_code(0x4EEB)                    }, // 0x004E

        { 0x4FED,  Saab_Tank_Control_model_code(0x4FED)              }, // 0x004F
        { 0x4FEF,  Saab_Tank_Control_model_code(0x4FEF)              }, // 0x004F

        { 0x5067,  KTEK_model_code(0x5067)                           }, // 0x0050
        { 0x5072,  KTEK_model_code(0x5072)                           }, // 0x0050
        { 0x5073,  KTEK_model_code(0x5073)                           }, // 0x0050
        { 0x5076,  KTEK_model_code(0x5076)                           }, // 0x0050
        { 0x5077,  KTEK_model_code(0x5077)                           }, // 0x0050
        { 0x5078,  KTEK_model_code(0x5078)                           }, // 0x0050
        { 0x507A,  KTEK_model_code(0x507A)                           }, // 0x0050
        { 0x507B,  KTEK_model_code(0x507B)                           }, // 0x0050
        { 0x507E,  KTEK_model_code(0x507E)                           }, // 0x0050
        { 0x507F,  KTEK_model_code(0x507F)                           }, // 0x0050
        { 0x5098,  KTEK_model_code(0x5098)                           }, // 0x0050
        { 0x50CB,  KTEK_model_code(0x50CB)                           }, // 0x0050

        { 0x52E9,  Draeger_model_code(0x52E9)                        }, // 0x0052
        { 0x52EB,  Draeger_model_code(0x52EB)                        }, // 0x0052
        { 0x52ED,  Draeger_model_code(0x52ED)                        }, // 0x0052
        { 0x52F7,  Draeger_model_code(0x52F7)                        }, // 0x0052

        { 0x54F8,  Meridian_model_code(0x54F8)                       }, // 0x0054
        { 0x54F9,  Meridian_model_code(0x54F9)                       }, // 0x0054

        { 0x55DE,  BTG_model_code(0x55DE)                            }, // 0x0055

        { 0x56E2,  Magnetrol_model_code(0x56E2)                      }, // 0x0056
        { 0x56E3,  Magnetrol_model_code(0x56E3)                      }, // 0x0056
        { 0x56E4,  Magnetrol_model_code(0x56E4)                      }, // 0x0056
        { 0x56E5,  Magnetrol_model_code(0x56E5)                      }, // 0x0056
        { 0x56E6,  Magnetrol_model_code(0x56E6)                      }, // 0x0056
        { 0x56E7,  Magnetrol_model_code(0x56E7)                      }, // 0x0056
        { 0x56E8,  Magnetrol_model_code(0x56E8)                      }, // 0x0056
        { 0x56E9,  Magnetrol_model_code(0x56E9)                      }, // 0x0056
        { 0x56EA,  Magnetrol_model_code(0x56EA)                      }, // 0x0056
        { 0x56EB,  Magnetrol_model_code(0x56EB)                      }, // 0x0056
        { 0x56EC,  Magnetrol_model_code(0x56EC)                      }, // 0x0056
        { 0x56ED,  Magnetrol_model_code(0x56ED)                      }, // 0x0056
        { 0x56EE,  Magnetrol_model_code(0x56EE)                      }, // 0x0056
        { 0x56EF,  Magnetrol_model_code(0x56EF)                      }, // 0x0056

        { 0x57E4,  Metso_Automation_model_code(0x57E4)               }, // 0x0057
        { 0x57E5,  Metso_Automation_model_code(0x57E5)               }, // 0x0057
        { 0x57EB,  Metso_Automation_model_code(0x57EB)               }, // 0x0057
        { 0x57EE,  Metso_Automation_model_code(0x57EE)               }, // 0x0057
        { 0x57EF,  Metso_Automation_model_code(0x57EF)               }, // 0x0057

        { 0x58C8,  Milltronics_model_code(0x58C8)                    }, // 0x0058
        { 0x58C9,  Milltronics_model_code(0x58C9)                    }, // 0x0058
        { 0x58CA,  Milltronics_model_code(0x58CA)                    }, // 0x0058
        { 0x58CC,  Milltronics_model_code(0x58CC)                    }, // 0x0058
        { 0x58CD,  Milltronics_model_code(0x58CD)                    }, // 0x0058
        { 0x58CE,  Milltronics_model_code(0x58CE)                    }, // 0x0058
        { 0x58CF,  Milltronics_model_code(0x58CF)                    }, // 0x0058
        { 0x58D1,  Milltronics_model_code(0x58D1)                    }, // 0x0058
        { 0x58D3,  Milltronics_model_code(0x58D3)                    }, // 0x0058
        { 0x58D4,  Milltronics_model_code(0x58D4)                    }, // 0x0058
        { 0x58D6,  Milltronics_model_code(0x58D6)                    }, // 0x0058
        { 0x58D8,  Milltronics_model_code(0x58D8)                    }, // 0x0058

        { 0x5AC8,  Anderson_Instrument_Company_model_code(0x5AC8)    }, // 0x005A

        { 0x5BEB,  Inor_model_code(0x5BEB)                           }, // 0x005B
        { 0x5BEF,  Inor_model_code(0x5BEF)                           }, // 0x005B

        { 0x5CC8,  Robertshaw_model_code(0x5CC8)                     }, // 0x005C

        { 0x5DE0,  PEPPERL_FUCHS_model_code(0x5DE0)                  }, // 0x005D
        { 0x5DE1,  PEPPERL_FUCHS_model_code(0x5DE1)                  }, // 0x005D
        { 0x5DE2,  PEPPERL_FUCHS_model_code(0x5DE2)                  }, // 0x005D
        { 0x5DE3,  PEPPERL_FUCHS_model_code(0x5DE3)                  }, // 0x005D
        { 0x5DE4,  PEPPERL_FUCHS_model_code(0x5DE4)                  }, // 0x005D
        { 0x5DE5,  PEPPERL_FUCHS_model_code(0x5DE5)                  }, // 0x005D
        { 0x5DE6,  PEPPERL_FUCHS_model_code(0x5DE6)                  }, // 0x005D
        { 0x5DE7,  PEPPERL_FUCHS_model_code(0x5DE7)                  }, // 0x005D
        { 0x5DE8,  PEPPERL_FUCHS_model_code(0x5DE8)                  }, // 0x005D
        { 0x5DE9,  PEPPERL_FUCHS_model_code(0x5DE9)                  }, // 0x005D
        { 0x5DEA,  PEPPERL_FUCHS_model_code(0x5DEA)                  }, // 0x005D
        { 0x5DEB,  PEPPERL_FUCHS_model_code(0x5DEB)                  }, // 0x005D
        { 0x5DEC,  PEPPERL_FUCHS_model_code(0x5DEC)                  }, // 0x005D
        { 0x5DED,  PEPPERL_FUCHS_model_code(0x5DED)                  }, // 0x005D
        { 0x5DEE,  PEPPERL_FUCHS_model_code(0x5DEE)                  }, // 0x005D
        { 0x5DEF,  PEPPERL_FUCHS_model_code(0x5DEF)                  }, // 0x005D

        { 0x5EEE,  Accutech_model_code(0x5EEE)                       }, // 0x005E
        { 0x5EEF,  Accutech_model_code(0x5EEF)                       }, // 0x005E

        { 0x60ED,  Bourdon_Haenni_model_code(0x60ED)                 }, // 0x0060
        { 0x60EE,  Bourdon_Haenni_model_code(0x60EE)                 }, // 0x0060
        { 0x60EF,  Bourdon_Haenni_model_code(0x60EF)                 }, // 0x0060

        { 0x61E4,  Knick_model_code(0x61E4)                          }, // 0x0061
        { 0x61E5,  Knick_model_code(0x61E5)                          }, // 0x0061
        { 0x61E6,  Knick_model_code(0x61E6)                          }, // 0x0061
        { 0x61E7,  Knick_model_code(0x61E7)                          }, // 0x0061
        { 0x61E8,  Knick_model_code(0x61E8)                          }, // 0x0061
        { 0x61E9,  Knick_model_code(0x61E9)                          }, // 0x0061
        { 0x61EA,  Knick_model_code(0x61EA)                          }, // 0x0061
        { 0x61EB,  Knick_model_code(0x61EB)                          }, // 0x0061

        { 0x62D0,  VEGA_model_code(0x62D0)                           }, // 0x0062
        { 0x62D1,  VEGA_model_code(0x62D1)                           }, // 0x0062
        { 0x62D2,  VEGA_model_code(0x62D2)                           }, // 0x0062
        { 0x62D3,  VEGA_model_code(0x62D3)                           }, // 0x0062
        { 0x62D4,  VEGA_model_code(0x62D4)                           }, // 0x0062
        { 0x62D5,  VEGA_model_code(0x62D5)                           }, // 0x0062
        { 0x62D6,  VEGA_model_code(0x62D6)                           }, // 0x0062
        { 0x62D7,  VEGA_model_code(0x62D7)                           }, // 0x0062
        { 0x62D8,  VEGA_model_code(0x62D8)                           }, // 0x0062
        { 0x62D9,  VEGA_model_code(0x62D9)                           }, // 0x0062
        { 0x62DA,  VEGA_model_code(0x62DA)                           }, // 0x0062
        { 0x62DB,  VEGA_model_code(0x62DB)                           }, // 0x0062
        { 0x62DC,  VEGA_model_code(0x62DC)                           }, // 0x0062

        { 0x63ED,  MTS_SYS_CORPS_model_code(0x63ED)                  }, // 0x0063

        { 0x6464,  Oval_model_code(0x6464)                           }, // 0x0064
        { 0x6465,  Oval_model_code(0x6465)                           }, // 0x0064
        { 0x646E,  Oval_model_code(0x646E)                           }, // 0x0064
        { 0x646F,  Oval_model_code(0x646F)                           }, // 0x0064
        { 0x6470,  Oval_model_code(0x6470)                           }, // 0x0064
        { 0x647B,  Oval_model_code(0x647B)                           }, // 0x0064

        { 0x6564,  Masoneilan_model_code(0x6564)                     }, // 0x0065
        { 0x65C8,  Masoneilan_model_code(0x65C8)                     }, // 0x0065
        { 0x65C9,  Masoneilan_model_code(0x65C9)                     }, // 0x0065
        { 0x65CA,  Masoneilan_model_code(0x65CA)                     }, // 0x0065
        { 0x65CB,  Masoneilan_model_code(0x65CB)                     }, // 0x0065

        { 0x66EF,  Besta_model_code(0x66EF)                          }, // 0x0066

        { 0x67E0,  Ohmart_model_code(0x67E0)                         }, // 0x0067
        { 0x67E1,  Ohmart_model_code(0x67E1)                         }, // 0x0067

        { 0x6801,  Harold_Beck_and_Sons_model_code(0x6801)           }, // 0x0068
        { 0x680A,  Harold_Beck_and_Sons_model_code(0x680A)           }, // 0x0068
        { 0x68EF,  Harold_Beck_and_Sons_model_code(0x68EF)           }, // 0x0068

        { 0x6BEE,  Wika_model_code(0x6BEE)                           }, // 0x006B
        { 0x6BEF,  Wika_model_code(0x6BEF)                           }, // 0x006B

        { 0x6CEB,  Bopp_Reuther_Heinrichs_model_code(0x6CEB)         }, // 0x006C
        { 0x6CEC,  Bopp_Reuther_Heinrichs_model_code(0x6CEC)         }, // 0x006C
        { 0x6CED,  Bopp_Reuther_Heinrichs_model_code(0x6CED)         }, // 0x006C
        { 0x6CEE,  Bopp_Reuther_Heinrichs_model_code(0x6CEE)         }, // 0x006C
        { 0x6CEF,  Bopp_Reuther_Heinrichs_model_code(0x6CEF)         }, // 0x006C

        { 0x6DDF,  PR_Electronics_model_code(0x6DDF)                 }, // 0x006D
        { 0x6DEE,  PR_Electronics_model_code(0x6DEE)                 }, // 0x006D
        { 0x6DEF,  PR_Electronics_model_code(0x6DEF)                 }, // 0x006D

        { 0x71EE,  Apparatebau_Hundsbach_model_code(0x71EE)          }, // 0x0071

        { 0x72DE,  Dynisco_model_code(0x72DE)                        }, // 0x0072
        { 0x72DF,  Dynisco_model_code(0x72DF)                        }, // 0x0072
        { 0x72E0,  Dynisco_model_code(0x72E0)                        }, // 0x0072

        { 0x74EF,  Direct_Measurement_model_code(0x74EF)             }, // 0x0074

        { 0x75EF,  Klay_model_code(0x75EF)                           }, // 0x0075

        { 0x78EF,  Buerkert_Fluid_Control_Systems_model_code(0x78EF) }, // 0x0078

        { 0x7CEE,  GLI_model_code(0x7CEE)                            }, // 0x007C
        { 0x7CEF,  GLI_model_code(0x7CEF)                            }, // 0x007C

        { 0x7EE0,  Paper_Machine_Components_model_code(0x7EE0)       }, // 0x007E

        { 0x7F3C,  Labom_model_code(0x7F3C)                          }, // 0x007F
        { 0x7FE0,  Labom_model_code(0x7FE0)                          }, // 0x007F
        { 0x7FEF,  Labom_model_code(0x7FEF)                          }, // 0x007F

        { 0x8003,  Danfoss_model_code(0x8003)                        }, // 0x0080

        { 0x817F,  Turbo_model_code(0x817F)                          }, // 0x0081

        { 0x827B,  Tokyo_Keiso_model_code(0x827B)                    }, // 0x0082
        { 0x827F,  Tokyo_Keiso_model_code(0x827F)                    }, // 0x0082

        { 0x837D,  SMC_model_code(0x837D)                            }, // 0x0083
        { 0x837E,  SMC_model_code(0x837E)                            }, // 0x0083
        { 0x83EF,  SMC_model_code(0x83EF)                            }, // 0x0083

        { 0x84EF,  Status_Instruments_model_code(0x84EF)             }, // 0x0084

        { 0x857F,  Huakong_model_code(0x857F)                        }, // 0x0085

        { 0x8661,  Duon_System_model_code(0x8661)                    }, // 0x0086
        { 0x866B,  Duon_System_model_code(0x866B)                    }, // 0x0086
        { 0x8675,  Duon_System_model_code(0x8675)                    }, // 0x0086

        { 0x8701,  Vortek_Instruments_model_code(0x8701)             }, // 0x0087

        { 0x89EF,  Action_Instruments_model_code(0x89EF)             }, // 0x0089

        { 0x8C88,  Magtech_model_code(0x8C88)                        }, // 0x008C
        { 0x8C89,  Magtech_model_code(0x8C89)                        }, // 0x008C

        { 0x8D01,  Rueger_model_code(0x8D01)                         }, // 0x008D
        { 0x8D7F,  Rueger_model_code(0x8D7F)                         }, // 0x008D

        { 0x8E74,  Mettler_Toledo_model_code(0x8E74)                 }, // 0x008E
        { 0x8E75,  Mettler_Toledo_model_code(0x8E75)                 }, // 0x008E
        { 0x8E76,  Mettler_Toledo_model_code(0x8E76)                 }, // 0x008E
        { 0x8E77,  Mettler_Toledo_model_code(0x8E77)                 }, // 0x008E
        { 0x8E78,  Mettler_Toledo_model_code(0x8E78)                 }, // 0x008E
        { 0x8E79,  Mettler_Toledo_model_code(0x8E79)                 }, // 0x008E
        { 0x8E7A,  Mettler_Toledo_model_code(0x8E7A)                 }, // 0x008E
        { 0x8E7B,  Mettler_Toledo_model_code(0x8E7B)                 }, // 0x008E

        { 0x8F76,  Det_Tronics_model_code(0x8F76)                    }, // 0x008F
        { 0x8F77,  Det_Tronics_model_code(0x8F77)                    }, // 0x008F
        { 0x8F78,  Det_Tronics_model_code(0x8F78)                    }, // 0x008F
        { 0x8F79,  Det_Tronics_model_code(0x8F79)                    }, // 0x008F
        { 0x8F7A,  Det_Tronics_model_code(0x8F7A)                    }, // 0x008F
        { 0x8F7B,  Det_Tronics_model_code(0x8F7B)                    }, // 0x008F
        { 0x8F7C,  Det_Tronics_model_code(0x8F7C)                    }, // 0x008F
        { 0x8F7E,  Det_Tronics_model_code(0x8F7E)                    }, // 0x008F
        { 0x8F7F,  Det_Tronics_model_code(0x8F7F)                    }, // 0x008F

        { 0x907D,  Thermo_MeasureTech_model_code(0x907D)             }, // 0x0090
        { 0x907E,  Thermo_MeasureTech_model_code(0x907E)             }, // 0x0090
        { 0x907F,  Thermo_MeasureTech_model_code(0x907F)             }, // 0x0090

        { 0x91EF,  Dezurik_model_code(0x91EF)                        }, // 0x0091

        { 0x927F,  Phase_Dynamics_model_code(0x927F)                 }, // 0x0092

        { 0x937A,  Welltech_model_code(0x937A)                       }, // 0x0093
        { 0x937B,  Welltech_model_code(0x937B)                       }, // 0x0093
        { 0x937C,  Welltech_model_code(0x937C)                       }, // 0x0093

        { 0x9977,  Metran_model_code(0x9977)                         }, // 0x0099
        { 0x9979,  Metran_model_code(0x9979)                         }, // 0x0099
        { 0x997B,  Metran_model_code(0x997B)                         }, // 0x0099
        { 0x997C,  Metran_model_code(0x997C)                         }, // 0x0099
        { 0x997D,  Metran_model_code(0x997D)                         }, // 0x0099
        { 0x997E,  Metran_model_code(0x997E)                         }, // 0x0099
        { 0x997F,  Metran_model_code(0x997F)                         }, // 0x0099

        { 0x9A7F,  Milton_Roy_model_code(0x9A7F)                     }, // 0x009A

        { 0x9BD3,  PMV_model_code(0x9BD3)                            }, // 0x009B

        { 0x9C01,  Turck_model_code(0x9C01)                          }, // 0x009C

        { 0x9D70,  Panametrics_model_code(0x9D70)                    }, // 0x009D

        { 0x9E01,  Stahl_model_code(0x9E01)                          }, // 0x009E
        { 0x9E02,  Stahl_model_code(0x9E02)                          }, // 0x009E
        { 0x9E03,  Stahl_model_code(0x9E03)                          }, // 0x009E
        { 0x9E04,  Stahl_model_code(0x9E04)                          }, // 0x009E
        { 0x9E05,  Stahl_model_code(0x9E05)                          }, // 0x009E
        { 0x9E06,  Stahl_model_code(0x9E06)                          }, // 0x009E
        { 0x9E07,  Stahl_model_code(0x9E07)                          }, // 0x009E

        { 0x9F7F,  Analytical_Technology_Inc_model_code(0x9F7F)      }, // 0x009F

        { 0xA002,  FINT_model_code(0xA002)                           }, // 0x00A0
        { 0xA0ED,  FINT_model_code(0xA0ED)                           }, // 0x00A0

        { 0xA17C,  BERTHOLD_model_code(0xA17C)                       }, // 0x00A1
        { 0xA17D,  BERTHOLD_model_code(0xA17D)                       }, // 0x00A1
        { 0xA17E,  BERTHOLD_model_code(0xA17E)                       }, // 0x00A1
        { 0xA17F,  BERTHOLD_model_code(0xA17F)                       }, // 0x00A1

        { 0xA2EF,  InterCorr_model_code(0xA2EF)                      }, // 0x00A2

        { 0xA678,  Fluid_Components_model_code(0xA678)               }, // 0x00A6

        { 0xA92E,  Invensys_model_code(0xA92E)                       }, // 0x00A9
        { 0xA934,  Invensys_model_code(0xA934)                       }, // 0x00A9

        { 0xAB01,  Tyco_Valve_Controls_model_code(0xAB01)            }, // 0x00AB

        { 0xAD00,  JTec_Associates_model_code(0xAD00)                }, // 0x00AD
        { 0xAD01,  JTec_Associates_model_code(0xAD01)                }, // 0x00AD

        { 0xAE7F,  Tracerco_model_code(0xAE7F)                       }, // 0x00AE
        { 0xAE9F,  Tracerco_model_code(0xAE9F)                       }, // 0x00AE

        { 0xB001,  Phoenix_Contact_model_code(0xB001)                }, // 0x00B0
        { 0xB002,  Phoenix_Contact_model_code(0xB002)                }, // 0x00B0
        { 0xB003,  Phoenix_Contact_model_code(0xB003)                }, // 0x00B0
        { 0xB004,  Phoenix_Contact_model_code(0xB004)                }, // 0x00B0

        { 0xB27F,  Amer_Level_Instr_model_code(0xB27F)               }, // 0x00B2

        { 0xB401,  YTC_model_code(0xB401)                            }, // 0x00B4
        { 0xB402,  YTC_model_code(0xB402)                            }, // 0x00B4

        { 0xB57F,  Pyromation_Inc_model_code(0xB57F)                 }, // 0x00B5
        { 0xB580,  Pyromation_Inc_model_code(0xB580)                 }, // 0x00B5

        { 0xB67F,  Satron_Instruments_model_code(0xB67F)             }, // 0x00B6

        { 0xB97F,  BD_Sensors_model_code(0xB97F)                     }, // 0x00B9

        { 0xBC7A,  APLISENS_model_code(0xBC7A)                       }, // 0x00BC
        { 0xBC7B,  APLISENS_model_code(0xBC7B)                       }, // 0x00BC

        { 0xBD01,  Badger_Meter_model_code(0xBD01)                   }, // 0x00BD

        { 0xBF7C,  GP_50_model_code(0xBF7C)                          }, // 0x00BF

        { 0xC0EF,  Kongsberg_Maritime_model_code(0xC0EF)             }, // 0x00C0

        { 0xC101,  ASA_SpA_model_code(0xC101)                        }, // 0x00C1

        { 0xC221,  Hengesbach_model_code(0xC221)                     }, // 0x00C2

        { 0xC374,  Lanlian_Instruments_model_code(0xC374)            }, // 0x00C3

        { 0xC401,  Spectrum_Controls_model_code(0xC401)              }, // 0x00C4

        { 0xC580,  Kajaani_Process_Measurements_model_code(0xC580)   }, // 0x00C5
        { 0xC581,  Kajaani_Process_Measurements_model_code(0xC581)   }, // 0x00C5

        { 0xC680,  FAFNIR_model_code(0xC680)                         }, // 0x00C6

        { 0xC780,  SICK_model_code(0xC780)                           }, // 0x00C7

        { 0xCA80,  Spirax_Sarco_Italy_model_code(0xCA80)             }, // 0x00CA

        { 0xCC80,  Tecfluid_SA_model_code(0xCC80)                    }, // 0x00CC
        { 0xCC81,  Tecfluid_SA_model_code(0xCC81)                    }, // 0x00CC

        { 0xCE80,  Roost_model_code(0xCE80)                          }, // 0x00CE

        { 0xCF80,  KOSO_model_code(0xCF80)                           }, // 0x00CF
        { 0xCF81,  KOSO_model_code(0xCF81)                           }, // 0x00CF

        { 0xD380,  HEINRICHS_model_code(0xD380)                      }, // 0x00D3
        { 0xD381,  HEINRICHS_model_code(0xD381)                      }, // 0x00D3

        { 0xD480,  SIC_model_code(0xD480)                            }, // 0x00D4
        { 0xD482,  SIC_model_code(0xD482)                            }, // 0x00D4
        { 0xD485,  SIC_model_code(0xD485)                            }, // 0x00D4
        { 0xD486,  SIC_model_code(0xD486)                            }, // 0x00D4

        { 0xD580,  HACH_LANGE_model_code(0xD580)                     }, // 0x00D5
        { 0xD581,  HACH_LANGE_model_code(0xD581)                     }, // 0x00D5
        { 0xD582,  HACH_LANGE_model_code(0xD582)                     }, // 0x00D5
        { 0xD583,  HACH_LANGE_model_code(0xD583)                     }, // 0x00D5
        { 0xD584,  HACH_LANGE_model_code(0xD584)                     }, // 0x00D5

        { 0xDB80,  Spectrex_model_code(0xDB80)                       }, // 0x00DB
        { 0xDB81,  Spectrex_model_code(0xDB81)                       }, // 0x00DB

        { 0xDF80,  General_Monitors_model_code(0xDF80)               }, // 0x00DF
        { 0xDF81,  General_Monitors_model_code(0xDF81)               }, // 0x00DF
        { 0xDF82,  General_Monitors_model_code(0xDF82)               }, // 0x00DF
        { 0xDF83,  General_Monitors_model_code(0xDF83)               }, // 0x00DF
        { 0xDF84,  General_Monitors_model_code(0xDF84)               }, // 0x00DF
        { 0xDF89,  General_Monitors_model_code(0xDF89)               }, // 0x00DF
        { 0xDF90,  General_Monitors_model_code(0xDF90)               }, // 0x00DF

        { 0xF980,  HCF_model_code(0xF980)                            }, // 0x00F9
        { 0xF981,  HCF_model_code(0xF981)                            }, // 0x00F9
        { 0xF982,  HCF_model_code(0xF982)                            }, // 0x00F9
        { 0xF983,  HCF_model_code(0xF983)                            }, // 0x00F9
        { 0xF984,  HCF_model_code(0xF984)                            }, // 0x00F9

        { 0xE080,  ExSaf_model_code(0xE080)                          }, // 0x6000
        { 0xE0EC,  ExSaf_model_code(0xE0EC)                          }, // 0x6000
        { 0xE0ED,  ExSaf_model_code(0xE0ED)                          }, // 0x6000

        { 0xE082,  SEOJIN_INSTECH_model_code(0xE082)                 }, // 0x6001
        { 0xE0B4,  SEOJIN_INSTECH_model_code(0xE0B4)                 }, // 0x6001
        { 0xE0B5,  SEOJIN_INSTECH_model_code(0xE0B5)                 }, // 0x6001

        { 0xE083,  TASI_FLOW_model_code(0xE083)                      }, // 0x6002

        { 0xE084,  Daehan_Control_model_code(0xE084)                 }, // 0x6003

        { 0xE085,  APM_model_code(0xE085)                            }, // 0x6004
        { 0xE086,  APM_model_code(0xE086)                            }, // 0x6004
        { 0xE087,  APM_model_code(0xE087)                            }, // 0x6004

        { 0xE088,  ORANGE_INST_UK_model_code(0xE088)                 }, // 0x6005
        { 0xE089,  ORANGE_INST_UK_model_code(0xE089)                 }, // 0x6005

        { 0xE08A,  BARTEC_model_code(0xE08A)                         }, // 0x6006

        { 0xE08B,  Detcon_model_code(0xE08B)                         }, // 0x6007

        { 0xE08C,  MSA_model_code(0xE08C)                            }, // 0x6008
        { 0xE09F,  MSA_model_code(0xE09F)                            }, // 0x6008
        { 0xE0BC,  MSA_model_code(0xE0BC)                            }, // 0x6008
        { 0xE0F2,  MSA_model_code(0xE0F2)                            }, // 0x6008
        { 0xE0F3,  MSA_model_code(0xE0F3)                            }, // 0x6008

        { 0xE08D,  METROVAL_model_code(0xE08D)                       }, // 0x6009
        { 0xE0C8,  METROVAL_model_code(0xE0C8)                       }, // 0x6009
        { 0xE0C9,  METROVAL_model_code(0xE0C9)                       }, // 0x6009

        { 0xE081,  Etalon_Rus_model_code(0xE081)                     }, // 0x600A

        { 0xE08E,  JOGLER_model_code(0xE08E)                         }, // 0x600B

        { 0xE08F,  KSB_model_code(0xE08F)                            }, // 0x600C

        { 0xE090,  Richter_CT_model_code(0xE090)                     }, // 0x600D

        { 0xE091,  NET_SAFETY_model_code(0xE091)                     }, // 0x600E
        { 0xE09E,  NET_SAFETY_model_code(0xE09E)                     }, // 0x600E
        { 0xE0DF,  NET_SAFETY_model_code(0xE0DF)                     }, // 0x600E

        { 0xE092,  SECanada_model_code(0xE092)                       }, // 0x600F

        { 0xE093,  SUPCON_model_code(0xE093)                         }, // 0x6010
        { 0xE094,  SUPCON_model_code(0xE094)                         }, // 0x6010

        { 0xE095,  DKK_TOA_model_code(0xE095)                        }, // 0x6011
        { 0xE096,  DKK_TOA_model_code(0xE096)                        }, // 0x6011
        { 0xE097,  DKK_TOA_model_code(0xE097)                        }, // 0x6011
        { 0xE098,  DKK_TOA_model_code(0xE098)                        }, // 0x6011
        { 0xE099,  DKK_TOA_model_code(0xE099)                        }, // 0x6011
        { 0xE09A,  DKK_TOA_model_code(0xE09A)                        }, // 0x6011
        { 0xE09B,  DKK_TOA_model_code(0xE09B)                        }, // 0x6011

        { 0xE09C,  Dwyer_Instruments_model_code(0xE09C)              }, // 0x6012

        { 0xE09D,  FineTek_model_code(0xE09D)                        }, // 0x6013

        { 0xE0A0,  TopWorx_model_code(0xE0A0)                        }, // 0x6014
        { 0xE0CE,  TopWorx_model_code(0xE0CE)                        }, // 0x6014
        { 0xE0EB,  TopWorx_model_code(0xE0EB)                        }, // 0x6014

        { 0xE0A1,  HOFFER_FLOW_CNTRLS_model_code(0xE0A1)             }, // 0x6015
        { 0xE0F1,  HOFFER_FLOW_CNTRLS_model_code(0xE0F1)             }, // 0x6015

        { 0xE0A2,  DUST_NETWORKS_model_code(0xE0A2)                  }, // 0x6016
        { 0xE0A3,  DUST_NETWORKS_model_code(0xE0A3)                  }, // 0x6016
        { 0xE0A4,  DUST_NETWORKS_model_code(0xE0A4)                  }, // 0x6016

        { 0xE0A5,  Forbes_Marshall_model_code(0xE0A5)                }, // 0x6017
        { 0xE0A6,  Forbes_Marshall_model_code(0xE0A6)                }, // 0x6017
        { 0xE0A7,  Forbes_Marshall_model_code(0xE0A7)                }, // 0x6017
        { 0xE0A8,  Forbes_Marshall_model_code(0xE0A8)                }, // 0x6017
        { 0xE0A9,  Forbes_Marshall_model_code(0xE0A9)                }, // 0x6017
        { 0xE0AA,  Forbes_Marshall_model_code(0xE0AA)                }, // 0x6017

        { 0xE0AB,  All_Measures_Ltd_model_code(0xE0AB)               }, // 0x6018

        { 0xE0AC,  MACTek_model_code(0xE0AC)                         }, // 0x6019

        { 0xE0AD,  CSI_model_code(0xE0AD)                            }, // 0x601A

        { 0xE0AE,  TC_Fluid_Control_model_code(0xE0AE)               }, // 0x601B

        { 0xE0AF,  Rohrback_Cosasco_model_code(0xE0AF)               }, // 0x601C
        { 0xE0B0,  Rohrback_Cosasco_model_code(0xE0B0)               }, // 0x601C
        { 0xE0B1,  Rohrback_Cosasco_model_code(0xE0B1)               }, // 0x601C

        { 0xE0B2,  AirSprite_model_code(0xE0B2)                      }, // 0x601D

        { 0xE0B3,  Microcyber_model_code(0xE0B3)                     }, // 0x601E
        { 0xE0CF,  Microcyber_model_code(0xE0CF)                     }, // 0x601E
        { 0xE0D0,  Microcyber_model_code(0xE0D0)                     }, // 0x601E

        { 0xE0B6,  TIG_model_code(0xE0B6)                            }, // 0x601F
        { 0xE0B7,  TIG_model_code(0xE0B7)                            }, // 0x601F
        { 0xE0B8,  TIG_model_code(0xE0B8)                            }, // 0x601F
        { 0xE0B9,  TIG_model_code(0xE0B9)                            }, // 0x601F
        { 0xE0BA,  TIG_model_code(0xE0BA)                            }, // 0x601F

        { 0xE0BB,  ifm_prover_Gmbh_model_code(0xE0BB)                }, // 0x6020

        { 0xE0BD,  FLEXIM_model_code(0xE0BD)                         }, // 0x6021

        { 0xE0BE,  TOKIMEC_model_code(0xE0BE)                        }, // 0x6022
        { 0xE0BF,  TOKIMEC_model_code(0xE0BF)                        }, // 0x6022

        { 0xE0C0,  SBEM_model_code(0xE0C0)                           }, // 0x6023
        { 0xE0D8,  SBEM_model_code(0xE0D8)                           }, // 0x6023
        { 0xE0D9,  SBEM_model_code(0xE0D9)                           }, // 0x6023

        { 0xE0C1,  SkoFlo_Industries_model_code(0xE0C1)              }, // 0x6024

        { 0xE0C2,  StoneL_Corporation_model_code(0xE0C2)             }, // 0x6025

        { 0xE0C3,  EUREKA_FLOW_model_code(0xE0C3)                    }, // 0x6026
        { 0xE0C5,  EUREKA_FLOW_model_code(0xE0C5)                    }, // 0x6026

        { 0xE0C4,  BEKA_associates_model_code(0xE0C4)                }, // 0x6027

        { 0xE0C6,  CAPSTAR_AUTOMATION_model_code(0xE0C6)             }, // 0x6028

        { 0xE0C7,  Pulsar_model_code(0xE0C7)                         }, // 0x6029

        { 0xE0CA,  Elemer_model_code(0xE0CA)                         }, // 0x602A
        { 0xE0CB,  Elemer_model_code(0xE0CB)                         }, // 0x602A
        { 0xE0CC,  Elemer_model_code(0xE0CC)                         }, // 0x602A
        { 0xE0E7,  Elemer_model_code(0xE0E7)                         }, // 0x602A
        { 0xE0E8,  Elemer_model_code(0xE0E8)                         }, // 0x602A

        { 0xE0CD,  Soft_Tech_Group_model_code(0xE0CD)                }, // 0x602B

        { 0xE0D1,  FUJIAN_WIDEPLUS_PRECISION_INSTR_model_code(0xE0D1)}, // 0x602C
        { 0xE0D2,  FUJIAN_WIDEPLUS_PRECISION_INSTR_model_code(0xE0D2)}, // 0x602C

        { 0xE0D3,  ENOTEC_GmbH_model_code(0xE0D3)                    }, // 0x602D
        { 0xE0D4,  ENOTEC_GmbH_model_code(0xE0D4)                    }, // 0x602D

        { 0xE0D5,  Val_Controls_AS_model_code(0xE0D5)                }, // 0x602E
        { 0xE0D6,  Val_Controls_AS_model_code(0xE0D6)                }, // 0x602E

        { 0xE0D7,  Kurz_Instruments_model_code(0xE0D7)               }, // 0x602F

        { 0xE0DB,  E_Senza_Technologies_model_code(0xE0DB)           }, // 0x6030

        { 0xE0DC,  Crowcon_model_code(0xE0DC)                        }, // 0x6031
        { 0xE0DD,  Crowcon_model_code(0xE0DD)                        }, // 0x6031

        { 0xE0DE,  GEORGIN_model_code(0xE0DE)                        }, // 0x6032

        { 0xE0E0,  Eldridge_Products_model_code(0xE0E0)              }, // 0x6033

        { 0xE0E1,  DDTOP_model_code(0xE0E1)                          }, // 0x6034

        { 0xE0E2,  KSR_Kuebler_model_code(0xE0E2)                    }, // 0x6035

        { 0xE0E3,  Armstrong_Intl_model_code(0xE0E3)                 }, // 0x6036
        { 0xE0E4,  Armstrong_Intl_model_code(0xE0E4)                 }, // 0x6036
        { 0xE0E5,  Armstrong_Intl_model_code(0xE0E5)                 }, // 0x6036

        { 0xE0E6,  Hitachi_High_Tech_model_code(0xE0E6)              }, // 0x6037

        { 0xE0E9,  AMFLOW_model_code(0xE0E9)                         }, // 0x6038

        { 0xE0EA,  Fluidwell_model_code(0xE0EA)                      }  // 0x6039
    }
}

ARRAY OF VARIABLE device_types
{
    LABEL  [device_types];
    HELP   [device_types_help];
    ELEMENTS
    {
        0x0000, Standard_model_code;
        0x0003, Ametek_model_code;
        0x000A, Brooks_Instrument_model_code;
        0x000D, Daniel_Industries_model_code;
        0x000E, Delta_model_code;
        0x0011, Endress_Hauser_model_code;
        0x0012, Fischer_Porter_model_code;
        0x0013, Fisher_Controls_model_code;
        0x0014, Foxboro_model_code;
        0x0015, Fuji_model_code;
        0x0016, Hartmann_Braun_model_code;
        0x0017, Honeywell_model_code;
        0x0019, kayray_model_code;
        0x001A, ABB_model_code;
        0x001D, M_System_Co_model_code;
        0x001F, micro_motion_model_code;
        0x0020, Moore_Industries_model_code;
        0x0021, Moore_Products_model_code;
        0x0025, Ronan_model_code;
        0x0026, rosemount_model_code;
        0x0027, Peek_Measurement_model_code;
        0x0028, Actaris_Neptune_model_code;
        0x002A, Siemens_model_code;
        0x002C, Toshiba_model_code;
        0x002E, rosemount_analytical_model_code;
        0x002F, Valmet_Automation_model_code;
        0x0030, Flowserve_model_code;
        0x0032, Viatran_model_code;
        0x0036, Yamatake_model_code;
        0x0037, Yokogawa_model_code;
        0x003B, Solartron_Mobrey_model_code;
        0x003D, Princo_model_code;
        0x003E, Smar_model_code;
        0x003F, Foxboro_Eckardt_model_code;
        0x0040, Measurement_Technology_model_code;
        0x0042, Samson_model_code;
        0x0043, Sparling_Instruments_model_code;
        0x0045, Krohne_model_code;
        0x0047, Druck_model_code;
        0x0049, Elcon_Instruments_model_code;
        0x004D, Westlock_Controls_model_code;
        0x004E, Drexelbrook_model_code;
        0x004F, Saab_Tank_Control_model_code;
        0x0050, KTEK_model_code;
        0x0052, Draeger_model_code;
        0x0054, Meridian_model_code;
        0x0055, BTG_model_code;
        0x0056, Magnetrol_model_code;
        0x0057, Metso_Automation_model_code;
        0x0058, Milltronics_model_code;
        0x005A, Anderson_Instrument_Company_model_code;
        0x005B, Inor_model_code;
        0x005C, Robertshaw_model_code;
        0x005D, PEPPERL_FUCHS_model_code;
        0x005E, Accutech_model_code;
        0x0060, Bourdon_Haenni_model_code;
        0x0061, Knick_model_code;
        0x0062, VEGA_model_code;
        0x0063, MTS_SYS_CORPS_model_code;
        0x0064, Oval_model_code;
        0x0065, Masoneilan_model_code;
        0x0066, Besta_model_code;
        0x0067, Ohmart_model_code;
        0x0068, Harold_Beck_and_Sons_model_code;
        0x006B, Wika_model_code;
        0x006C, Bopp_Reuther_Heinrichs_model_code;
        0x006D, PR_Electronics_model_code;
        0x0071, Apparatebau_Hundsbach_model_code;
        0x0072, Dynisco_model_code;
        0x0074, Direct_Measurement_model_code;
        0x0075, Klay_model_code;
        0x0078, Buerkert_Fluid_Control_Systems_model_code;
        0x007C, GLI_model_code;
        0x007E, Paper_Machine_Components_model_code;
        0x007F, Labom_model_code;
        0x0080, Danfoss_model_code;
        0x0081, Turbo_model_code;
        0x0082, Tokyo_Keiso_model_code;
        0x0083, SMC_model_code;
        0x0084, Status_Instruments_model_code;
        0x0085, Huakong_model_code;
        0x0086, Duon_System_model_code;
        0x0087, Vortek_Instruments_model_code;
        0x0089, Action_Instruments_model_code;
        0x008C, Magtech_model_code;
        0x008D, Rueger_model_code;
        0x008E, Mettler_Toledo_model_code;
        0x008F, Det_Tronics_model_code;
        0x0090, Thermo_MeasureTech_model_code;
        0x0091, Dezurik_model_code;
        0x0092, Phase_Dynamics_model_code;
        0x0093, Welltech_model_code;
        0x0099, Metran_model_code;
        0x009A, Milton_Roy_model_code;
        0x009B, PMV_model_code;
        0x009C, Turck_model_code;
        0x009D, Panametrics_model_code;
        0x009E, Stahl_model_code;
        0x009F, Analytical_Technology_Inc_model_code;
        0x00A0, FINT_model_code;
        0x00A1, BERTHOLD_model_code;
        0x00A2, InterCorr_model_code;
        0x00A6, Fluid_Components_model_code;
        0x00A9, Invensys_model_code;
        0x00AB, Tyco_Valve_Controls_model_code;
        0x00AD, JTec_Associates_model_code;
        0x00AE, Tracerco_model_code;
        0x00B0, Phoenix_Contact_model_code;
        0x00B2, Amer_Level_Instr_model_code;
        0x00B4, YTC_model_code;
        0x00B5, Pyromation_Inc_model_code;
        0x00B6, Satron_Instruments_model_code;
        0x00B9, BD_Sensors_model_code;
        0x00BC, APLISENS_model_code;
        0x00BD, Badger_Meter_model_code;
        0x00BF, GP_50_model_code;
        0x00C0, Kongsberg_Maritime_model_code;
        0x00C1, ASA_SpA_model_code;
        0x00C2, Hengesbach_model_code;
        0x00C3, Lanlian_Instruments_model_code;
        0x00C4, Spectrum_Controls_model_code;
        0x00C5, Kajaani_Process_Measurements_model_code;
        0x00C6, FAFNIR_model_code;
        0x00C7, SICK_model_code;
        0x00CA, Spirax_Sarco_Italy_model_code;
        0x00CC, Tecfluid_SA_model_code;
        0x00CE, Roost_model_code;
        0x00CF, KOSO_model_code;
        0x00D3, HEINRICHS_model_code;
        0x00D4, SIC_model_code;
        0x00D5, HACH_LANGE_model_code;
        0x00DB, Spectrex_model_code;
        0x00DF, General_Monitors_model_code;
        0x00E0, manufacturer_expansion_model_code;
        0x00F9, HCF_model_code;
        0x6000, ExSaf_model_code;
        0x6001, SEOJIN_INSTECH_model_code;
        0x6002, TASI_FLOW_model_code;
        0x6003, Daehan_Control_model_code;
        0x6004, APM_model_code;
        0x6005, ORANGE_INST_UK_model_code;
        0x6006, BARTEC_model_code;
        0x6007, Detcon_model_code;
        0x6008, MSA_model_code;
        0x6009, METROVAL_model_code;
        0x600A, Etalon_Rus_model_code;
        0x600B, JOGLER_model_code;
        0x600C, KSB_model_code;
        0x600D, Richter_CT_model_code;
        0x600E, NET_SAFETY_model_code;
        0x600F, SECanada_model_code;
        0x6010, SUPCON_model_code;
        0x6011, DKK_TOA_model_code;
        0x6012, Dwyer_Instruments_model_code;
        0x6013, FineTek_model_code;
        0x6014, TopWorx_model_code;
        0x6015, HOFFER_FLOW_CNTRLS_model_code;
        0x6016, DUST_NETWORKS_model_code;
        0x6017, Forbes_Marshall_model_code;
        0x6018, All_Measures_Ltd_model_code;
        0x6019, MACTek_model_code;
        0x601A, CSI_model_code;
        0x601B, TC_Fluid_Control_model_code;
        0x601C, Rohrback_Cosasco_model_code;
        0x601D, AirSprite_model_code;
        0x601E, Microcyber_model_code;
        0x601F, TIG_model_code;
        0x6020, ifm_prover_Gmbh_model_code;
        0x6021, FLEXIM_model_code;
        0x6022, TOKIMEC_model_code;
        0x6023, SBEM_model_code;
        0x6024, SkoFlo_Industries_model_code;
        0x6025, StoneL_Corporation_model_code;
        0x6026, EUREKA_FLOW_model_code;
        0x6027, BEKA_associates_model_code;
        0x6028, CAPSTAR_AUTOMATION_model_code;
        0x6029, Pulsar_model_code;
        0x602A, Elemer_model_code;
        0x602B, Soft_Tech_Group_model_code;
        0x602C, FUJIAN_WIDEPLUS_PRECISION_INSTR_model_code;
        0x602D, ENOTEC_GmbH_model_code;
        0x602E, Val_Controls_AS_model_code;
        0x602F, Kurz_Instruments_model_code;
        0x6030, E_Senza_Technologies_model_code;
        0x6031, Crowcon_model_code;
        0x6032, GEORGIN_model_code;
        0x6033, Eldridge_Products_model_code;
        0x6034, DDTOP_model_code;
        0x6035, KSR_Kuebler_model_code;
        0x6036, Armstrong_Intl_model_code;
        0x6037, Hitachi_High_Tech_model_code;
        0x6038, AMFLOW_model_code;
        0x6039, Fluidwell_model_code;
    }
}

/**********************************************************************
 * Table 8. Company (Manufacturer) Identification Codes
 * Note- Manufacturer is an improper word to use, since this set of
 * enumerations may be used in variables that describe the OEM company.
 */
VARIABLE company_identification_code
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0000, [Standard] },
        { 0x0001, [Acromag] },
        { 0x0002, [Allen_Bradley] },
        { 0x0003, [Ametek] },
        { 0x0004, [Analog_Devices] },
        { 0x0005, [ABB] },
        { 0x0006, [Beckman] },
        { 0x0007, [Bell_Microsensor] },
        { 0x0008, [Bourns] },
        { 0x0009, [Bristol_Babcock] },
        { 0x000A, [Brooks_Instrument] },
        { 0x000B, [Chessell] },
        { 0x000C, [Combustion_Engineering] },
        { 0x000D, [Daniel_Industries] },
        { 0x000E, [Delta] },
        { 0x000F, [Dieterich_Standard] },
        { 0x0010, [Dohrmann] },
        { 0x0011, [Endress_and_Hauser] },
        { 0x0012, [ABB] },
        { 0x0013, [Fisher_Controls] },
        { 0x0014, [Foxboro] },
        { 0x0015, [Fuji] },
        { 0x0016, [ABB] },
        { 0x0017, [Honeywell] },
        { 0x0018, [ITT_Barton] },
        { 0x0019, [Thermo_Measure_Tech] },
        { 0x001A, [ABB] },
        { 0x001B, [Leeds_and_Northrup] },
        { 0x001C, [Leslie] },
        { 0x001D, [M_System_Co] },
        { 0x001E, [Measurex] },
        { 0x001F, [Micro_Motion] },
        { 0x0020, [Moore_Industries] },
        { 0x0021, [Prime_Measurement_Products] },
        { 0x0022, [Ohkura_Electric] },
        { 0x0023, [Paine] },
        { 0x0024, [Rochester_Instrument_Systems] },
        { 0x0025, [Ronan] },
        { 0x0026, [Rosemount] },
        { 0x0027, [Peek_Measurement] },
        { 0x0028, [Actaris_Neptune] },
        { 0x0029, [Sensall] },
        { 0x002A, [Siemens] },
        { 0x002B, [Weed] },
        { 0x002C, [Toshiba] },
        { 0x002D, [Transmation] },
        { 0x002E, [Rosemount_Analytical] },
        { 0x002F, [Metso_Automation] },
        { 0x0030, [Flowserve] },
        { 0x0031, [Varec] },
        { 0x0032, [Viatran] },
        { 0x0033, [Delta_Weed] },
        { 0x0034, [Westinghouse] },
        { 0x0035, [Xomox] },
        { 0x0036, [Yamatake] },
        { 0x0037, [Yokogawa] },
        { 0x0038, [Nuovo_Pignone] },
        { 0x0039, [Promac] },
        { 0x003A, [Exac_Corporation] },
        { 0x003B, [Mobrey] },
        { 0x003C, [Acrom_Control_System] },
        { 0x003D, [Princo] },
        { 0x003E, [Smar] },
        { 0x003F, [Foxboro_Eckardt] },
        { 0x0040, [Measurement_Technology] },
        { 0x0041, [Applied_System_Technologies] },
        { 0x0042, [Samson] },
        { 0x0043, [Sparling_Instruments] },
        { 0x0044, [Fireye] },
        { 0x0045, [Krohne] },
        { 0x0046, [Betz_Equipment] },
        { 0x0047, [Druck] },
        { 0x0048, [SOR] },
        { 0x0049, [Elcon_Instruments] },
        { 0x004A, [EMCO] },
        { 0x004B, [Termiflex] },
        { 0x004C, [VAF_Instruments] },
        { 0x004D, [Westlock_Controls] },
        { 0x004E, [Drexelbrook] },
        { 0x004F, [saab_tank_control] },
        { 0x0050, [K_TEK] },
        { 0x0051, [Sensidyne] },
        { 0x0052, [Draeger] },
        { 0x0053, [Raytek] },
        { 0x0054, [Siemens_Milltronics_PI] },
        { 0x0055, [BTG] },
        { 0x0056, [Magnetrol] },
        { 0x0057, [Metso_Automation] },
        { 0x0058, [Siemens_Milltronics_PI] },
        { 0x0059, [HELIOS] },
        { 0x005A, [Anderson_Instrument_Company] },
        { 0x005B, [INOR] },
        { 0x005C, [ROBERTSHAW] },
        { 0x005D, [PEPPERL_FUCHS] },
        { 0x005E, [ACCUTECH] },
        { 0x005F, [Flow_Measurement] },
        { 0x0060, [Bourdon_Haenni] },
        { 0x0061, [Knick] },
        { 0x0062, [VEGA] },
        { 0x0063, [MTS_SYS_CORPS_SENSORS] },
        { 0x0064, [Oval] },
        { 0x0065, [Masoneilan_DRESSER] },
        { 0x0066, [Besta] },
        { 0x0067, [Ohmart] },
        { 0x0068, [Harold_Beck_and_Sons] },
        { 0x0069, [rittmeyer_instrumentation] },
        { 0x006A, [rossel_messtechnik] },
        { 0x006B, [WIKA] },
        { 0x006C, [Bopp_and_Reuther_Messtechnik] },
        { 0x006D, [pr_eletronics] },
        { 0x006E, [jordan_controls] },
        { 0x006F, [valcom] },
        { 0x0070, [us_electric_motors] },
        { 0x0071, [apparatebau_hundsbach] },
        { 0x0072, [Dynisco] },
        { 0x0073, [Spriano] },
        { 0x0074, [Direct_Mesaurement] },
        { 0x0075, [Klay] },
        { 0x0076, [CiDRA_CORP] },
        { 0x0077, [Mmg_Automatiky] },
        { 0x0078, [Buerkert] },
        { 0x0079, [AALIANT_Process_Mgt] },
        { 0x007A, [Pondus] },
        { 0x007B, [Zap] },
        { 0x007C, [GLI] },
        { 0x007D, [FRPT] },
        { 0x007E, [Paper_Machine_Components] },
        { 0x007F, [Labom] },
        { 0x0080, [Danfoss] },
        { 0x0081, [Turbo] },
        { 0x0082, [Tokyo_Keiso] },
        { 0x0083, [SMC] },
        { 0x0084, [Status_Instruments] },
        { 0x0085, [Huakong] },
        { 0x0086, [Duon_System] },
        { 0x0087, [Vortek_Instruments_LLC] },
        { 0x0088, [AG_Crosby] },
        { 0x0089, [Action_Instruments] },
        { 0x008A, [Keystone_Controls] },
        { 0x008B, [Thermo_Electric_Company] },
        { 0x008C, [ISE_Magtech] },
        { 0x008D, [Rueger] },
        { 0x008E, [Mettler_Toledo] },
        { 0x008F, [Det_Tronics] },
        { 0x0090, [Thermo_Measure_Tech] },
        { 0x0091, [DeZURIK] },
        { 0x0092, [Phase_Dynamics] },
        { 0x0093, [WELLTECH_SHANGHAI] },
        { 0x0094, [ENRAF] },
        { 0x0095, [Four_Tech_ASA] },
        { 0x0096, [Brandt_Instrument] },
        { 0x0097, [Nivelco] },
        { 0x0098, [Camille_Bauer] },
        { 0x0099, [Metran] },
        { 0x009A, [Milton_Roy] },
        { 0x009B, [PMV] },
        { 0x009C, [Turck] },
        { 0x009D, [Panametrics] },
        { 0x009E, [Stahl] },
        { 0x009F, [Analytical_Technology_Inc] },
        { 0x00A0, [FINT] },
        { 0x00A1, [BERTHOLD] },
        { 0x00A2, [InterCorr] },
        { 0x00A3, [China_BRICONTE_Co_Ltd] },
        { 0x00A4, [Electron_Machine] },
        { 0x00A5, [Sierra_Instruments] },
        { 0x00A6, [Fluid_Components] },
        { 0x00A7, [Solid_AT] },
        { 0x00A8, [Meriam_Instrument] },
        { 0x00A9, [Invensys] },
        { 0x00AA, [S_Products] },
        { 0x00AB, [Tyco_Valves_Controls] },
        { 0x00AC, [Micro_Matic_Instrument] },
        { 0x00AD, [JTec_Associates] },
        { 0x00AE, [TRACERCO] },
        { 0x00AF, [AGAR] },
        { 0x00B0, [Phoenix_Contact] },
        { 0x00B1, [Andean_Instruments] },
        { 0x00B2, [Amer_Level_Instr] },
        { 0x00B3, [Hawk] },
        { 0x00B4, [YTC] },
        { 0x00B5, [Pyromation_Inc] },
        { 0x00B6, [Satron_Instruments] },
        { 0x00B7, [BIFFI] },
        { 0x00B8, [SAIC] },
        { 0x00B9, [BD_Sensors] },
        { 0x00BA, [Andean_Instruments] },
        { 0x00BB, [Kemotron] },
        { 0x00BC, [APLISENS] },
        { 0x00BD, [Badger_Meter] },
        { 0x00BE, [HIMA] },
        { 0x00BF, [GP_50] },
        { 0x00C0, [Kongsberg_Maritime] },
        { 0x00C1, [ASA] },
        { 0x00C2, [Hengesbach] },
        { 0x00C3, [Lanlian_Instruments] },
        { 0x00C4, [Spectrum_Controls] },
        { 0x00C5, [Kajaani_Process_Measurements] },
        { 0x00C6, [FAFNIR] },
        { 0x00C7, [SICK_MAIHAK] },
        { 0x00C8, [JSP_Nova_Paka] },
        { 0x00C9, [MESACON] },
        { 0x00CA, [Spirax_Sarco_Italy] },
        { 0x00CB, [L_J_TECHNOLOGIES] },
        { 0x00CC, [Tecfluid_SA] },
        { 0x00CD, [Sailsors_Instruments] },
        { 0x00CE, [Roost] },
        { 0x00CF, [KOSO] },
        { 0x00D0, [MJK] },
        { 0x00D1, [GE_Energy] },
        { 0x00D2, [BW_Technologies] },
        { 0x00D3, [HEINRICHS] },
        { 0x00D4, [SIC] },
        { 0x00D5, [HACH_LANGE] },
        { 0x00D6, [Exalon_Instruments] },
        { 0x00D7, [FAURE_HERMAN] },
        { 0x00D8, [STI] },
        { 0x00D9, [Manometr_Kharkiv] },
        { 0x00DA, [Dalian_Instruments] },
        { 0x00DB, [Spectrex] },
        { 0x00DC, [SIPAI_Instruments] },
        { 0x00DD, [Advanced_Flow] },
        { 0x00DE, [Rexa_Koso_America] },
        { 0x00DF, [General_Monitors] },
        { 0x00E0, [Manufacturer_Expansion] },

/* 
 * codes 225-248 are reserved
 */

        { 0x00F9, [HART_Communication_Foundation] },

/* 
 * codes 250-253 are retained for for historical purposes.  they must
 * not be used in a real field device
 */
        { 0x00FA, [not_used] },
        { 0x00FB, [none] },
        { 0x00FC, [unknown] },
        { 0x00FD, [special] },

/* 
 * codes 0x6000 and above are the 16-bit Manufacturer Codes
 */
        { 0x6000, [ExSaf] },
        { 0x6001, [SEOJIN_INSTECH] },
        { 0x6002, [TASI_FLOW] },
        { 0x6003, [Daehan_Control] },
        { 0x6004, [APM] },
        { 0x6005, [ORANGE_INST_UK] },
        { 0x6006, [BARTEC] },
        { 0x6007, [Detcon] },
        { 0x6008, [MSA] },
        { 0x6009, [METROVAL] },
        { 0x600A, [Etalon_Rus] },
        { 0x600B, [JOGLER] },
        { 0x600C, [KSB] },
        { 0x600D, [Richter_CT] },
        { 0x600E, [NET_SAFETY] },
        { 0x600F, [SECanada] },
        { 0x6010, [SUPCON] },
        { 0x6011, [DKK_TOA] },
        { 0x6012, [Dwyer_Instruments] },
        { 0x6013, [FineTek] },
        { 0x6014, [TopWorx] },
        { 0x6015, [HOFFER_FLOW_CNTRLS] },
        { 0x6016, [DUST_NETWORKS] },
        { 0x6017, [Forbes_Marshall] },
        { 0x6018, [All_Measures_Ltd] },
        { 0x6019, [MACTek] },
        { 0x601A, [CSI] },
        { 0x601B, [TC_Fluid_Control] },
        { 0x601C, [Rohrback_Cosasco] },
        { 0x601D, [AirSprite] },
        { 0x601E, [Microcyber] },
        { 0x601F, [TIG] },
        { 0x6020, [ifm_prover_Gmbh] },
        { 0x6021, [FLEXIM] },
        { 0x6022, [TOKIMEC] },
        { 0x6023, [SBEM] },
        { 0x6024, [SkoFlo_Industries] },
        { 0x6025, [StoneL_Corporation] },
        { 0x6026, [EUREKA_FLOW] },
        { 0x6027, [BEKA_associates] },
        { 0x6028, [CAPSTAR_AUTOMATION] },
        { 0x6029, [Pulsar] },
        { 0x602A, [Elemer] },
        { 0x602B, [Soft_Tech_Group] },
        { 0x602C, [FUJIAN_WIDEPLUS_PRECISION_INSTR] },
        { 0x602D, [ENOTEC_GmbH] },
        { 0x602E, [Val_Controls_AS] },
        { 0x602F, [Kurz_Instruments] },
        { 0x6030, [E_Senza_Technologies] },
        { 0x6031, [Crowcon] },
        { 0x6032, [GEORGIN] },
        { 0x6033, [Eldridge_Products] },
        { 0x6034, [DDTOP] },
        { 0x6035, [KSR_Kuebler] },
        { 0x6036, [Armstrong_Intl] },
        { 0x6037, [Hitachi_High_Tech] },
        { 0x6038, [AMFLOW] },
        { 0x6039, [Fluidwell] }
    }
}

/**********************************************************************
 * Table 2. Unit Codes
 */
VARIABLE units_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        /* Design Note: Enumerations 240-249 are reserved for manufacturer
           specific definitions. Therefore, Host applications should not
           display meaningful information for these enumerations unless
           the Host has the Device Description for that specific Field
           Device. Some Host applications have used a string of the
           character '?' for this application (e.g. Pressure:10.5???? */
        /* Design Note: Any enumerations in the range from 250-255
           are 'Reserved' for a single definition if not defined. */
        /* Design Note: Any enumeration not covered by another "Design
           Note" is 'Undefined'. */

/* Temperature */
        { 32,  [degC],      [degrees_celsius_help] },
        { 33,  [degF],      [degrees_fahrenheit_help] },
        { 34,  [degR],      [degrees_rankine_help] },
        { 35,  [Kelvin],    [degrees_kelvin_help] },

/* 
 * Pressure
 *
 *  NOTE: Pressure is ambiguous with respect to absolute or gage
 */
        { 1,   [InH2O],     [inches_of_water_68_degrees_F_help] },
        { 2,   [InHg],      [inches_of_mercury_0_degrees_C_help] },
        { 3,   [FtH2O],     [feet_of_water_68_degrees_F_help] },
        { 4,   [mmH2O],     [millimeters_of_water_68_degrees_F_help] },
        { 5,   [mmHg],      [millimeters_of_mercury_0_degrees_C_help] },
        { 6,   [psi],       [pounds_per_square_inch_help] },
        { 7,   [bar],       [bars_help] },
        { 8,   [mbar],      [millibars_help] },
        { 9,   [g_SqCm],    [grams_per_square_centimeter_help] },
        { 10,  [kg_SqCm],   [kilograms_per_square_centimeter_help] },
        { 11,  [PA],        [pascals_help] },
        { 12,  [kPA],       [kilopascals_help] },
        { 13,  [torr],      [torr_help] },
        { 14,  [ATM],       [atmospheres_help] },
        { 145, [in_H2O_60_degrees_F], [inches_of_water_60_degrees_F_help] },
        { 237, [mega_pascals],      [megapascals_help] },
        { 238, [in_H2O_4_degrees_C],    [inches_of_water_4_degrees_C_help] },
        { 239, [mm_H2O_4_degrees_C],    [millimeters_of_water_4_degrees_C_help] },

/* Volumetric Flow */
        { 15,  [CuFt_min],      [cubic_feet_per_minute_help] },
        { 16,  [gal_min],       [gallons_per_minute_help] },
        { 17,  [l_min],     [liters_per_minute_help] },
        { 18,  [ImpGal_min],    [imperial_gallons_per_minute_help] },
        { 19,  [CuMtr_hr],      [cubic_meter_per_hour_help] },
        { 22,  [gal_s],     [gallons_per_second_help] },
        { 23,  [MillionGal_day],[million_gallons_per_day_help] },
        { 24,  [l_s],       [liters_per_second_help] },
        { 25,  [MilL_day],      [million_liters_per_day_help] },
        { 26,  [CuFt_s],        [cubic_feet_per_second_help] },
        { 27,  [CuFt_day],      [cubic_feet_per_day_help] },
        { 28,  [CuMtr_s],       [cubic_meters_per_second_help] },
        { 29,  [CuMtr_day],     [cubic_meters_per_day_help] },
        { 30,  [ImpGal_hr],     [imperial_gallons_per_hour_help] },
        { 31,  [ImpGal_day],    [imperial_gallons_per_day_help] },
        { 121, [normal_cubic_meter_per_hour], [normal_cubic_meter_per_hour_help] },
        { 122, [normal_liter_per_hour], [normal_liter_per_hour_help] },
        { 123, [standard_cubic_feet_per_minute],[standard_cubic_feet_per_minute_help] },
        { 130, [CuFt_hr],       [cubic_feet_per_hour_help] },
        { 131, [CuMtr_min],     [cubic_meters_per_minute_help] },
        { 132, [bbl_s],     [barrels_per_second_help] },        /* 1 barrel equals 42 U.S. gallons */
        { 133, [bbl_min],       [barrels_per_minute_help] },
        { 134, [bbl_hr],        [barrels_per_hour_help] },
        { 135, [bbl_day],       [barrels_per_day_help] },
        { 136, [gal_hr],        [gallons_per_hour_help] },
        { 137, [ImpGal_s],      [imperial_gallons_per_second_help] },
        { 138, [l_hr],      [liters_per_hour_help] },
        { 235, [gallons_per_day],[gallons_per_day_help] },

/* Velocity */
        { 20,  [ft_s],      [feet_per_second_help] },
        { 21,  [mtr_s],     [meters_per_second_help] },
        { 114, [in_s],      [inches_per_second_help] },
        { 115, [in_min],        [inches_per_minute_help] },
        { 116, [ft_min],        [feet_per_minute_help] },
        { 120, [mtr_hr],        [meters_per_hour_help] },

/* Volume */
        { 40,  [gal],       [gallons_help] },
        { 41,  [liter],     [liters_help] },
        { 42,  [ImpGal],        [imperial_gallons_help] },
        { 43,  [CuMtr],     [cubic_meters_help] },
        { 46,  [bbl],       [barrels_help] },        /* 1 barrel equals 42 U.S. gallons */
        { 110, [bush],      [bushels_help] },
        { 111, [CuYd],      [cubic_yards_help] },
        { 112, [CuFt],      [cubic_feet_help] },
        { 113, [CuIn],      [cubic_inches_help] },
        { 124, [bbl_liq],       [bbl_liq_help] },       /* 1 liquid barrel equals 31.5 U.S. gallons. Note that */
                                                    /* the abbreviation is not from a reference text" */
        { 166, [normal_cubic_meter], [normal_cubic_meter_help] },
        { 167, [normal_liter], [normal_liter_help] },
        { 168, [standard_cubic_feet], [standard_cubic_feet_help] },
        { 236, [hecto_liter],[hectoliters_help] },

/* Length */
        { 44,  [ft],        [feet_help] },
        { 45,  [meter],     [meters_help] },
        { 47,  [in],        [inches_help] },
        { 48,  [cm],        [centimeters_help] },
        { 49,  [mm],        [millimeters_help] },

/* Time */
        { 50,  [min],       [minutes_help] },
        { 51,  [sec],       [seconds_help] },
        { 52,  [hr],        [hours_help] },
        { 53,  [day],       [days_help] },

/* Mass */
        { 60,  [gram],      [grams_help] },
        { 61,  [kg],        [kilograms_help] },
        { 62,  [MetTon],        [metric_tons_help] },
        { 63,  [lb],        [pounds_help] },
        { 64,  [ShTon],     [short_tons_help] },
        { 65,  [LTon],      [long_tons_help] },
        { 125, [ounce],     [ounce_help] },

/* Mass Flow */
        { 70,  [g_s],       [grams_per_second_help] },
        { 71,  [g_min],     [grams_per_minute_help] },
        { 72,  [g_hr],      [grams_per_hour_help] },
        { 73,  [kg_s],      [kilograms_per_second_help] },
        { 74,  [kg_min],        [kilograms_per_minute_help] },
        { 75,  [kg_hr],     [kilograms_per_hour_help] },
        { 76,  [kg_day],        [kilograms_per_day_help] },
        { 77,  [MetTon_min],    [metric_tons_per_minute_help] },
        { 78,  [MetTon_hr],     [metric_tons_per_hour_help] },
        { 79,  [MetTon_day],    [metric_tons_per_day_help] },
        { 80,  [lb_s],      [pounds_per_second_help] },
        { 81,  [lb_min],        [pounds_per_minute_help] },
        { 82,  [lb_hr],     [pounds_per_hour_help] },
        { 83,  [lb_day],        [pounds_per_day_help] },
        { 84,  [ShTon_min],     [short_tons_per_minute_help] },
        { 85,  [ShTon_hr],      [short_tons_per_hour_help] },
        { 86,  [ShTon_day],     [short_tons_per_day_help] },
        { 87,  [LTon_hr],       [long_tons_per_hour_help] },
        { 88,  [LTon_day],      [long_tons_per_day_help] },

/* Mass per Volume */
        { 90,  [SGU],       [specific_gravity_units_help] },
        { 91,  [g_CuCm],        [grams_per_cubic_centimeter_help] },
        { 92,  [kg_CuMtr],      [kilograms_per_cubic_meter_help] },
        { 93,  [lb_gal],        [pounds_per_gallon_help] },
        { 94,  [lb_CuFt],       [pounds_per_cubic_foot_help] },
        { 95,  [g_ml],      [grams_per_milliliter_help] },
        { 96,  [kg_l],      [kilograms_per_liter_help] },
        { 97,  [g_l],       [grams_per_liter_help] },
        { 98,  [lb_CuIn],       [pounds_per_cubic_inch_help] },
        { 99,  [ShTon_CuYd],    [short_tons_per_cubic_yard_help] },
        { 100, [degTwad],       [degrees_twaddell_help] },
        { 102, [degBaum_hv],    [degrees_baume_heavy_help] },
        { 103, [degBaum_lt],    [degrees_baume_light_help] },
        { 104, [degAPI],        [degrees_API_help] },
        { 146, [ug_l],      [ug_l_help] }, /* micrograms per liter */
        { 147, [ug_m3],         [ug_m3_help] }, /* micrograms per cubic meter */

/* Viscosity */
        { 54,  [centi_stokes],  [centistokes_help] },
        { 55,  [cpoise],        [centipoise_help] },

/* Electromagnetic unit of Electric Potential */
        { 36,  [mV],        [millivolts_help] },
        { 58,  [v],         [volts_help] },

/* Electrostatic unit of Current */
        { 39,  [mA],        [milliamperes_help] },

/* Electromagnetic unit of Resistance */
        { 37,  [Ohm],       [ohms_help] },
        {163,  [kOhm],      [kohms_help] },

/* Energy (includes Work) */
        { 69,  [newton_meter], [newton_meter_help] },
        { 89,  [deka_therm], [deka_therm_help] },
        { 126, [foot_pound_force], [foot_pound_force_help] },
        { 128, [kilo_watt_hour], [kilo_watt_hour_help] },
        { 162, [mega_calorie], [mega_calorie_help] },                   /* 1 calorie = 4.184 Joules */
        { 164, [mega_joule], [mega_joule_help] },
        { 165, [british_thermal_unit], [british_thermal_unit_help] },   /* (1.0 BTU=0.2519958kcal) Energy */

/* Power */
        { 127, [kilo_watt], [kilo_watt_help] },
        { 129, [horsepower], [horsepower_help] },
        { 140, [mega_calorie_per_hour], [mega_calorie_per_hour_help] }, /* 1 calorie = 4.184 Joules */
        { 141, [mega_joule_per_hour], [mega_joule_per_hour_help] },
        { 142, [british_thermal_unit_per_hour],                         /* (1.0 BTU=0.2519958kcal) Energy */
                    [british_thermal_unit_per_hour_help] },

/* Radial Velocity */
        { 117,  [deg_s],        [degrees_per_second_help] },
        { 118,  [rev_s],        [revolutions_per_second_help] },
        { 119,  [rpm],      [revolutions_per_minute_help] },

/* Miscellaneous */
        { 38,  [Hz],        [hertz_help] },
        { 56,  [uMho],      [microsiemens_help] },
        { 57,  [Percent],       [percent_help] },
        { 59,  [pH],        [pH_help] },
        { 66,  [mSiemen_cm],    [milli_siemens_per_centimeter_help] },
        { 67,  [uSiemen_cm],    [micro_siemens_per_centimeter_help] },
        { 68,  [newton],    [newton_help] },
        { 101, [degBrix],       [degrees_brix_help] },
        { 105, [Percent_sol_wt],[percent_solids_per_weight_help] },
        { 106, [Percent_sol_vol],[percent_solids_per_volume_help] },
        { 107, [degBall],       [degrees_balling_help] },
        { 108, [proof_vol],     [proof_per_volume_help] },
        { 109, [proof_mass],    [proof_per_mass_help] },
        { 139, [parts_per_million], [parts_per_million_help] },
        { 143, [degrees],   [degrees_help] },
        { 144, [radian],        [radian_help] },     
        { 148, [percent_consistency], [percent_consistency_help] }, /* %Cs */
        { 149, [volume_percent],[volume_percent_help] }, /* Vol% */
        { 150, [percent_StmQual],[percent_steam_quality_help] },
        { 151, [Ftin16]},
         /* APPHELP "There must be 6 digits to the left of the decimal"
                " point of the associated numeric value. The format"
                " of the most significant two of these digits"
                " indicate the number of `feet'. The adjacent two"
                " lesser significant digits are indicate the number"
                " of additional sixteenths (i.e. 16 sixteenths = 1"
                " inch). If the numeric value is in the floating"
                " point format, any digits to the right of the"
                " decimal point are discarded by the host. " */
        { 152, [CuFt_lb],   [cubic_feet_per_pound_help] },
        { 153, [pico_farads],[picofarads_help] },
        { 154, [ml_l],      [ml_l_help] }, /* ml/l */
        { 155, [ul_l],      [ul_l_help] }, /* ul/l */
        { 160, [Percent_plato],[percent_plato_help] },
        { 161, [percent_lel],   [percent_lel_help] },  /* %LEL */
        { 169, [ppb],       [ppb_help] }, /* ppb */

        /* Generic */
        /*   240  Note- Enumeration may be used for manufacturer specific definitions */
        /*   241  Note- Enumeration may be used for manufacturer specific definitions */
        /*   242  Note- Enumeration may be used for manufacturer specific definitions */
        /*   243  Note- Enumeration may be used for manufacturer specific definitions */
        /*   244  Note- Enumeration may be used for manufacturer specific definitions */
        /*   245  Note- Enumeration may be used for manufacturer specific definitions */
        /*   246  Note- Enumeration may be used for manufacturer specific definitions */
        /*   247  Note- Enumeration may be used for manufacturer specific definitions */
        /*   248  Note- Enumeration may be used for manufacturer specific definitions */
        /*   249  Note- Enumeration may be used for manufacturer specific definitions */
        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}

/**********************************************************************
 * Expanded Units code tables
 *
 * this table allows the correct unit code table to be found given
 * the device variable classification code.  This table is not
 * normally used in field deivce DDs.
 */
ARRAY OF VARIABLE units_code_expanded
{
    ELEMENTS
    {
            0x00, units_code;
            0x40, units_code_temperature;       // Temperature
            0x41, units_code_pressure;          // Pressure
            0x42, units_code_volumetric_flow;   // Volumetric Flow
            0x43, units_code_velocity;          // Velocity
            0x44, units_code_volume;            // Volume
            0x45, units_code_length;            // Length 
            0x46, units_code_time;              // Time 
            0x47, units_code_mass;              // Mass 
            0x48, units_code_mass_flow;         // Mass Flow 
            0x49, units_code_mass_per_volume;   // Mass per Volume 
            0x4A, units_code_viscosity;         // Viscosity 
            0x4B, units_code_angular_velocity;  // Angular Velocity 
            0x4D, units_code_energy;            // Energy 
            0x4E, units_code_force;             // Force
            0x4F, units_code_power;             // Power 
            0x50, units_code_frequency;         // Frequency
            0x51, units_code_analytical;        // Analytical
            0x52, units_code_capacitance;       // Capacitance
            0x53, units_code_emf;               // Electromagnetic Force
            0x54, units_code_current;           // Current 
            0x55, units_code_resistance;        // Resistance 
            0x56, units_code_angle;             // Angle
            0x58, units_code_volume_per_volume; // Volume per Volume
            0x59, units_code_volume_per_mass;   // Volume per Mass
            0x5A, units_code_concentration;     // Concentration
            0x60, units_code_acceleration;      // Acceleration
    }
}

/**********************************************************************
 * Table 2.64 (0x40) Temperature 
 */
VARIABLE units_code_temperature
{
    CLASS LOCAL;
    TYPE ENUMERATED 
    {
        { 0x20,  [degC],                  [degrees_celsius_help] },
        { 0x21,  [degF],                  [degrees_fahrenheit_help] },
        { 0x22,  [degR],                  [degrees_rankine_help] },
        { 0x23,  [Kelvin],                [degrees_kelvin_help] }
    }
}

/**********************************************************************
 * Table 2.65 (0x41) Pressure 
 *
 *  NOTE: Pressure is ambiguous with respect to absolute or gage
 */
VARIABLE units_code_pressure
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01,   [InH2O],                [inches_of_water_68_degrees_F_help] },
        { 0x02,   [InHg],                 [inches_of_mercury_0_degrees_C_help] },
        { 0x03,   [FtH2O],                [feet_of_water_68_degrees_F_help] },
        { 0x04,   [mmH2O],                [millimeters_of_water_68_degrees_F_help] },
        { 0x05,   [mmHg],                 [millimeters_of_mercury_0_degrees_C_help] },
        { 0x06,   [psi],                  [pounds_per_square_inch_help] },
        { 0x07,   [bar],                  [bars_help] },
        { 0x08,   [mbar],                 [millibars_help] },
        { 0x09,   [g_SqCm],               [grams_per_square_centimeter_help] },
        { 0x0A,   [kg_SqCm],              [kilograms_per_square_centimeter_help] },
        { 0x0B,   [PA],                   [pascals_help] },
        { 0x0C,   [kPA],                  [kilopascals_help] },
        { 0x0D,   [torr],                 [torr_help] },
        { 0x0E,   [ATM],                  [atmospheres_help] },
        { 0x91,   [in_H2O_60_degrees_F],  [inches_of_water_60_degrees_F_help] },
        { 0xAA,   [cm_H20_4_degrees_C],   [centimeters_of_water_4_degrees_C_help] },
        { 0xAB,   [m_H20_4_degrees_C],    [meters_of_water_4_degrees_C_help] },
        { 0xAC,   [cm_Hg_0_degrees_C],    [centimeters_of_mercury_0_degrees_C_help] },
        { 0xAD,   [lb_SqFt],              [pounds_square_foot_help] },
        { 0xAE,   [hPa],                  [hPa_help] },
        { 0xAF,   [lb_SqIn_abs],          [pounds_square_inch_absolute_help] },
        { 0xB0,   [kg_Sqm],               [kilograms_per_square_meter_help] },
        { 0xB1,   [ft_H20_4_degrees_C],   [feet_of_water_4_degrees_C_help] },
        { 0xB2,   [ft_H2O_60_degrees_F],  [feet_of_water_60_degrees_F_help] },
        { 0xB3,   [m_Hg_0_degrees_C],     [meters_of_mercury_0_degrees_C_help] },
        { 0xED,   [mega_pascals],         [megapascals_help] },
        { 0xEE,   [in_H2O_4_degrees_C],   [inches_of_water_4_degrees_C_help] },
        { 0xEF,   [mm_H2O_4_degrees_C],   [millimeters_of_water_4_degrees_C_help] }
    }
}

/**********************************************************************
 * Table 2.66 (0x42) Volumetric Flow 
 */
VARIABLE units_code_volumetric_flow
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x0F,   [CuFt_min],             [cubic_feet_per_minute_help] },
        { 0x10,   [gal_min],              [gallons_per_minute_help] },
        { 0x11,   [l_min],                [liters_per_minute_help] },
        { 0x12,   [ImpGal_min],           [imperial_gallons_per_minute_help] },
        { 0x13,   [CuMtr_hr],             [cubic_meter_per_hour_help] },
        { 0x16,   [gal_s],                [gallons_per_second_help] },
        { 0x17,   [MillionGal_day],       [million_gallons_per_day_help] },
        { 0x18,   [l_s],                  [liters_per_second_help] },
        { 0x19,   [MilL_day],             [million_liters_per_day_help] },
        { 0x1A,   [CuFt_s],               [cubic_feet_per_second_help] },
        { 0x1B,   [CuFt_day],             [cubic_feet_per_day_help] },
        { 0x1C,   [CuMtr_s],              [cubic_meters_per_second_help] },
        { 0x1D,   [CuMtr_day],            [cubic_meters_per_day_help] },
        { 0x1E,   [ImpGal_hr],            [imperial_gallons_per_hour_help] },
        { 0x1F,   [ImpGal_day],           [imperial_gallons_per_day_help] },
        { 0x79,   [normal_cubic_meter_per_hour], [normal_cubic_meter_per_hour_help] },
        { 0x7A,   [normal_liter_per_hour], [normal_liter_per_hour_help] },
        { 0x7B,   [standard_cubic_feet_per_minute],[standard_cubic_feet_per_minute_help] },
        { 0x82,   [CuFt_hr],              [cubic_feet_per_hour_help] },
        { 0x83,   [CuMtr_min],            [cubic_meters_per_minute_help] },
        { 0x84,   [bbl_s],                [barrels_per_second_help] },     /* 1 barrel equals 42 U.S. gallons */
        { 0x85,   [bbl_min],              [barrels_per_minute_help] },
        { 0x86,   [bbl_hr],               [barrels_per_hour_help] },
        { 0x87,   [bbl_day],              [barrels_per_day_help] },
        { 0x88,   [gal_hr],               [gallons_per_hour_help] },
        { 0x89,   [ImpGal_s],             [imperial_gallons_per_second_help] },
        { 0x8A,   [l_hr],                 [liters_per_hour_help] },
        { 0xAA,   [beer_bbl_s],                    [beer_barrels_per_second_help] },
        { 0xAB,   [beer_bbl_min],                  [beer_barrels_per_minute_help] },
        { 0xAC,   [beer_bbl_hour],                 [beer_barrels_per_hour_help] },
        { 0xAD,   [beer_bbl_day],                  [beer_barrels_per_day_help] },
        { 0xAE,   [normal_liter_per_day],          [normal_liter_per_day_help] },
        { 0xAF,   [normal_liter_per_min],          [normal_liter_per_minute_help] },
        { 0xB0,   [normal_liter_per_s],            [normal_liter_per_second_help] },
        { 0xB1,   [standard_liter_per_day],        [standard_liter_per_day_help] },
        { 0xB2,   [standard_liter_per_hour],       [standard_liter_per_hour_help] },
        { 0xB3,   [standard_liter_per_min],        [standard_liter_per_minute_help] },
        { 0xB4,   [standard_liter_per_s],          [standard_liter_per_second_help] },
        { 0xB5,   [normal_cubic_meter_per_day],    [normal_cubic_meter_per_day_help] },
        { 0xB6,   [normal_cubic_meter_per_min],    [normal_cubic_meter_per_minute_help] },
        { 0xB7,   [normal_cubic_meter_per_s],      [normal_cubic_meter_per_second_help] },
        { 0xB8,   [standard_cubic_feet_per_day],   [standard_cubic_feet_per_day_help] },
        { 0xB9,   [standard_cubic_feet_per_hour],  [standard_cubic_feet_per_hour_help] },
        { 0xBA,   [standard_cubic_feet_per_s],     [standard_cubic_feet_per_second_help] },
        { 0xBB,   [standard_cubic_meter_per_day],  [standard_cubic_meter_per_day_help] },
        { 0xBC,   [standard_cubic_meter_per_hour], [standard_cubic_meter_per_hour_help] },
        { 0xBD,   [standard_cubic_meter_per_min],  [standard_cubic_meter_per_minute_help] },
        { 0xBE,   [standard_cubic_meter_per_s],    [standard_cubic_meter_per_second_help] },
        { 0xEB,   [gallons_per_day],               [gallons_per_day_help] }
    }
}

/**********************************************************************
 * Table 2.67 (0x43) Velocity 
 */
VARIABLE units_code_velocity
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x14,   [ft_s],                 [feet_per_second_help] },
        { 0x15,   [mtr_s],                [meters_per_second_help] },
        { 0x72,   [in_s],                 [inches_per_second_help] },
        { 0x73,   [in_min],               [inches_per_minute_help] },
        { 0x74,   [ft_min],               [feet_per_minute_help] },
        { 0x78,   [mtr_hr],               [meters_per_hour_help] }
    }
}

/**********************************************************************
 * Table 2.68 (0x44) Volume 
 */
VARIABLE units_code_volume
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x28,   [gal],                  [gallons_help] },
        { 0x29,   [liter],                [liters_help] },
        { 0x2A,   [ImpGal],               [imperial_gallons_help] },
        { 0x2B,   [CuMtr],                [cubic_meters_help] },
        { 0x2E,   [bbl],                  [barrels_help] },
        { 0x6E,   [bush],                 [bushels_help] },
        { 0x6F,   [CuYd],                 [cubic_yards_help] },
        { 0x70,   [CuFt],                 [cubic_feet_help] },
        { 0x71,   [CuIn],                 [cubic_inches_help] },
        { 0x7C,   [bbl_liq],              [bbl_liq_help] },
        { 0xA6,   [normal_cubic_meter],   [normal_cubic_meter_help] },
        { 0xA7,   [normal_liter],         [normal_liter_help] },
        { 0xA8,   [standard_cubic_feet],  [standard_cubic_feet_help] },
        { 0xAA,   [beer_bbl],             [beer_bbl_help] },
        { 0xAB,   [standard_liter],       [standard_liter_help] },
        { 0xAC,   [standard_cubic_meter], [standard_cubic_meter_help] },
        { 0xEC,   [hecto_liter],          [hectoliters_help] }
    }
}

/**********************************************************************
 * Table 2.69 (0x45) Length 
 */                  
VARIABLE units_code_length
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x2C,   [ft],                   [feet_help] },
        { 0x2D,   [meter],                [meters_help] },
        { 0x2F,   [in],                   [inches_help] },
        { 0x30,   [cm],                   [centimeters_help] },
        { 0x31,   [mm],                   [millimeters_help] },
        { 0x97,   [Ftin16]}
    }
}

/**********************************************************************
 * Table 2.70 (0x46) Time 
 */
VARIABLE units_code_time
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x32,   [min],                  [minutes_help] },
        { 0x33,   [sec],                  [seconds_help] },
        { 0x34,   [hr],                   [hours_help] },
        { 0x35,   [day],                  [days_help] }
    }
}

/***********************************************************************
 * Table 2.71 (0x47) Mass 
 */
VARIABLE units_code_mass
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x3C,   [gram],                 [grams_help] },
        { 0x3D,   [kg],                   [kilograms_help] },
        { 0x3E,   [MetTon],               [metric_tons_help] },
        { 0x3F,   [lb],                   [pounds_help] },
        { 0x40,   [ShTon],                [short_tons_help] },
        { 0x41,   [LTon],                 [long_tons_help] },
        { 0x7D,   [ounce],                [ounce_help] }
    }
}

/***********************************************************************
 * Table 2.72 (0x48) Mass Flow 
 */
VARIABLE units_code_mass_flow
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x46,   [g_s],                  [grams_per_second_help] },
        { 0x47,   [g_min],                [grams_per_minute_help] },
        { 0x48,   [g_hr],                 [grams_per_hour_help] },
        { 0x49,   [kg_s],                 [kilograms_per_second_help] },
        { 0x4A,   [kg_min],               [kilograms_per_minute_help] },
        { 0x4B,   [kg_hr],                [kilograms_per_hour_help] },
        { 0x4C,   [kg_day],               [kilograms_per_day_help] },
        { 0x4D,   [MetTon_min],           [metric_tons_per_minute_help] },
        { 0x4E,   [MetTon_hr],            [metric_tons_per_hour_help] },
        { 0x4F,   [MetTon_day],           [metric_tons_per_day_help] },
        { 0x50,   [lb_s],                 [pounds_per_second_help] },
        { 0x51,   [lb_min],               [pounds_per_minute_help] },
        { 0x52,   [lb_hr],                [pounds_per_hour_help] },
        { 0x53,   [lb_day],               [pounds_per_day_help] },
        { 0x54,   [ShTon_min],            [short_tons_per_minute_help] },
        { 0x55,   [ShTon_hr],             [short_tons_per_hour_help] },
        { 0x56,   [ShTon_day],            [short_tons_per_day_help] },
        { 0x57,   [LTon_hr],              [long_tons_per_hour_help] },
        { 0x58,   [LTon_day],             [long_tons_per_day_help] }
    }
}

/***********************************************************************
 * Table 2.73 (0x49) Mass per Volume 
 */
VARIABLE units_code_mass_per_volume
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x5A,   [SGU],                  [specific_gravity_units_help] },
        { 0x5B,   [g_CuCm],               [grams_per_cubic_centimeter_help] },
        { 0x5C,   [kg_CuMtr],             [kilograms_per_cubic_meter_help] },
        { 0x5D,   [lb_gal],               [pounds_per_gallon_help] },
        { 0x5E,   [lb_CuFt],              [pounds_per_cubic_foot_help] },
        { 0x5F,   [g_ml],                 [grams_per_milliliter_help] },
        { 0x60,   [kg_l],                 [kilograms_per_liter_help] },
        { 0x61,   [g_l],                  [grams_per_liter_help] },
        { 0x62,   [lb_CuIn],              [pounds_per_cubic_inch_help] },
        { 0x63,   [ShTon_CuYd],           [short_tons_per_cubic_yard_help] },
        { 0x64,   [degTwad],              [degrees_twaddell_help] },
        { 0x66,   [degBaum_hv],           [degrees_baume_heavy_help] },
        { 0x67,   [degBaum_lt],           [degrees_baume_light_help] },
        { 0x68,   [degAPI],               [degrees_API_help] },
        { 0x92,   [ug_l],                 [ug_l_help] },
        { 0x93,   [ug_m3],                [ug_m3_help] },
        { 0x94,   [percent_consistency],  [percent_consistency_help] },
        { 0xAA,   [mg_l],                 [mg_l_help] }
    }
}

/***********************************************************************
 * Table 2.74 (0x4A) Viscosity 
 */
VARIABLE units_code_viscosity
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x36,   [centi_stokes],         [centistokes_help] },
        { 0x37,   [cpoise],               [centipoise_help] }
    }
}

/***********************************************************************
 * Table 2.75 (0x4B) Angular Velocity 
 */
VARIABLE units_code_angular_velocity
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x75,   [deg_s],                [degrees_per_second_help] },
        { 0x76,   [rev_s],                [revolutions_per_second_help] },
        { 0x77,   [rpm],                  [revolutions_per_minute_help] }
    }
}

/***********************************************************************
 * Table 2.76 (0x4C) Area
 */

/***********************************************************************
 * Table 2.77 (0x4D) Energy (includes Work) 
 */
VARIABLE units_code_energy
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x45,   [newton_meter],         [newton_meter_help] },
        { 0x59,   [deka_therm],           [deka_therm_help] },
        { 0x7E,   [foot_pound_force],     [foot_pound_force_help] },
        { 0x80,   [kilo_watt_hour],       [kilo_watt_hour_help] },
        { 0xA2,   [mega_calorie],         [mega_calorie_help] },
        { 0xA4,   [mega_joule],           [mega_joule_help] },
        { 0xA5,   [british_thermal_unit], [british_thermal_unit_help] }
    }
}

/***********************************************************************
 * Table 2.78 (0x4E) Force
 */
VARIABLE units_code_force
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x44,   [newton],               [newton_help] }
    }
}

/***********************************************************************
 * Table 2.79 (0x4F) Power 
 */
VARIABLE units_code_power
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x7F,   [kilo_watt],            [kilo_watt_help] },
        { 0x81,   [horsepower],           [horsepower_help] },
        { 0x8C,   [mega_calorie_per_hour],[mega_calorie_per_hour_help] },
        { 0x8D,   [mega_joule_per_hour],  [mega_joule_per_hour_help] },
        { 0x8E,   [british_thermal_unit_per_hour],
                             [british_thermal_unit_per_hour_help] }    
    }
}

/***********************************************************************
 * Table 2.80 (0x50) Frequency
 */
VARIABLE units_code_frequency
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x26,   [Hz],                   [hertz_help] }
    }
}


/***********************************************************************
 * Table 2.81 (0x51) Analytical
 */
VARIABLE units_code_analytical
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x39,   [Percent],              [percent_help] },
        { 0x3B,   [pH],                   [pH_help] },
        { 0x96,   [percent_StmQual],      [percent_steam_quality_help] },
        { 0xA0,   [Percent_plato],        [percent_plato_help] },
        { 0xA1,   [percent_lel],          [percent_lel_help] }
    }
}

/***********************************************************************
 * Table 2.82 (0x52) Capacitance
 */
VARIABLE units_code_capacitance
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x99,   [pico_farads],          [picofarads_help] }
    }
}

/***********************************************************************
 * Table 2.83 (0x53) Electromagnetic Force (EMF)
 */
VARIABLE units_code_emf
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x24,   [mV],                   [millivolts_help] },
        { 0x3A,   [v],                    [volts_help] }
    }
}

/***********************************************************************
 * Table 2.84 (0x54) Current 
 */
VARIABLE units_code_current
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x27,   [mA],                   [milliamperes_help] }
    }
}

/***********************************************************************
 * Table 2.85 (0x55) Resistance 
 */
VARIABLE units_code_resistance
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x25,   [Ohm],                  [ohms_help] },
        { 0xA3,   [kOhm],                 [kohms_help] },
        { 0xAA,   [mega_ohm],             [mega_ohm_help] },
        { 0xAB,   [OhmCm],                [ohm_centimeter_help] },
        { 0xAC,   [kOhmCm],               [kilo_ohm_centimeter_help] },
        { 0xAD,   [mega_ohmCm],           [mega_ohm_centimeter_help] }
    }
}

/***********************************************************************
 * Table 2.86 (0x56) Angle
 */
VARIABLE units_code_angle
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x8F,   [degrees],              [degrees_help] },
        { 0x90,   [radian],               [radian_help] }     
    }
}

/***********************************************************************
 * Table 2.87 (0x57) Conductance
 */
VARIABLE units_code_conductance
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x38,   [uMho],                 [microsiemens_help] },
        { 0x42,   [mSiemen_cm],           [milli_siemens_per_centimeter_help] },
        { 0x43,   [uSiemen_cm],           [micro_siemens_per_centimeter_help] }
    }
}

/***********************************************************************
 * Table 2.88 (0x58) Volume per Volume
 */

VARIABLE units_code_volume_per_volume
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x95,   [volume_percent],       [volume_percent_help] },
        { 0x9A,   [ml_l],                 [ml_l_help] },
        { 0x9B,   [ul_l],                 [ul_l_help] }
    }
}

/***********************************************************************
 * Table 2.89 (0x59) Volume per Mass
 */
 VARIABLE units_code_volume_per_mass
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x6B,   [degBall],              [degrees_balling_help] },
        { 0x98,   [CuFt_lb],              [cubic_feet_per_pound_help] }
    }
}

/***********************************************************************
 * Table 2.90 (0x5A) Concentration
 */
VARIABLE units_code_concentration
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x65,   [degBrix],              [degrees_brix_help] },
        { 0x69,   [Percent_sol_wt],       [percent_solids_per_weight_help] },
        { 0x6A,   [Percent_sol_vol],      [percent_solids_per_volume_help] },
        { 0x6C,   [proof_vol],            [proof_per_volume_help] },
        { 0x6D,   [proof_mass],           [proof_per_mass_help] },
        { 0x8B,   [parts_per_million],    [parts_per_million_help] },
        { 0xA9,   [ppb],                  [ppb_help] },
        { 0xAA,   [ppth],                 [ppth_help] }
    }
}

/***********************************************************************
 * Table 2.91 (0x5B) Valve Actuator
 */

/***********************************************************************
 * Table 2.92 (0x5C) Level
 */

/***********************************************************************
 * Table 2.93 (0x5D) Vortex Flow
 */

/***********************************************************************
 * Table 2.94 (0x5E) Mag Flow
 */

/***********************************************************************
 * Table 2.95 (0x5F) Coriolis Flow
 */

/***********************************************************************
 * Table 2.96 (0x60) Acceleration
 */
VARIABLE units_code_acceleration
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0xAA,   [g],                    [g_help] },
        { 0xAB,   [ft_Sqs],               [feet_per_square_second_help] },
        { 0xAC,   [m_Sqs],                [meters_per_square_second_help] }
    }
}

/**********************************************************************
 * Table 3. Transfer Function Codes
 */
VARIABLE transfer_function_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
       /* Design Note: Enumerations 240-249 are reserved for manufacturer
          specific definitions. Therefore, Host applications should not
          display meaningful information for these enumerations unless
          the Host has the Device Description for that specific Field
          Device. Some Host applications have used a string of the
          character '?' for this application (e.g. Xfer fnctn:???? */
       /* Design Note: Any enumerations in the range from 250-255
          are 'Reserved' for a single definition if not defined. */
       /* Design Note: Any enumeration not covered by another "Design
          Note" is 'Undefined'. */

        { 0,   [linear],     [linear_help] },
         /* APPHELP "Equation y=mx+b" */
        { 1,   [square_root],[square_root_help] },
         /* APPHELP "Equation y=sqrt(x)" */
        { 2,   [square_root_to_the_third_power_sup], [square_root_third_power_help] },
         /* APPHELP "Equation y=sqrt(x^3)" */
        { 3,   [square_root_to_the_fifth_power_sup], [square_root_fifth_power_help] },
         /* APPHELP "Equation y=sqrt(x^5)" */
        { 4,   [special_curve],[special_curve_help] },
        { 5,   [square],[square_help] },
         /* APPHELP "Equation y=x^2" */
        { 230, [discrete_switch],[discrete_switch_help] },  /* Discrete (switch) */
        { 231, [square_root_plus_special_curve],[square_root_plus_special_curve_help] },
         /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 231 NOT BE"
                "USED IN NEW IMPLEMENTATIONS !" */
        { 232, [square_root_to_the_third_power_plus_special_curve],[square_root_third_power_plus_special_curve_help] },
         /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 232 NOT BE"
                "USED IN NEW IMPLEMENTATIONS !" */
        { 233, [square_root_to_the_fifth_power_plus_special_curve],[square_root_fifth_power_plus_special_curve_help] },
         /* APPHELP "THE HCF RECOMMENDS THAT ENUMERATION 233 NOT BE"
                "USED IN NEW IMPLEMENTATIONS !" */
/*   240  Note- Enumeration may be used for manufacturer specific definitions */
/*   241  Note- Enumeration may be used for manufacturer specific definitions */
/*   242  Note- Enumeration may be used for manufacturer specific definitions */
/*   243  Note- Enumeration may be used for manufacturer specific definitions */
/*   244  Note- Enumeration may be used for manufacturer specific definitions */
/*   245  Note- Enumeration may be used for manufacturer specific definitions */
/*   246  Note- Enumeration may be used for manufacturer specific definitions */
/*   247  Note- Enumeration may be used for manufacturer specific definitions */
/*   248  Note- Enumeration may be used for manufacturer specific definitions */
/*   249  Note- Enumeration may be used for manufacturer specific definitions */
        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}

/**********************************************************************
 * Table 4. Material Codes
 */
VARIABLE material_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        /* Design Note: The materials in this table should be
           solids at 72 Degrees Fahrenheit. */
        /* Design Note: Leave 240-249 Undefined for future use. */
        /* Design Note: Any enumerations in the range from 250-255
           are 'Reserved' for a single definition if not defined. */
        /* Design Note: Any enumeration not covered by another "Design
           Note" is 'Undefined'. */
        /* Note:
           Ryton is a registered trademark of Phillips Petroleum Company.
           Kynar is a trademark of Pennwalt Incorporated.
           Hastelloy C is a trademark of Cabot Corporation.
           Teflon and Kalrez are registered trademarks of E. I. DuPont De
           Nemours Company.
           Inconel is a trademark of International Nickel Company. */

        { 0,   [carbon_steel],        [carbon_steel_help] },
        { 1,   [stainless_steel_304], [stainless_steel_304_help] },
        { 2,   [stainless_steel_316], [stainless_steel_316_help] },
        { 3,   [hastelloy_c],         [hastelloy_c_help] },
        { 4,   [monel],           [monel_help] },
        { 5,   [tantalum],        [tantalum_help] },
        { 6,   [titanium],        [titanium_help] },
        { 7,   [pt_ir],           [platinum_iridium_help] },
        { 8,   [alloy_20],        [alloy_20_help] },
        { 9,   [co_cr_ni],        [cobalt_chromium_nickel_help] },
        { 10,  [ptfe],            [ptfe_teflon_help] },
        { 11,  [vito],            [viton_help] },
        { 12,  [buna_n],          [buna_n_help] },
        { 13,  [ethyl_prop],      [ethyl_prop_help] },
        { 14,  [urethane],        [urethane_help] },
        { 15,  [gold_monel],          [gold_monel_help] },
        { 16,  [tefzel],          [tefzel_help] },
        { 17,  [ryton],           [ryton_help] },
        { 18,  [ceramic],         [ceramic_help] },
        { 19,  [stainless_steel_316l_sup],[stainless_steel_316l_help] },
        { 20,  [pvc],             [pvc_help] },
        { 21,  [nitrile_rubber],      [nitrile_rubber_help] },
        { 22,  [kalrez],          [kalrez_help] },
        { 23,  [inconel],         [inconel_help] },
        { 24,  [kynar],           [kynar_help] },
        { 25,  [aluminium],       [aluminum_help] },
        { 26,  [nickel],          [nickel_help] },
        { 27,  [fep],             [fep_help] },
         /* APPHELP "Typically a sealing material for O-Ring" */
        { 28,  [stainless_steel_316_ti], [stainless_steel_316_ti_help] },
        { 30,  [hastelloy_c276],      [hastelloy_c_276_help] },
        { 31,  [klinger_c4401],   [klinger_c4401_help]},
        { 32,  [thermotork],      [thermotork_help]},
        { 33,  [grafoil],         [grafoil_help]},
        { 34,  [ptfe_coated_316l_sst], [ptfe_coated_316l_sst_help]},
        { 35,  [gold_plated_hastelloy_c276], [gold_plated_hastelloy_c276_help]},
        { 36,  [ptfe_glass],      [ptfe_glass_help]},
        { 37,  [ptfe_graphite],   [ptfe_graphite_help]},
        { 38,  [aflas], [aflas_help] }, /* Aflas */
        { 234, [PTFE_hastelloy],      [PTFE_hastelloy_help] },
        { 235, [stainless_steel_CF_8M],       [stainless_steel_CF_8M_help] },
        { 236, [hastelloy_sst],       [hastelloy_sst_help] },
        { 237, [gold_plated_sst],         [gold_plated_sst_help] },
        { 239, [monel_400],       [monel_400_help] },
        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}

/**********************************************************************
 * Table 5. NULL
 */


/**********************************************************************
 * Table 6. Alarm Selection Codes
 */
VARIABLE alarm_selection_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        /* Design Note: These apply to the alarm state of the 
           physical output of an Analog Output */
        /* Design Note: Leave 240-249 Undefined for future use. */
        /* Design Note: Any enumerations in the range from 250-255
           are 'Reserved' for a single definition if not defined. */
        /* Design Note: Any enumeration not covered by another "Design
           Note" is 'Undefined'. */

        { 0,   [high],      [high_help] },
        { 1,   [low],   [low_help] },
        { 239, [hold_last_output_value], [hold_last_output_value_help] },
        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}

/**********************************************************************
 * Tables 7. Write Protect Codes
 */
VARIABLE write_protect_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        /* Design Note: Leave 240-249 Undefined for future use. */
        /* Design Note: Any enumerations in the range from 250-255
           are 'Reserved' for a single definition if not defined. */
        /* Design Note: Any enumeration not covered by another "Design
           Note" is 'Undefined'. */

        { 0,   [no], [not_write_protected] },
        { 1,   [yes], [write_protected] },

        { 250, [not_used] },
        { 251, [none] },
        { 252, [unknown] },
        { 253, [special] }
    }
}

/**********************************************************************
 * Tables 9. Burst Mode Control Codes
 */
VARIABLE burst_mode_control_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0,   [off] },
        { 1,   "Enable on token-passing data link layer only" },            // Standard dictionary
        { 2,   "Enable on TDMA data link layer only" },                     // Standard dictionary
        { 3,   "Enable on both TDMA and token-passing data link layer" },   // Standard dictionary

        { 250, [reserved] },
        { 251, [reserved] },
        { 252, [reserved] },
        { 253, [reserved] }
    }
}

/**********************************************************************
 * Tables 10. Physical Signaling Codes
 */
VARIABLE physical_signaling_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        /* Design Note: Enumeration 7 is 'Reserved',
           potentially for an expansion indication. */
        /* Design Note: Any enumerations in the range from 8-255
           are not allowable. */

        { 0, [bell_202_current] },
        { 1, [bell_202_voltage] },
        { 2, [rs_485] },
        { 3, [rs_232], [rs_232_help] },
        { 4, "Wireless", "WirelessHART Device" },    //Standard dictionary
        { 6, [special] }
    }
}

/**********************************************************************
 * Tables 11. Flag Assignments
 */
VARIABLE flag_assignment
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, [Multisens_Dev], [multi_sensor_fld_dev] },
        { 0x02, [EEPROM_Ctrl] },
        { 0x04, [protocol_bridge_device] },
        { 0x08, "IEEE 802.15.4 2.4GHz DSSS with O-QPSK Modulation" },   //Standard dictionary

        { 0x40, [psk_capable_device] },
        { 0x80, [psk_loop_current_disabled] }
    }
}

/**********************************************************************
 * Tables 12. Transfer Service Function Codes
 * (see Block Data Tranfer Specification)
 */

/**********************************************************************
 * Tables 13. Transfer Service Identifier Codes
 * (see Block Data Tranfer Specification)
 */

/**********************************************************************
 * Tables 14. Operating Mode Codes
 * (This Table is Reserved.  Field Devices must always return zero)
 */
VARIABLE operating_mode_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0,   [reserved] },
        { 250, [reserved] },
        { 251, [reserved] },
        { 252, [reserved] },
        { 253, [reserved] }
    }
}

/**********************************************************************
 * Tables 15. Analog Output Numbers Codes
 */
VARIABLE analog_output_numbers_code
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Primary",    "Primary Analog Channel" }, 
        { 1, "Secondary",  "Secondary Analog Channel" }, 
        { 2, "Tertiary",   "Tertiary Analog Channel" }, 
        { 3, "Quaternary", "Quaternary Analog Channel" }, 
        { 4, "Quinary",    "Quinary Analog Channel" } 
    }
}

/**********************************************************************
 * Tables 16. Loop Current Mode Codes;
 */
VARIABLE loop_current_mode_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED 
    {
        { 0, [disabled_loop_current_mode] },  
        { 1, [enabled_loop_current_mode] }
    }
}

/**********************************************************************
 * Tables 17. Extended Device Status Codes";
 */
VARIABLE extended_device_status_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, [maintenance_required] },
        { 0x02, [device_variable_alert] },
        { 0x04, "Critical Power Failure" }                  //Standard dictionary
    }
}

/**********************************************************************
 * Tables 18  Lock Device Codes
 */
VARIABLE lock_device_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [unlock] },  
        { 1, [temporary_lock] },  
        { 2, [permanent_lock] },
        { 3, "Lock all" }
    }
}

/**********************************************************************
 * Tables 19 Write Device Variable Codes
 */
VARIABLE write_device_variable_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [normal_device_variable] },  
        { 1, [fix_value] }
    }
}

/**********************************************************************
 * Tables 20 Device Variable Family Codes
 */
VARIABLE device_variable_family_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        
        /* codes 0-3 are reserved and must never be used */
        
        { 4,  [temperature_family] },  
        { 5,  [pressure_family] },  
        { 6,  [actuator_family] },  
        { 7,  [simple_pid_family] },
        { 8,  [ph_family] },
        { 9,  [conductivity_family] },
        { 10, [totalizer_family] },
        { 11, [level_family] },            
        { 12, [vortex_flow_family] },
        { 13, [mag_flow_family] },
        { 14, [coriolis_flow_family] }

        /* codes 132-249 are reserved and must never be used */

        { 250, [not_used] }
    }
}

/**********************************************************************
 * Tables 21 Device Variable Classification Codes
 */
VARIABLE device_variable_classification_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0,  [device_variable_not_classified] },     

        { 64, [temperature_classification] },       /* 0x40 */
        { 65, [pressure_classification] },          /* 0x41 */
        { 66, [volumetric_flow_classification] },   /* 0x42 */
        { 67, [velocity_classification] },          /* 0x43 */
        { 68, [volume_classification] },            /* 0x44 */
        { 69, [length_classification] },            /* 0x45 */
        { 70, [time_classification] },              /* 0x46 */
        { 71, [mass_classification] },              /* 0x47 */
        { 72, [mass_flow_classification] },         /* 0x48 */
        { 73, [mass_per_volume_classification] },   /* 0x49 */
        { 74, [viscosity_classification] },         /* 0x4A */
        { 75, [angular_velocity_classification] },  /* 0x4B */
        { 76, [area_classification] },              /* 0x4C */
        { 77, [energy_work_classification] },       /* 0x4D */
        { 78, [force_classification] },             /* 0x4E */
        { 79, [power_classification] },             /* 0x4F */
        { 80, [frequency_classification] },         /* 0x50 */
        { 81, [analytical_classification] },        /* 0x51 */
        { 82, [capacitance_classification] },       /* 0x52 */
        { 83, [emf_classification] },               /* 0x53 */
        { 84, [current_classification] },           /* 0x54 */
        { 85, [resistance_classification] },        /* 0x55 */
        { 86, [angle_classification] },             /* 0x56 */
        { 87, [conductance_classification] },       /* 0x57 */
        { 88, [volume_per_volume_classification] }, /* 0x58 */
        { 89, [volume_per_mass_classification] },   /* 0x59 */
        { 90, [concentration_classification] },     /* 0x5A */
        { 91, [valve_actuator_classification] },    /* 0x5B */
        { 92, [level_classification] },             /* 0x5C */
        { 93, [vortex_flow_classification] },       /* 0x5D */
        { 94, [mag_flow_classification] },          /* 0x5E */
        { 95, [coriolis_flow_classification] },     /* 0x5F */
        { 96, [acceleration_classification] }       /* 0x60 */
    }
}

/**********************************************************************
 * Tables 22 Trim Point Codes
 */
VARIABLE trim_point_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Trim not supported" },
        { 1, [lower_trim_point_supported] },  
        { 2, [upper_trim_point_supported] },  
        { 3, [lower_and_upper_trim_point_supported] }
    }
}

/**********************************************************************
 * Tables 23 Capture Mode Codes
 */
VARIABLE capture_mode_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [disabled_capture] },  
        { 1, [enabled_capture_from_specified_field_device] },
        { 2, [enabled_capture_from_back_messages] }
    }
}

/**********************************************************************
 * Tables 24 Physical Layer Type Codes
 */
VARIABLE physical_layer_type_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [asynchronous_fsk] },  
        { 1, [synchronous_psk] }

        /* 3 is reserved */
    }
}

/**********************************************************************
 * Tables 25 Lock Device Status Codes
 */
VARIABLE lock_device_status_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, [device_is_locked] },
        { 0x02, [lock_is_permanent] },
        { 0x04, [locked_by_primary_master] },
        { 0x08, "Configuration cannot be changed" },
        { 0x10, "Locked by gateway" }
    }
}

/**********************************************************************
 * Tables 26 Analog Channel Flags
 */
VARIABLE analog_channel_flags
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x00, "Analog Input Channel" }
        { 0x01, "Analog Output Channel" }
    }
}

/*****************************************************************************
 * Tables 27 Analog Channel Saturated Codes
 *
 * this variable is an extension of Bit #2 of the Device Status byte and
 * indicate any additional auxilliary analog channels that are Saturated
 */

VARIABLE analog_channel_saturated_codes    // see table 15, 28
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, "Secondary Analog Channel Saturated" }, 
        { 0x02, "Tertiary Analog Channel Saturated" }, 
        { 0x04, "Quaternary Analog Channel Saturated" }, 
        { 0x08, "Quinary Analog Channel Saturated" } 
    }
}

/*****************************************************************************
 * Tables 28  Analog Channel Fixed Codes
 *
 * this variable is an extension of Bit #3 of the Device Status byte and
 * indicate any additional auxilliary analog channels that are fixed
 */

VARIABLE analog_channel_fixed_codes     // see table 15, 27
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, "Secondary Analog Channel Fixed" }, 
        { 0x02, "Tertiary Analog Channel Fixed" }, 
        { 0x04, "Quaternary Analog Channel Fixed" }, 
        { 0x08, "Quinary Analog Channel Fixed" } 
    }
}


/**********************************************************************
 * Tables 29 Standardized Status 0 Codes
 */
VARIABLE standardized_status_0_codes        //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED //Note:  All tables are described using ENUMERATED even though they will be used in actual DD as a BIT_ENUMERATED
    {
        { 0x01, "Simulation active", "The device is in simulation mode and the level output is not representative of the process." },
        { 0x02, "Non-Volatile memory failure", "The Non-Volatile memory check is invalid or maybe corrupt, or the battery of a battery-backed memory has failed." },
        { 0x04, "Volatile memory error", "The RAM memory check is invalid or maybe corrupt" },
        { 0x08, "Watchdog reset executed", "A watchdog reset has been performed" },
        { 0x10, "Voltage conditions out of range", "A voltage condition is outside its allowable range" },
        { 0x20, "Environmental conditions out of range" , "An internal or environmental condition is beyond acceptable limits." },
        { 0x40, "Electronic failure", "A hardware problem not related to the sensor has been detected." }
    }
}

/**********************************************************************
 * Tables 30 Standardized Status 1 Codes
 */
VARIABLE standardized_status_1_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED //Note:  All tables are described using ENUMERATED even though they will be used in actual DD as a BIT_ENUMERATED
    {
        { 0x01, [reserved] }
    }
}

/**********************************************************************
 * Tables 31 Standardized Status 2 Codes
 */
VARIABLE standardized_status_2_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED //Note:  All tables are described using ENUMERATED even though they will be used in actual DD as a BIT_ENUMERATED
    {
        { 0x01, "Subdevice list changed" },
        { 0x02, "Duplicate master detected" } 
    }
}

/**********************************************************************
 * Tables 32 Standardized Status 3 Codes
 */
VARIABLE standardized_status_3_codes        //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED //Note:  All tables are described using ENUMERATED even though they will be used in actual DD as a BIT_ENUMERATED
    {
       { 0x01, "Capacity Denied", "The device was unable to acquire the communication bandwidth required to support the Burst Messaging specified" },
       { 0x04, "Bandwidth allocation pending" },
       { 0x08, "Block transfer pending" }
    }
}

/**********************************************************************
 * Tables 33 Burst Message Trigger Mode Codes
 */
VARIABLE burst_message_trigger_mode_codes       //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Continuous", "The Burst Message is published continuously at (worst case) the Minimum Update Period." },
        { 1, "Window", "The Burst Message is triggered when the source value deviates more than the specified trigger value" },
        { 2, "Rising", "The Burst Message is triggered when source value Rises Above the specified trigger value." },
        { 3, "Falling", "The Burst Message is triggered when the source value Falls Below the specified trigger value." },
        { 4, "On-change", "The Burst Message is triggered when any value in the message changes." }
    }
}

/**********************************************************************
 * Tables 34 Device Variable Code Codes
 *
 * Additional codes added to deviceVariables array - 
 * add this to a macro for users to use in deviceVariables def
 */
VARIABLE device_variable_code_codes
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 243, "Battery life" },        //unit always in days
        { 244, "Percent range" },
        { 245, "Loop current" },
        { 246, "Primary variable" },
        { 247, "Secondary variable" },
        { 248, "Tertiary variable" },
        { 249, "Quaternary variable" }
    }
}

/**********************************************************************
 * Tables 35 Event Notification Control Codes
 */
VARIABLE event_nofication_control_codes         //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Off"},  
        { 1, "Enable event notification on token-passing data link layer" },  
        { 2, "Enable event notification on TDMA data link layer" },  
        { 3, "Enable event notification on TDMA and token-passing data link layer" }  

    }
}

/**********************************************************************
 * Tables 36 Event Status Codes
 */
VARIABLE event_status_codes         //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED //Note:  All tables are described using ENUMERATED even though they will be used in actual DD as a BIT_ENUMERATED
    {
        { 0x01, "Configuration changed event pending" },  
        { 0x02, "Device status event pending" },
        { 0x04, "More status available event pending" }  

    }
}

/**********************************************************************
 * Tables 37 Trend Control Codes
 */
VARIABLE trend_control_codes         //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Disable" },
        { 1, "Enable single data point trending" },  
        { 2, "Enable filtered trending", "The sample is filtered using a time constant equal to "
                                         "one-third the trend sample period" },  
        { 3, "Enable average trending", "The value obtained by dividing the sum of all samples "
                                        "in the period by the total number of samples" }  
    }
}

/**********************************************************************
 * Tables 38 Time Set Codes
 */
VARIABLE time_set_codes         //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Read receive time" },    
        { 1, "Write date and time" }  

    }
}


// Table 39 not defined as no DD model used
// Table 40 not defined as no DD model used
// Table 41 not defined as no DD model used

/**********************************************************************
 * Tables 42 Real Time Clock Flag Codes
 */
VARIABLE real_time_clock_flag_codes         //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x01, "Non-Volatile Clock", 
            "When set the device contains a battery-backed clock. In this case, the clock does not need to be reset if there is a power failure." },
        { 0x02, "Clock Uninitialized",
            "The real-time clock has never been set with the date and time. For example, the clock is volatile and power was removed from and restored to the device." }

    }
}

// Table 43 not defined as not in DD model

/**********************************************************************
 * Tables 44 Power Source Codes
 */
VARIABLE power_source_codes 
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Line Power", "Device is powered via a hardwired connection to a plant power source." },
        { 1, "Battery Power", "Device operates solely of its (internal) battery." },
        { 2, "Recharg.B./Power Sc.", "Rechargeable battery power or power scavenging. The device has a "
                                     "short-term supply of energy (must be at least one hour) that is "
                                     "continuously being replenished. The device's power is being replenished "
                                     "by harvesting and converting energy from the environment surrounding the "
                                     "device (e.g. solar, vibration, heat)." }
    }
}

// Table 45 not defined as no dd model
// Table 46 not defined as no dd model
// Table 47 not defined as no dd model
// Table 48 not defined as no dd model
// Table 49 not defined as no dd model
// Table 50 not defined as no dd model
 
/**********************************************************************
 * Tables 51 Wireless Operation Mode Codes
 */
VARIABLE wireless_operation_mode_codes      //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Idle" },
        { 1, "Active search", "Looking for neighbors." },
        { 2, "Negotiating" },
        { 3, "Quarantined" },
        { 4, "Operational" },
        { 5, "Suspended" }
        { 6, "Deep sleep", "Ultra-low power" }
    }
}

/**********************************************************************
 * Tables 52 Join Process Status Codes
 */
VARIABLE join_process_status_codes      //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x0001, "Wireless Signal Found", "Network packets have been recognized" },
        { 0x0002, "Wireless Signal Identified" },
        { 0x0004, "Wireless Time Synchronized" },
        { 0x0008, "WirelessHart Signal Identified" },
        { 0x0010, "Network Admission Requested", " Set on transmission of first join request" },
        { 0x0020, "Join Retrying" , "Set after the first join request retry (i.e. when number of join requests > 2). Cleared when device is authenticated or when Active Search started." },
        { 0x0040, "Join Failed" , "Set on transition from Active Search mode to Deep Sleep mode. Cleared on transition from Deep Sleep to Active Search."},
        { 0x0080, "Network Security Clearance Granted", "Network Manager Session Established" },
        { 0x0100, "Network Joined", "Network Joined. Normal superframe and links obtained." },
        { 0x0200, "Network Bandwidth Requested", "Negotiating Network Properties. Gateway session obtained. " },
        { 0x0400, "Join Complete", "Normal operating mode." }
   }
}

// Table 53 not defined 

/**********************************************************************
 * Tables 54. SI Control Codes
 */
VARIABLE si_control_codes       //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "None", "No restrictions" },
        { 1, "SI Only", "Restricted to SI Unit codes only" }

    }
}

// Table 55 not defined as no DD model for gateways

/**********************************************************************
 * Tables 56. Network Access Mode Codes
 */
VARIABLE network_access_mode_codes       //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Open - accept all devices" },
        { 1, "Use Whitelist for access" },
        { 2, "Use Blacklist" },
        { 3, "Use Whitelist and Blacklist" },
        { 4, "Lockdown - disable join links" }
    }
}

/**********************************************************************
 * Tables 57. Device Profile Codes
 */
VARIABLE device_profile_codes       //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 1,   "Process automation device" },
        { 2,   "Discrete device" }
        { 3,   "Hybrid:Process automation+discrete" },
        { 4,   "I/O System" },
        { 129, "WirelessHART Process automation device" },
        { 130, "WirelessHART Discrete device" },
        { 131, "WirelessHART Process automation+discrete" },
        { 132, "WirelessHART Gateway" },
        { 140, "WirelessHART Access point" },
        { 141, "WirelessHART Process adapter" },
        { 142, "WirelessHART Discrete adapter" },
        { 144, "WirelessHART enabled handheld/portable maintenance tool" }
    }
}

// Table 58 not defined as no DD model
// Table 59 not defined as no DD model
// Table 60 not defined asno DD model

/**********************************************************************
 * Tables 61. Join Mode Codes
 */
VARIABLE join_mode_codes            //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Don't attempt to join" },
        { 1, "Join now" },
        { 2, "Attempt to join immediately on powerup or reset" }
    }
}

// Table 62 not defined as no DD model
// Table 63 not defined as no DD model

/**********************************************************************
 * Process Data Status
 * not a table but probably should be one!
 */
VARIABLE process_data_status
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [bad] },  
        { 1, [poor_accuracy] },
        { 2, [manual_fixed] },
        { 3, [good] } 
    }
}
 
/**********************************************************************
 * Limit Status
 * not a table but probably should be one!
 */
VARIABLE limit_status
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, [not_limited] },  
        { 1, [low_limited] },
        { 2, [high_limited] },
        { 3, [constant] }
    }
}

/**********************************************************************
 * Device Family Status
 */
VARIABLE device_family_status
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0x08, [more_device_family_status_available] }
    }
}

// Country codes and numbers from ISO-3166 defined at http://www.davros.org/misc/iso3166.txt

VARIABLE country_code_codes     //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED (2)
    {
        { 0x5553, "US", "United States of America" },  //2 character ASCII code for US is 0x5553
        { 0x4a50, "JP", "Japan" },
        { 0x4445, "DE", "Germany" },
        { 0x4652, "FR", "France" },
        { 0x4553, "ES", "Spain" },
        { 0x5255, "RU", "Russian Federation" },
        { 0x434e, "CN", "People's Republic of China" }
    }
}

// refer to common table 58 - Device Power Status
VARIABLE device_power_status_codes 
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Nominal", "Device Power Status is nominal" },
        { 1, "Low", "Device Power Status is low" },
        { 2, "Critically Low", "Device Power Status is critically low" },
        { 3, "Recharging - Low", "Recharging - Low" },
        { 4, "Recharging - High", "Recharging - High" }
    }
}

VARIABLE master_mode_code       //Standard dictionary
{
    CLASS LOCAL;
    TYPE ENUMERATED
    {
        { 0, "Secondary", "Secondary Master" },
        { 1, "Primary",   "Primary Master"   }

    }
}

/**************************************************
 **                                              **
 **   The following variables model data         **
 **   contained in the field device in order to  **
 **   allow for easier distribution of table     **
 **   and enumeration item changes without       **
 **   having to retokenize the universal,        **
 **   common practice, and wireless DDs.         **
 **                                              **
 **   Care must be taken to all who import these **
 **   items such that the appropriate COMMANDS   **
 **   and supporting data are imported from the  **
 **   respective DDs.  To help facilitate this,  **
 **   MACROS are provided in macros.h to import  **
 **   the proper items based on the              **
 **   functionality of the device.               **
 **                                              **
 **************************************************/

/*****************************************************************************
 * All COMMAND REPLY declarations must include this VARIABLE as the second
 * parameter.
 *
 * This VARIABLE provides status on the health of the device as a whole. For
 * more information see "Command Summary Specification"
 *****************************************************************************
 */
VARIABLE device_status
{
    LABEL [field_device_status];
    HELP [field_device_status_help];
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, [PV_out_of_limits],             DV1 (AUTO & BAD) },
        { 0x02, [Non_PV_out_of_limits],         DV2 (AUTO & BAD) },
        { 0x04, "PV Analog Channel Saturated",  AO1 (AUTO & BAD) },
        { 0x08, "PV Analog Channel Fixed",      AO1 (MANUAL & GOOD) },
        { 0x10, [more_status_available],        MORE },
        { 0x20, [cold_start],                   MISC },
        { 0x40, [configuration_changed],        MISC },
        { 0x80, [device_malfunction],           MORE}
    }
}

/**********************************************************************
 * This VARIABLE indicate the company actually made the field device. 
 * the value of This VARIABLE may or may not be the same as the value 
 * of the private_label_distributor.
 *
 * NOTE: the HART Protocol requires masters to display the 
 *      private_label_distributor and not the manufacturer_id
 *
 * Used in CMD 0
 */
manufacturer_id LIKE VARIABLE company_identification_code
{
    REDEFINE LABEL [manufacturer_id];
    REDEFINE HELP [manufacturer_id_code_help];
    REDEFINE CLASS HART;  // Need to redefine - company_identification_code is class LOCAL
    REDEFINE HANDLING READ;
}

/**********************************************************************
 * This VARIABLE indicate the company actually distributing the 
 * field device.  The value of This VARIABLE may or may not be the same
 * manufacturer_id.
 *
 * Used in CMD 0
 */
private_label_distributor LIKE VARIABLE company_identification_code
{
    REDEFINE LABEL [private_label_distributor];
    REDEFINE HELP [private_label_distributor_help];
    REDEFINE CLASS DEVICE;  // Need to redefine - company_identification_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*********************************************************************************
 * The combination of the one byte device_type variable along with the one byte 
 * variable manufacturer_id" combines to form the expanded device type code. This
 * code will have only one unique Device Description.
 *
 * Used in CMD 0
 */
device_type LIKE VARIABLE device_type_code
{
    REDEFINE LABEL [device_type];
    REDEFINE HELP [manufacturers_device_type_help];
    REDEFINE CLASS HART;  // Need to redefine - device_type_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*********************************************************************
 *   Write protect locks configuration changes from occurring in the
 *   device.  Assume to be hardware jumper/switch. DD developer should
 *   redefine handling to READ & WRITE if the device has software
 *   configurable write protection.
 *
 *  Used in CMD 15, and possibly device specific write command
 */
VARIABLE write_protect
{
    LABEL [write_protect];
    HELP [write_protect_mode_help];
    CLASS DEVICE;
    HANDLING READ;
    TYPE ENUMERATED
    {
        WRITE_PROTECT_CODE(0),  /* Not Write Protected */
        WRITE_PROTECT_CODE(1),  /* Write Protected */
        WRITE_PROTECT_CODE(251) /* None */
    }
}

/* ********************************************************************
 * Used in CMD 0
 */
VARIABLE physical_signaling_code
{
    LABEL [physical_signalling_code];
    HELP [physical_signalling_code_help];
    CLASS DEVICE;
    HANDLING READ;
    TYPE ENUMERATED
    {
        PHYSICAL_SIGNALING_CODE(0),
        PHYSICAL_SIGNALING_CODE(1),
        PHYSICAL_SIGNALING_CODE(2), 
        PHYSICAL_SIGNALING_CODE(3),
        PHYSICAL_SIGNALING_CODE(4),
        PHYSICAL_SIGNALING_CODE(6) 
    }
}

/*****************************************************************************
 * Operating mode allows the Protocol to (in the future) descibe various
 * possible field device modes of operations.  The enumeration corresponds
 * to those allowed by the common tables
 *
 * the enumerations are only added by the HCF Common Tables WG.  Undefined
 * enumeration must not be used
 *
 * Not used at this time
 */
VARIABLE operatingMode
{
    LABEL [operating_mode_1];
    HELP [operating_mode_1_help];
    CLASS DEVICE & DIAGNOSTIC;
    HANDLING READ;
    TYPE ENUMERATED
    {
        OPERATING_MODE_CODE(0)   /* Normal */
    }
}

/* ********************************************************************
 *  Used in CMDs 6 & 7
 */
VARIABLE loop_current_mode
{
    LABEL [loop_current_mode];
    HELP [loop_current_mode_help];
    CLASS ANALOG_CHANNEL;
    TYPE ENUMERATED 
    {
        LOOP_CURRENT_MODE_CODE(0), 
        LOOP_CURRENT_MODE_CODE(1)
    }
}

/* ********************************************************************
 *  Used in CMD 0
 */
VARIABLE device_flags
{
    LABEL [device_flags];
    HELP [field_device_flags_help];
    CLASS DEVICE;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        FLAG_ASSIGNMENT(0x01),
        FLAG_ASSIGNMENT(0x02),
        FLAG_ASSIGNMENT(0x04),
        FLAG_ASSIGNMENT(0x08),
        FLAG_ASSIGNMENT(0x40),
        FLAG_ASSIGNMENT(0x80)
    }
}

/*****************************************************************************
 * Used in Command 0 (HART 6 and later), 9, 48
 */
VARIABLE extended_fld_device_status     // see table 17
{
    LABEL [extended_field_device_status];
    HELP [extended_field_device_status_help];
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {     
        { 0x01, extended_device_status_codes(0x01), HARDWARE },
        { 0x02, extended_device_status_codes(0x02), SOFTWARE },
        { 0x04, extended_device_status_codes(0x04), HARDWARE }
    }
}


/*****************************************************************************
 * This variable describes the type of device the host is communicating with
 * so that a host can "know" what commands are supported in the device. Most
 * useful when a host doesn't have the DD for the device but must work
 * generically.
 *
 *  Used in CMD 0 for HART7 and later
 *****************************************************************************
 */
VARIABLE device_profile
{
    LABEL "Device Profile";
    HELP "";
    CLASS DEVICE;
    HANDLING READ;
    TYPE ENUMERATED
    {
        { 1,   device_profile_codes(1) },   // HART Process Automation Device
        { 2,   device_profile_codes(2) },   // Discrete Device
        { 3,   device_profile_codes(3) },   // Hybrid:Process automation+discrete
        { 4,   device_profile_codes(4) },   // I/O System
        { 129, device_profile_codes(129) }, // WirelessHART process automation device
        { 130, device_profile_codes(130) }, // WirelessHART discrete device     
        { 131, device_profile_codes(131) }, // WirelessHART process automation+discrete    
        { 132, device_profile_codes(132) }, // WirelessHART gateway   
        { 140, device_profile_codes(140) }, // WirelessHART access point  
        { 141, device_profile_codes(141) }, // WirelessHART process adapter  
        { 142, device_profile_codes(142) }, // WirelessHART discrete adapter 
        { 144, device_profile_codes(144) }  // WirelessHART enabled handheld/portable maintenance tool
    }
}

/*****************************************************************************
 * Command 48 table-variables
 */
VARIABLE standardized_status_0          // see table 29
{
    LABEL "Device Diagnostic Status 0";       //Standard dictionary
    HELP "";
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, standardized_status_0_codes(0x01), MODE },
        { 0x02, standardized_status_0_codes(0x02), HARDWARE }, 
        { 0x04, standardized_status_0_codes(0x04), HARDWARE },
        { 0x08, standardized_status_0_codes(0x08), HARDWARE & SOFTWARE }, // MISC if this doesn't work
        { 0x10, standardized_status_0_codes(0x10), HARDWARE }, 
        { 0x20, standardized_status_0_codes(0x20), MISC },
        { 0x40, standardized_status_0_codes(0x40), HARDWARE } 
    }
}

VARIABLE standardized_status_1          // see table 30
{
    LABEL "Device Diagnostic Status 1";       //Standard dictionary
    HELP "";
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, standardized_status_1_codes(0x01), MISC }
    }
}

VARIABLE standardized_status_2          // see table 31
{
    LABEL "I/O and Subdevice Status";       // Standard dictionary
    HELP "";
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, standardized_status_2_codes(0x01), PROCESS },
        { 0x02, standardized_status_2_codes(0x02), MISC }
    }
}

VARIABLE standardized_status_3          // see table 32
{
    LABEL "WirelessHART Status";       // Standard dictionary
    HELP "";
    CLASS HART & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, standardized_status_3_codes(0x01), DATA },
        { 0x04, standardized_status_3_codes(0x04), MISC },
        { 0x08, standardized_status_3_codes(0x08), MISC }
    }
}

VARIABLE analog_channel_saturated1      // see table 27
{
    LABEL [analog_output_saturated];
    HELP [analog_output_saturated_help];
    CLASS DEVICE & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, analog_channel_saturated_codes(0x01), AO2(AUTO & BAD) },
        { 0x02, analog_channel_saturated_codes(0x02), AO3(AUTO & BAD) }, 
        { 0x04, analog_channel_saturated_codes(0x04), AO4(AUTO & BAD) }, 
        { 0x08, analog_channel_saturated_codes(0x08), AO5(AUTO & BAD) }
    }
}

VARIABLE analog_channel_fixed1      // see table 28
{
    LABEL [analog_output_fixed];
    HELP [analog_output_fixed_help];
    CLASS DEVICE & DYNAMIC & DIAGNOSTIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, analog_channel_fixed_codes(0x01), AO2(MANUAL & GOOD) },
        { 0x02, analog_channel_fixed_codes(0x02), AO3(MANUAL & GOOD) }, 
        { 0x04, analog_channel_fixed_codes(0x04), AO4(MANUAL & GOOD) },
        { 0x08, analog_channel_fixed_codes(0x08), AO5(MANUAL & GOOD) } 
    }
}

/*****************************************************************************
 * Command 89 & 90 table-variables
 */
VARIABLE time_set
{
    LABEL "Time Set Option";
    HELP "";
    CLASS DEVICE & SERVICE;
    HANDLING WRITE;
    TYPE ENUMERATED
    {
        { 0, time_set_codes(0) },
        { 1, time_set_codes(1) }
    }
}

/*****************************************************************************
 * Used in CMD 90
 */
VARIABLE real_time_clock_flag
{
    LABEL "Real Time Clock Flags";
    HELP "";
    CLASS DEVICE & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, real_time_clock_flag_codes(1) },
        { 0x02, real_time_clock_flag_codes(2) }
    }
}

/*****************************************************************************
 * Command 512 and 513 table-variables
 */
VARIABLE country_code
{
    LABEL "Country";
    HELP  "Country of intended device installation";
    CLASS DEVICE;
    TYPE ENUMERATED (2)
    {
        { 0x5553, country_code_codes(0x5553) },   // United States of America
        { 0x4a50, country_code_codes(0x4a50) },   // Japan
        { 0x4445, country_code_codes(0x4445) },   // Germany
        { 0x4652, country_code_codes(0x4652) },   // France
        { 0x4553, country_code_codes(0x4553) },   // Spain
        { 0x5255, country_code_codes(0x5255) },   // Russian Federation
        { 0x434e, country_code_codes(0x434e) }    // People's Republic of China
    }
}

/*****************************************************************************
 * Used in CMDs 512 and 513
 */
VARIABLE si_control
{
    LABEL "SI Unit Control";
    HELP  "Indicates if device should only display SI unit codes";
    CLASS DEVICE;
    TYPE ENUMERATED
    {
        { 0, si_control_codes(0) },  // No restriction
        { 1, si_control_codes(1) }   // Restricted to SI units
    }
}

/*****************************************************************************
 * Used in CMDs 104 & 105
 */
VARIABLE burst_trigger_units
{
    LABEL "Burst Trigger Units";
    HELP "";
    CLASS COMPUTATION;
    TYPE ENUMERATED
    {
        ALL_UNITS
    }
}

/*****************************************************************************
 * Used in CMDs 104 & 105
 */
VARIABLE burst_trigger_classification
{
    LABEL "Burst Trigger Class";
    HELP "";
    CLASS COMPUTATION;
    TYPE ENUMERATED
    {
        ALL_CLASSIFICATIONS
    }
}

/*****************************************************************************
 * Burst Message table-variables
 *
 * Used in CMDs 105 & 109
 */
VARIABLE burst_mode_select
{
    LABEL [burst_mode_select];
    HELP [burst_mode_select_help];
    CLASS HART;
    TYPE ENUMERATED
    {
        BURST_MODE_CONTROL_CODE(0),  /* Off */
        { 1,  "Wired HART Enabled", "Enabled on Wired HART device connection only" },
        { 2,  "Wireless HART Enabled",  "Enabled on WirelessHART device connection only" },
        { 3,  "Both Wired and WirelessHart Enabled", "Enabled on both Wired and WirelessHART connections" }
    }
}

/*****************************************************************************
 * Used in CMDs 104 & 105
 */
VARIABLE burst_message_trigger_mode
{
    LABEL "Burst Msg Trigger Mode";
    HELP "";
    CLASS HART;
    TYPE ENUMERATED
    {
        { 0, burst_message_trigger_mode_codes(0) },
        { 1, burst_message_trigger_mode_codes(1) },
        { 2, burst_message_trigger_mode_codes(2) },
        { 3, burst_message_trigger_mode_codes(3) },
        { 4, burst_message_trigger_mode_codes(4) }
    }
}

/*****************************************************************************
 * Event Notification table-variables
 *
 * Used in CMD 115
 */
VARIABLE event_status
{
    LABEL "Event Status";
    HELP "";
    CLASS HART & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, event_status_codes(1) },
        { 0x02, event_status_codes(2) },
        { 0x04, event_status_codes(4) }
    }
}

/*****************************************************************************
 * Used in CMDs 115 & 118
 */
VARIABLE event_notification_control_n
{
    LABEL "Event Notification Control";
    HELP "";
    CLASS HART;
    TYPE ENUMERATED
    {
       { 0, event_nofication_control_codes(0) },
       { 1, event_nofication_control_codes(1) },
       { 2, event_nofication_control_codes(2) },
       { 3, event_nofication_control_codes(3) }
    }
}

/*****************************************************************************
 * Event Masks
 *
 * Used in CMDs 115 & 116
 */
device_status_mask LIKE VARIABLE device_status
{
    REDEFINE LABEL "Device Status Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
extended_fld_device_status_mask LIKE VARIABLE extended_fld_device_status
{
    REDEFINE LABEL "Ext dev status Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
VARIABLE dev_operating_mode_mask //LIKE VARIABLE operatingMode
{
    LABEL "Operate mode Mask";
    HELP "";
    CLASS DEVICE;
    HANDLING READ & WRITE;
    TYPE BIT_ENUMERATED           //MASKS should be bit-enum not enum
    {
        {0x01, "Not Defined"}
    }
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
standardized_status_0_mask LIKE VARIABLE standardized_status_0
{
    REDEFINE LABEL "Device Diagnostic Status 0 Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
standardized_status_1_mask LIKE VARIABLE standardized_status_1
{
    REDEFINE LABEL "Device Diagnostic Status 1 Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
standardized_status_2_mask LIKE VARIABLE standardized_status_2
{
    REDEFINE LABEL "Device Diagnostic Status 2 Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
standardized_status_3_mask LIKE VARIABLE standardized_status_3
{
    REDEFINE LABEL "Device Diagnostic Status 3 Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
analog_channel_saturated1_mask LIKE VARIABLE analog_channel_saturated1
{
    REDEFINE LABEL "AO saturated Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMDs 115 & 116
 */
analog_channel_fixed1_mask LIKE VARIABLE analog_channel_fixed1
{
    REDEFINE LABEL "AO fixed Mask";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE;                 //Need to redefine because of LIKE
    REDEFINE HANDLING READ & WRITE;        //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
device_status_latched_value LIKE VARIABLE device_status
{
    REDEFINE LABEL "Latched Device Status";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
extended_fld_device_status_latched_value LIKE VARIABLE extended_fld_device_status
{
    REDEFINE LABEL "Latched Ext dev status";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
dev_operating_mode_latched_value LIKE VARIABLE operatingMode
{
    REDEFINE LABEL "Latched Operate Mode";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
standardized_status_0_latched_value LIKE VARIABLE standardized_status_0
{
    REDEFINE LABEL "Latched Device Diagnostic Status 0";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
standardized_status_1_latched_value LIKE VARIABLE standardized_status_1
{
    REDEFINE LABEL "Latched Device Diagnostic Status 1";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
standardized_status_2_latched_value LIKE VARIABLE standardized_status_2
{
    REDEFINE LABEL "Latched Device Diagnostic Status 2";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
standardized_status_3_latched_value LIKE VARIABLE standardized_status_3
{
    REDEFINE LABEL "Latched Device Diagnostic Status 3";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
analog_channel_saturated1_latched_value LIKE VARIABLE analog_channel_saturated1
{
    REDEFINE LABEL "Latched AO saturated";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 119
 */
analog_channel_fixed1_latched_value LIKE VARIABLE analog_channel_fixed1
{
    REDEFINE LABEL "Latched AO fixed";
    REDEFINE HELP "";
    REDEFINE CLASS DEVICE & DIAGNOSTIC;    //Need to redefine because of LIKE
    REDEFINE HANDLING WRITE;               //Need to redefine because of LIKE
}

/*****************************************************************************
 * Used in CMD 71
 */
VARIABLE lock_device_code
{
    LABEL [lock_device_code];
    HELP [lock_device_code_help];
    CLASS DEVICE;
    HANDLING WRITE;
    TYPE ENUMERATED
    {
        LOCK_DEVICE_CODE(0),
        LOCK_DEVICE_CODE(1),
        LOCK_DEVICE_CODE(2),
        { 3, lock_device_codes(3) }
    }
}

/*****************************************************************************
 * Used in CMD 76
 */
VARIABLE lock_device_status_code
{
    LABEL [lock_device_status_code];
    HELP [lock_device_code_help];
    CLASS DEVICE;
    HANDLING READ;
    TYPE BIT_ENUMERATED
    {
        { 0x01, lock_device_status_codes(0x01) },
        { 0x02, lock_device_status_codes(0x02) },
        { 0x04, lock_device_status_codes(0x04) },
        { 0x08, lock_device_status_codes(0x08) },
        { 0x10, lock_device_status_codes(0x10) }
    }
}

/*****************************************************************************
 * Used in CMD 777
 */
VARIABLE power_source // refer to common table 44 - Device Power Source
{
    LABEL "Power Source";
    HELP "Power source of the device";
    CLASS HART;
    HANDLING READ;
    TYPE ENUMERATED
    {
        { 0, power_source_codes(0) },
        { 1, power_source_codes(1) },
        { 2, power_source_codes(2) }
    }
}

/*****************************************************************************
 * Used in CMD 769
 */
VARIABLE wireless_mode
{
    LABEL "Wireless Mode";
    HELP "";
    CLASS DEVICE & DYNAMIC;
    HANDLING READ;
    TYPE ENUMERATED
    {
        { 0, wireless_operation_mode_codes(0) },
        { 1, wireless_operation_mode_codes(1) },
        { 2, wireless_operation_mode_codes(2) },
        { 3, wireless_operation_mode_codes(3) },
        { 4, wireless_operation_mode_codes(4) },
        { 5, wireless_operation_mode_codes(5) },
        { 6, wireless_operation_mode_codes(6) }
    }
}

/*****************************************************************************
 * Used in CMD 769
 */
VARIABLE join_status
{
    LABEL "Join Status";
    HELP "The current location in the joining sequence of operations.";
    CLASS DEVICE & DYNAMIC;
    HANDLING READ;
    TYPE BIT_ENUMERATED (2)
    {
        { 0x0001, join_process_status_codes(0x0001) },
        { 0x0002, join_process_status_codes(0x0002) },
        { 0x0004, join_process_status_codes(0x0004) },
        { 0x0008, join_process_status_codes(0x0008) },
        { 0x0010, join_process_status_codes(0x0010) },
        { 0x0020, join_process_status_codes(0x0020) },
        { 0x0040, join_process_status_codes(0x0040) },
        { 0x0080, join_process_status_codes(0x0080) },
        { 0x0100, join_process_status_codes(0x0100) },
        { 0x0200, join_process_status_codes(0x0200) },
        { 0x0400, join_process_status_codes(0x0400) }
    }
}

/*****************************************************************************
 * Used in CMDs 821 & 822
 */
VARIABLE network_access_mode
{
    LABEL "Network Access Mode";
    HELP "";
    CLASS HART;
    TYPE ENUMERATED
    {
        { 0, network_access_mode_codes(0) },
        { 1, network_access_mode_codes(1) },
        { 2, network_access_mode_codes(2) },
        { 3, network_access_mode_codes(3) },
        { 4, network_access_mode_codes(4) }
    }
}

/*****************************************************************************
 * Used in CMDs 771 & 772
 */
VARIABLE join_mode
{
    LABEL "Join Mode";
    HELP "";
    CLASS HART;
    TYPE ENUMERATED
    {
        { 0, join_mode_codes(0) },
        { 1, join_mode_codes(1) },
        { 2, join_mode_codes(2) }
    }
}

/*****************************************************************************
 * Used in CMDs 779
 */
VARIABLE device_power_status // refer to common table 58 - Device Power Status
{
    LABEL "Power Status";
    HELP "Power status of the device";
    CLASS DEVICE & DYNAMIC;
    HANDLING READ;
    TYPE ENUMERATED
    {
        { 0, device_power_status_codes(0) },
        { 1, device_power_status_codes(1) },
        { 2, device_power_status_codes(2) },
        { 3, device_power_status_codes(3) },
        { 4, device_power_status_codes(4) }
    }
}

/*********************************************************************************
 * The wireless device type uses the same list of devices as the device type.
 *
 * Used in CMD 64,512
 */
wireless_module_device_type LIKE VARIABLE device_type_code
{
    REDEFINE LABEL "Wireless Module Device Type";
    REDEFINE HELP "Device type of the Wireless Radio";
    REDEFINE CLASS HART;  // Need to redefine - device_type_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*********************************************************************************
 * The wireless manufacturer code uses the same list of manufacturers as the device type.
 *
 * Used in CMD 64,512
 */
wireless_module_manufacturer_id LIKE VARIABLE company_identification_code
{
    REDEFINE LABEL "Wireless Module Manufacturer ID";
    REDEFINE HELP "Manufacturer of the Wireless Radio contained in this device";
    REDEFINE CLASS HART;  // Need to redefine - company_identification_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*****************************************************************************
 * Used in CMDs 74 & 87
 */
VARIABLE master_mode
{
    LABEL "Master Mode";
    HELP  "This sets the I/O System's Data Link Layer operation on all channels as either primary or secondary master mode.";
    CLASS HART;
    TYPE ENUMERATED
    {
        { 1, master_mode_code(1) },  //Primary (1) is default
        { 0, master_mode_code(0) }
    }
}

/*********************************************************************************
 * The sub-device type uses the same list of devices as the device type. 
 *
 * Used in CMD 84
 */
subdev_expanded_device_type LIKE VARIABLE device_type_code
{
    REDEFINE LABEL "Subdevice Device Type";
    REDEFINE HELP "Device type of the subdevice attached to this system.";
    REDEFINE CLASS HART;  // Need to redefine - device_type_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*********************************************************************************
 * The sub-device manufacturer code uses the same list of manufacturers as the device type. 
 *
 * Used in CMD 84
 */
subdev_manufacturer_id LIKE VARIABLE company_identification_code
{
    REDEFINE LABEL "Subdevice Manufacturer Id";
    REDEFINE HELP "Manufacturer of the subdevice attached to this system.";
    REDEFINE CLASS HART;  // Need to redefine - company_identification_code is class LOCAL
    REDEFINE HANDLING READ;
}

/*****************************************************************************
 * Used in CMD 93
 */
VARIABLE trend_digital_units
{
     LABEL "Trend Units";
     HELP "Trend Device Variable Unit Code";
     CLASS DEVICE & SERVICE;
     HANDLING READ;
     TYPE ENUMERATED
     {
        ALL_UNITS
     }
     
}

/*****************************************************************************
 * Used in CMD 93
 */
VARIABLE trend_classification
{
    LABEL "Trend Classification";
    HELP "Trend Device Variable Classification";
    CLASS DEVICE & SERVICE;
    HANDLING READ;
    TYPE ENUMERATED 
    {
        ALL_CLASSIFICATIONS
    }
}

/*****************************************************************************
 * Used in CMDs 91 & 92
 */
VARIABLE trend_control
{
    LABEL "Trend Control";
    HELP "";
    CLASS HART & SERVICE;
    TYPE ENUMERATED
    {
       { 0, trend_control_codes(0) },
       { 1, trend_control_codes(1) },
       { 2, trend_control_codes(2) },
       { 3, trend_control_codes(3) }
    }
}
